import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorOriginGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#cdn_frontdoor_profile_id CdnFrontdoorOriginGroup#cdn_frontdoor_profile_id}
    */
    readonly cdnFrontdoorProfileId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#id CdnFrontdoorOriginGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#name CdnFrontdoorOriginGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#restore_traffic_time_to_healed_or_new_endpoint_in_minutes CdnFrontdoorOriginGroup#restore_traffic_time_to_healed_or_new_endpoint_in_minutes}
    */
    readonly restoreTrafficTimeToHealedOrNewEndpointInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#session_affinity_enabled CdnFrontdoorOriginGroup#session_affinity_enabled}
    */
    readonly sessionAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
    * health_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#health_probe CdnFrontdoorOriginGroup#health_probe}
    */
    readonly healthProbe?: CdnFrontdoorOriginGroupHealthProbe;
    /**
    * load_balancing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#load_balancing CdnFrontdoorOriginGroup#load_balancing}
    */
    readonly loadBalancing: CdnFrontdoorOriginGroupLoadBalancing;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#timeouts CdnFrontdoorOriginGroup#timeouts}
    */
    readonly timeouts?: CdnFrontdoorOriginGroupTimeouts;
}
export interface CdnFrontdoorOriginGroupHealthProbe {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#interval_in_seconds CdnFrontdoorOriginGroup#interval_in_seconds}
    */
    readonly intervalInSeconds: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#path CdnFrontdoorOriginGroup#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#protocol CdnFrontdoorOriginGroup#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#request_type CdnFrontdoorOriginGroup#request_type}
    */
    readonly requestType?: string;
}
export declare function cdnFrontdoorOriginGroupHealthProbeToTerraform(struct?: CdnFrontdoorOriginGroupHealthProbeOutputReference | CdnFrontdoorOriginGroupHealthProbe): any;
export declare class CdnFrontdoorOriginGroupHealthProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorOriginGroupHealthProbe | undefined;
    set internalValue(value: CdnFrontdoorOriginGroupHealthProbe | undefined);
    private _intervalInSeconds?;
    get intervalInSeconds(): number;
    set intervalInSeconds(value: number);
    get intervalInSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _requestType?;
    get requestType(): string;
    set requestType(value: string);
    resetRequestType(): void;
    get requestTypeInput(): string | undefined;
}
export interface CdnFrontdoorOriginGroupLoadBalancing {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#additional_latency_in_milliseconds CdnFrontdoorOriginGroup#additional_latency_in_milliseconds}
    */
    readonly additionalLatencyInMilliseconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#sample_size CdnFrontdoorOriginGroup#sample_size}
    */
    readonly sampleSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#successful_samples_required CdnFrontdoorOriginGroup#successful_samples_required}
    */
    readonly successfulSamplesRequired?: number;
}
export declare function cdnFrontdoorOriginGroupLoadBalancingToTerraform(struct?: CdnFrontdoorOriginGroupLoadBalancingOutputReference | CdnFrontdoorOriginGroupLoadBalancing): any;
export declare class CdnFrontdoorOriginGroupLoadBalancingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorOriginGroupLoadBalancing | undefined;
    set internalValue(value: CdnFrontdoorOriginGroupLoadBalancing | undefined);
    private _additionalLatencyInMilliseconds?;
    get additionalLatencyInMilliseconds(): number;
    set additionalLatencyInMilliseconds(value: number);
    resetAdditionalLatencyInMilliseconds(): void;
    get additionalLatencyInMillisecondsInput(): number | undefined;
    private _sampleSize?;
    get sampleSize(): number;
    set sampleSize(value: number);
    resetSampleSize(): void;
    get sampleSizeInput(): number | undefined;
    private _successfulSamplesRequired?;
    get successfulSamplesRequired(): number;
    set successfulSamplesRequired(value: number);
    resetSuccessfulSamplesRequired(): void;
    get successfulSamplesRequiredInput(): number | undefined;
}
export interface CdnFrontdoorOriginGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#create CdnFrontdoorOriginGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#delete CdnFrontdoorOriginGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#read CdnFrontdoorOriginGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group#update CdnFrontdoorOriginGroup#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorOriginGroupTimeoutsToTerraform(struct?: CdnFrontdoorOriginGroupTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorOriginGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorOriginGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorOriginGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group azurerm_cdn_frontdoor_origin_group}
*/
export declare class CdnFrontdoorOriginGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_origin_group";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/cdn_frontdoor_origin_group azurerm_cdn_frontdoor_origin_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorOriginGroupConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorOriginGroupConfig);
    private _cdnFrontdoorProfileId?;
    get cdnFrontdoorProfileId(): string;
    set cdnFrontdoorProfileId(value: string);
    get cdnFrontdoorProfileIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _restoreTrafficTimeToHealedOrNewEndpointInMinutes?;
    get restoreTrafficTimeToHealedOrNewEndpointInMinutes(): number;
    set restoreTrafficTimeToHealedOrNewEndpointInMinutes(value: number);
    resetRestoreTrafficTimeToHealedOrNewEndpointInMinutes(): void;
    get restoreTrafficTimeToHealedOrNewEndpointInMinutesInput(): number | undefined;
    private _sessionAffinityEnabled?;
    get sessionAffinityEnabled(): boolean | cdktf.IResolvable;
    set sessionAffinityEnabled(value: boolean | cdktf.IResolvable);
    resetSessionAffinityEnabled(): void;
    get sessionAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _healthProbe;
    get healthProbe(): CdnFrontdoorOriginGroupHealthProbeOutputReference;
    putHealthProbe(value: CdnFrontdoorOriginGroupHealthProbe): void;
    resetHealthProbe(): void;
    get healthProbeInput(): CdnFrontdoorOriginGroupHealthProbe | undefined;
    private _loadBalancing;
    get loadBalancing(): CdnFrontdoorOriginGroupLoadBalancingOutputReference;
    putLoadBalancing(value: CdnFrontdoorOriginGroupLoadBalancing): void;
    get loadBalancingInput(): CdnFrontdoorOriginGroupLoadBalancing | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorOriginGroupTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorOriginGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorOriginGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
