import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryTokenPasswordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#container_registry_token_id ContainerRegistryTokenPassword#container_registry_token_id}
    */
    readonly containerRegistryTokenId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#id ContainerRegistryTokenPassword#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * password1 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#password1 ContainerRegistryTokenPassword#password1}
    */
    readonly password1: ContainerRegistryTokenPasswordPassword1;
    /**
    * password2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#password2 ContainerRegistryTokenPassword#password2}
    */
    readonly password2?: ContainerRegistryTokenPasswordPassword2;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#timeouts ContainerRegistryTokenPassword#timeouts}
    */
    readonly timeouts?: ContainerRegistryTokenPasswordTimeouts;
}
export interface ContainerRegistryTokenPasswordPassword1 {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#expiry ContainerRegistryTokenPassword#expiry}
    */
    readonly expiry?: string;
}
export declare function containerRegistryTokenPasswordPassword1ToTerraform(struct?: ContainerRegistryTokenPasswordPassword1OutputReference | ContainerRegistryTokenPasswordPassword1): any;
export declare class ContainerRegistryTokenPasswordPassword1OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTokenPasswordPassword1 | undefined;
    set internalValue(value: ContainerRegistryTokenPasswordPassword1 | undefined);
    private _expiry?;
    get expiry(): string;
    set expiry(value: string);
    resetExpiry(): void;
    get expiryInput(): string | undefined;
    get value(): string;
}
export interface ContainerRegistryTokenPasswordPassword2 {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#expiry ContainerRegistryTokenPassword#expiry}
    */
    readonly expiry?: string;
}
export declare function containerRegistryTokenPasswordPassword2ToTerraform(struct?: ContainerRegistryTokenPasswordPassword2OutputReference | ContainerRegistryTokenPasswordPassword2): any;
export declare class ContainerRegistryTokenPasswordPassword2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTokenPasswordPassword2 | undefined;
    set internalValue(value: ContainerRegistryTokenPasswordPassword2 | undefined);
    private _expiry?;
    get expiry(): string;
    set expiry(value: string);
    resetExpiry(): void;
    get expiryInput(): string | undefined;
    get value(): string;
}
export interface ContainerRegistryTokenPasswordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#create ContainerRegistryTokenPassword#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#delete ContainerRegistryTokenPassword#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#read ContainerRegistryTokenPassword#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password#update ContainerRegistryTokenPassword#update}
    */
    readonly update?: string;
}
export declare function containerRegistryTokenPasswordTimeoutsToTerraform(struct?: ContainerRegistryTokenPasswordTimeouts | cdktf.IResolvable): any;
export declare class ContainerRegistryTokenPasswordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTokenPasswordTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryTokenPasswordTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password azurerm_container_registry_token_password}
*/
export declare class ContainerRegistryTokenPassword extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_registry_token_password";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/container_registry_token_password azurerm_container_registry_token_password} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryTokenPasswordConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryTokenPasswordConfig);
    private _containerRegistryTokenId?;
    get containerRegistryTokenId(): string;
    set containerRegistryTokenId(value: string);
    get containerRegistryTokenIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password1;
    get password1(): ContainerRegistryTokenPasswordPassword1OutputReference;
    putPassword1(value: ContainerRegistryTokenPasswordPassword1): void;
    get password1Input(): ContainerRegistryTokenPasswordPassword1 | undefined;
    private _password2;
    get password2(): ContainerRegistryTokenPasswordPassword2OutputReference;
    putPassword2(value: ContainerRegistryTokenPasswordPassword2): void;
    resetPassword2(): void;
    get password2Input(): ContainerRegistryTokenPasswordPassword2 | undefined;
    private _timeouts;
    get timeouts(): ContainerRegistryTokenPasswordTimeoutsOutputReference;
    putTimeouts(value: ContainerRegistryTokenPasswordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerRegistryTokenPasswordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
