import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApplicationGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/application_gateway#id DataAzurermApplicationGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/application_gateway#name DataAzurermApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/application_gateway#resource_group_name DataAzurermApplicationGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/application_gateway#timeouts DataAzurermApplicationGateway#timeouts}
    */
    readonly timeouts?: DataAzurermApplicationGatewayTimeouts;
}
export interface DataAzurermApplicationGatewayBackendAddressPool {
}
export declare function dataAzurermApplicationGatewayBackendAddressPoolToTerraform(struct?: DataAzurermApplicationGatewayBackendAddressPool): any;
export declare class DataAzurermApplicationGatewayBackendAddressPoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayBackendAddressPool | undefined;
    set internalValue(value: DataAzurermApplicationGatewayBackendAddressPool | undefined);
    get fqdns(): string[];
    get id(): string;
    get ipAddresses(): string[];
    get name(): string;
}
export declare class DataAzurermApplicationGatewayBackendAddressPoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayBackendAddressPoolOutputReference;
}
export interface DataAzurermApplicationGatewayIdentity {
}
export declare function dataAzurermApplicationGatewayIdentityToTerraform(struct?: DataAzurermApplicationGatewayIdentity): any;
export declare class DataAzurermApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayIdentity | undefined;
    set internalValue(value: DataAzurermApplicationGatewayIdentity | undefined);
    get identityIds(): string[];
    get type(): string;
}
export declare class DataAzurermApplicationGatewayIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayIdentityOutputReference;
}
export interface DataAzurermApplicationGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/application_gateway#read DataAzurermApplicationGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApplicationGatewayTimeoutsToTerraform(struct?: DataAzurermApplicationGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApplicationGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApplicationGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermApplicationGatewayTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/application_gateway azurerm_application_gateway}
*/
export declare class DataAzurermApplicationGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_application_gateway";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/application_gateway azurerm_application_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApplicationGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApplicationGatewayConfig);
    private _backendAddressPool;
    get backendAddressPool(): DataAzurermApplicationGatewayBackendAddressPoolList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermApplicationGatewayIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermApplicationGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApplicationGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermApplicationGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
