import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCdnFrontdoorSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cdn_frontdoor_secret#id DataAzurermCdnFrontdoorSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cdn_frontdoor_secret#name DataAzurermCdnFrontdoorSecret#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cdn_frontdoor_secret#profile_name DataAzurermCdnFrontdoorSecret#profile_name}
    */
    readonly profileName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cdn_frontdoor_secret#resource_group_name DataAzurermCdnFrontdoorSecret#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cdn_frontdoor_secret#timeouts DataAzurermCdnFrontdoorSecret#timeouts}
    */
    readonly timeouts?: DataAzurermCdnFrontdoorSecretTimeouts;
}
export interface DataAzurermCdnFrontdoorSecretSecretCustomerCertificate {
}
export declare function dataAzurermCdnFrontdoorSecretSecretCustomerCertificateToTerraform(struct?: DataAzurermCdnFrontdoorSecretSecretCustomerCertificate): any;
export declare class DataAzurermCdnFrontdoorSecretSecretCustomerCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCdnFrontdoorSecretSecretCustomerCertificate | undefined;
    set internalValue(value: DataAzurermCdnFrontdoorSecretSecretCustomerCertificate | undefined);
    get keyVaultCertificateId(): string;
    get subjectAlternativeNames(): string[];
}
export declare class DataAzurermCdnFrontdoorSecretSecretCustomerCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCdnFrontdoorSecretSecretCustomerCertificateOutputReference;
}
export interface DataAzurermCdnFrontdoorSecretSecret {
}
export declare function dataAzurermCdnFrontdoorSecretSecretToTerraform(struct?: DataAzurermCdnFrontdoorSecretSecret): any;
export declare class DataAzurermCdnFrontdoorSecretSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCdnFrontdoorSecretSecret | undefined;
    set internalValue(value: DataAzurermCdnFrontdoorSecretSecret | undefined);
    private _customerCertificate;
    get customerCertificate(): DataAzurermCdnFrontdoorSecretSecretCustomerCertificateList;
}
export declare class DataAzurermCdnFrontdoorSecretSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCdnFrontdoorSecretSecretOutputReference;
}
export interface DataAzurermCdnFrontdoorSecretTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cdn_frontdoor_secret#read DataAzurermCdnFrontdoorSecret#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCdnFrontdoorSecretTimeoutsToTerraform(struct?: DataAzurermCdnFrontdoorSecretTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCdnFrontdoorSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermCdnFrontdoorSecretTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermCdnFrontdoorSecretTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cdn_frontdoor_secret azurerm_cdn_frontdoor_secret}
*/
export declare class DataAzurermCdnFrontdoorSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_secret";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cdn_frontdoor_secret azurerm_cdn_frontdoor_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCdnFrontdoorSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCdnFrontdoorSecretConfig);
    get cdnFrontdoorProfileId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _profileName?;
    get profileName(): string;
    set profileName(value: string);
    get profileNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _secret;
    get secret(): DataAzurermCdnFrontdoorSecretSecretList;
    private _timeouts;
    get timeouts(): DataAzurermCdnFrontdoorSecretTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCdnFrontdoorSecretTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermCdnFrontdoorSecretTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
