import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermClientConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/client_config#id DataAzurermClientConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/client_config#timeouts DataAzurermClientConfig#timeouts}
    */
    readonly timeouts?: DataAzurermClientConfigTimeouts;
}
export interface DataAzurermClientConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/client_config#read DataAzurermClientConfig#read}
    */
    readonly read?: string;
}
export declare function dataAzurermClientConfigTimeoutsToTerraform(struct?: DataAzurermClientConfigTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermClientConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermClientConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermClientConfigTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/client_config azurerm_client_config}
*/
export declare class DataAzurermClientConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_client_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/client_config azurerm_client_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermClientConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermClientConfigConfig);
    get clientId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get objectId(): string;
    get subscriptionId(): string;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzurermClientConfigTimeoutsOutputReference;
    putTimeouts(value: DataAzurermClientConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermClientConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
