import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCosmosdbSqlRoleDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cosmosdb_sql_role_definition#account_name DataAzurermCosmosdbSqlRoleDefinition#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cosmosdb_sql_role_definition#id DataAzurermCosmosdbSqlRoleDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cosmosdb_sql_role_definition#resource_group_name DataAzurermCosmosdbSqlRoleDefinition#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cosmosdb_sql_role_definition#role_definition_id DataAzurermCosmosdbSqlRoleDefinition#role_definition_id}
    */
    readonly roleDefinitionId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cosmosdb_sql_role_definition#timeouts DataAzurermCosmosdbSqlRoleDefinition#timeouts}
    */
    readonly timeouts?: DataAzurermCosmosdbSqlRoleDefinitionTimeouts;
}
export interface DataAzurermCosmosdbSqlRoleDefinitionPermissions {
}
export declare function dataAzurermCosmosdbSqlRoleDefinitionPermissionsToTerraform(struct?: DataAzurermCosmosdbSqlRoleDefinitionPermissions): any;
export declare class DataAzurermCosmosdbSqlRoleDefinitionPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCosmosdbSqlRoleDefinitionPermissions | undefined;
    set internalValue(value: DataAzurermCosmosdbSqlRoleDefinitionPermissions | undefined);
    get dataActions(): string[];
}
export declare class DataAzurermCosmosdbSqlRoleDefinitionPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCosmosdbSqlRoleDefinitionPermissionsOutputReference;
}
export interface DataAzurermCosmosdbSqlRoleDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cosmosdb_sql_role_definition#read DataAzurermCosmosdbSqlRoleDefinition#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbSqlRoleDefinitionTimeoutsToTerraform(struct?: DataAzurermCosmosdbSqlRoleDefinitionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCosmosdbSqlRoleDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermCosmosdbSqlRoleDefinitionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermCosmosdbSqlRoleDefinitionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cosmosdb_sql_role_definition azurerm_cosmosdb_sql_role_definition}
*/
export declare class DataAzurermCosmosdbSqlRoleDefinition extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_cosmosdb_sql_role_definition";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/cosmosdb_sql_role_definition azurerm_cosmosdb_sql_role_definition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCosmosdbSqlRoleDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbSqlRoleDefinitionConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    get assignableScopes(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _permissions;
    get permissions(): DataAzurermCosmosdbSqlRoleDefinitionPermissionsList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    get roleDefinitionIdInput(): string | undefined;
    get type(): string;
    private _timeouts;
    get timeouts(): DataAzurermCosmosdbSqlRoleDefinitionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCosmosdbSqlRoleDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermCosmosdbSqlRoleDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
