import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataboxEdgeDeviceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/databox_edge_device#id DataAzurermDataboxEdgeDevice#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/databox_edge_device#name DataAzurermDataboxEdgeDevice#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/databox_edge_device#resource_group_name DataAzurermDataboxEdgeDevice#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/databox_edge_device#timeouts DataAzurermDataboxEdgeDevice#timeouts}
    */
    readonly timeouts?: DataAzurermDataboxEdgeDeviceTimeouts;
}
export interface DataAzurermDataboxEdgeDeviceDeviceProperties {
}
export declare function dataAzurermDataboxEdgeDeviceDevicePropertiesToTerraform(struct?: DataAzurermDataboxEdgeDeviceDeviceProperties): any;
export declare class DataAzurermDataboxEdgeDeviceDevicePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataboxEdgeDeviceDeviceProperties | undefined;
    set internalValue(value: DataAzurermDataboxEdgeDeviceDeviceProperties | undefined);
    get capacity(): number;
    get configuredRoleTypes(): string[];
    get culture(): string;
    get hcsVersion(): string;
    get model(): string;
    get nodeCount(): number;
    get serialNumber(): string;
    get softwareVersion(): string;
    get status(): string;
    get timeZone(): string;
    get type(): string;
}
export declare class DataAzurermDataboxEdgeDeviceDevicePropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataboxEdgeDeviceDevicePropertiesOutputReference;
}
export interface DataAzurermDataboxEdgeDeviceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/databox_edge_device#read DataAzurermDataboxEdgeDevice#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataboxEdgeDeviceTimeoutsToTerraform(struct?: DataAzurermDataboxEdgeDeviceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataboxEdgeDeviceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDataboxEdgeDeviceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDataboxEdgeDeviceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/databox_edge_device azurerm_databox_edge_device}
*/
export declare class DataAzurermDataboxEdgeDevice extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_databox_edge_device";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/databox_edge_device azurerm_databox_edge_device} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataboxEdgeDeviceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataboxEdgeDeviceConfig);
    private _deviceProperties;
    get deviceProperties(): DataAzurermDataboxEdgeDeviceDevicePropertiesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermDataboxEdgeDeviceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataboxEdgeDeviceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDataboxEdgeDeviceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
