import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermManagementGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/management_group#display_name DataAzurermManagementGroup#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/management_group#id DataAzurermManagementGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/management_group#name DataAzurermManagementGroup#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/management_group#timeouts DataAzurermManagementGroup#timeouts}
    */
    readonly timeouts?: DataAzurermManagementGroupTimeouts;
}
export interface DataAzurermManagementGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/management_group#read DataAzurermManagementGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermManagementGroupTimeoutsToTerraform(struct?: DataAzurermManagementGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermManagementGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermManagementGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermManagementGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/management_group azurerm_management_group}
*/
export declare class DataAzurermManagementGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_management_group";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/management_group azurerm_management_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermManagementGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermManagementGroupConfig);
    get allManagementGroupIds(): string[];
    get allSubscriptionIds(): string[];
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get managementGroupIds(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get parentManagementGroupId(): string;
    get subscriptionIds(): string[];
    private _timeouts;
    get timeouts(): DataAzurermManagementGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermManagementGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermManagementGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
