import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorActionGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/monitor_action_group#id DataAzurermMonitorActionGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/monitor_action_group#name DataAzurermMonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/monitor_action_group#resource_group_name DataAzurermMonitorActionGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/monitor_action_group#timeouts DataAzurermMonitorActionGroup#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorActionGroupTimeouts;
}
export interface DataAzurermMonitorActionGroupArmRoleReceiver {
}
export declare function dataAzurermMonitorActionGroupArmRoleReceiverToTerraform(struct?: DataAzurermMonitorActionGroupArmRoleReceiver): any;
export declare class DataAzurermMonitorActionGroupArmRoleReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupArmRoleReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupArmRoleReceiver | undefined);
    get name(): string;
    get roleId(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupArmRoleReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupArmRoleReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupAutomationRunbookReceiver {
}
export declare function dataAzurermMonitorActionGroupAutomationRunbookReceiverToTerraform(struct?: DataAzurermMonitorActionGroupAutomationRunbookReceiver): any;
export declare class DataAzurermMonitorActionGroupAutomationRunbookReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupAutomationRunbookReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupAutomationRunbookReceiver | undefined);
    get automationAccountId(): string;
    get isGlobalRunbook(): cdktf.IResolvable;
    get name(): string;
    get runbookName(): string;
    get serviceUri(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
    get webhookResourceId(): string;
}
export declare class DataAzurermMonitorActionGroupAutomationRunbookReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupAutomationRunbookReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupAzureAppPushReceiver {
}
export declare function dataAzurermMonitorActionGroupAzureAppPushReceiverToTerraform(struct?: DataAzurermMonitorActionGroupAzureAppPushReceiver): any;
export declare class DataAzurermMonitorActionGroupAzureAppPushReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupAzureAppPushReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupAzureAppPushReceiver | undefined);
    get emailAddress(): string;
    get name(): string;
}
export declare class DataAzurermMonitorActionGroupAzureAppPushReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupAzureAppPushReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupAzureFunctionReceiver {
}
export declare function dataAzurermMonitorActionGroupAzureFunctionReceiverToTerraform(struct?: DataAzurermMonitorActionGroupAzureFunctionReceiver): any;
export declare class DataAzurermMonitorActionGroupAzureFunctionReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupAzureFunctionReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupAzureFunctionReceiver | undefined);
    get functionAppResourceId(): string;
    get functionName(): string;
    get httpTriggerUrl(): string;
    get name(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupAzureFunctionReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupAzureFunctionReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupEmailReceiver {
}
export declare function dataAzurermMonitorActionGroupEmailReceiverToTerraform(struct?: DataAzurermMonitorActionGroupEmailReceiver): any;
export declare class DataAzurermMonitorActionGroupEmailReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupEmailReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupEmailReceiver | undefined);
    get emailAddress(): string;
    get name(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupEmailReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupEmailReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupEventHubReceiver {
}
export declare function dataAzurermMonitorActionGroupEventHubReceiverToTerraform(struct?: DataAzurermMonitorActionGroupEventHubReceiver): any;
export declare class DataAzurermMonitorActionGroupEventHubReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupEventHubReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupEventHubReceiver | undefined);
    get eventHubId(): string;
    get eventHubName(): string;
    get eventHubNamespace(): string;
    get name(): string;
    get subscriptionId(): string;
    get tenantId(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupEventHubReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupEventHubReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupItsmReceiver {
}
export declare function dataAzurermMonitorActionGroupItsmReceiverToTerraform(struct?: DataAzurermMonitorActionGroupItsmReceiver): any;
export declare class DataAzurermMonitorActionGroupItsmReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupItsmReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupItsmReceiver | undefined);
    get connectionId(): string;
    get name(): string;
    get region(): string;
    get ticketConfiguration(): string;
    get workspaceId(): string;
}
export declare class DataAzurermMonitorActionGroupItsmReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupItsmReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupLogicAppReceiver {
}
export declare function dataAzurermMonitorActionGroupLogicAppReceiverToTerraform(struct?: DataAzurermMonitorActionGroupLogicAppReceiver): any;
export declare class DataAzurermMonitorActionGroupLogicAppReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupLogicAppReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupLogicAppReceiver | undefined);
    get callbackUrl(): string;
    get name(): string;
    get resourceId(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupLogicAppReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupLogicAppReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupSmsReceiver {
}
export declare function dataAzurermMonitorActionGroupSmsReceiverToTerraform(struct?: DataAzurermMonitorActionGroupSmsReceiver): any;
export declare class DataAzurermMonitorActionGroupSmsReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupSmsReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupSmsReceiver | undefined);
    get countryCode(): string;
    get name(): string;
    get phoneNumber(): string;
}
export declare class DataAzurermMonitorActionGroupSmsReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupSmsReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupVoiceReceiver {
}
export declare function dataAzurermMonitorActionGroupVoiceReceiverToTerraform(struct?: DataAzurermMonitorActionGroupVoiceReceiver): any;
export declare class DataAzurermMonitorActionGroupVoiceReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupVoiceReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupVoiceReceiver | undefined);
    get countryCode(): string;
    get name(): string;
    get phoneNumber(): string;
}
export declare class DataAzurermMonitorActionGroupVoiceReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupVoiceReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupWebhookReceiverAadAuth {
}
export declare function dataAzurermMonitorActionGroupWebhookReceiverAadAuthToTerraform(struct?: DataAzurermMonitorActionGroupWebhookReceiverAadAuth): any;
export declare class DataAzurermMonitorActionGroupWebhookReceiverAadAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupWebhookReceiverAadAuth | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupWebhookReceiverAadAuth | undefined);
    get identifierUri(): string;
    get objectId(): string;
    get tenantId(): string;
}
export declare class DataAzurermMonitorActionGroupWebhookReceiverAadAuthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupWebhookReceiverAadAuthOutputReference;
}
export interface DataAzurermMonitorActionGroupWebhookReceiver {
}
export declare function dataAzurermMonitorActionGroupWebhookReceiverToTerraform(struct?: DataAzurermMonitorActionGroupWebhookReceiver): any;
export declare class DataAzurermMonitorActionGroupWebhookReceiverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorActionGroupWebhookReceiver | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupWebhookReceiver | undefined);
    private _aadAuth;
    get aadAuth(): DataAzurermMonitorActionGroupWebhookReceiverAadAuthList;
    get name(): string;
    get serviceUri(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupWebhookReceiverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorActionGroupWebhookReceiverOutputReference;
}
export interface DataAzurermMonitorActionGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/monitor_action_group#read DataAzurermMonitorActionGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorActionGroupTimeoutsToTerraform(struct?: DataAzurermMonitorActionGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorActionGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMonitorActionGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/monitor_action_group azurerm_monitor_action_group}
*/
export declare class DataAzurermMonitorActionGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_monitor_action_group";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/monitor_action_group azurerm_monitor_action_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorActionGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorActionGroupConfig);
    private _armRoleReceiver;
    get armRoleReceiver(): DataAzurermMonitorActionGroupArmRoleReceiverList;
    private _automationRunbookReceiver;
    get automationRunbookReceiver(): DataAzurermMonitorActionGroupAutomationRunbookReceiverList;
    private _azureAppPushReceiver;
    get azureAppPushReceiver(): DataAzurermMonitorActionGroupAzureAppPushReceiverList;
    private _azureFunctionReceiver;
    get azureFunctionReceiver(): DataAzurermMonitorActionGroupAzureFunctionReceiverList;
    private _emailReceiver;
    get emailReceiver(): DataAzurermMonitorActionGroupEmailReceiverList;
    get enabled(): cdktf.IResolvable;
    private _eventHubReceiver;
    get eventHubReceiver(): DataAzurermMonitorActionGroupEventHubReceiverList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itsmReceiver;
    get itsmReceiver(): DataAzurermMonitorActionGroupItsmReceiverList;
    private _logicAppReceiver;
    get logicAppReceiver(): DataAzurermMonitorActionGroupLogicAppReceiverList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get shortName(): string;
    private _smsReceiver;
    get smsReceiver(): DataAzurermMonitorActionGroupSmsReceiverList;
    private _voiceReceiver;
    get voiceReceiver(): DataAzurermMonitorActionGroupVoiceReceiverList;
    private _webhookReceiver;
    get webhookReceiver(): DataAzurermMonitorActionGroupWebhookReceiverList;
    private _timeouts;
    get timeouts(): DataAzurermMonitorActionGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorActionGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMonitorActionGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
