import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMysqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/mysql_flexible_server#id DataAzurermMysqlFlexibleServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/mysql_flexible_server#name DataAzurermMysqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/mysql_flexible_server#resource_group_name DataAzurermMysqlFlexibleServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/mysql_flexible_server#timeouts DataAzurermMysqlFlexibleServer#timeouts}
    */
    readonly timeouts?: DataAzurermMysqlFlexibleServerTimeouts;
}
export interface DataAzurermMysqlFlexibleServerHighAvailability {
}
export declare function dataAzurermMysqlFlexibleServerHighAvailabilityToTerraform(struct?: DataAzurermMysqlFlexibleServerHighAvailability): any;
export declare class DataAzurermMysqlFlexibleServerHighAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMysqlFlexibleServerHighAvailability | undefined;
    set internalValue(value: DataAzurermMysqlFlexibleServerHighAvailability | undefined);
    get mode(): string;
    get standbyAvailabilityZone(): string;
}
export declare class DataAzurermMysqlFlexibleServerHighAvailabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMysqlFlexibleServerHighAvailabilityOutputReference;
}
export interface DataAzurermMysqlFlexibleServerMaintenanceWindow {
}
export declare function dataAzurermMysqlFlexibleServerMaintenanceWindowToTerraform(struct?: DataAzurermMysqlFlexibleServerMaintenanceWindow): any;
export declare class DataAzurermMysqlFlexibleServerMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMysqlFlexibleServerMaintenanceWindow | undefined;
    set internalValue(value: DataAzurermMysqlFlexibleServerMaintenanceWindow | undefined);
    get dayOfWeek(): number;
    get startHour(): number;
    get startMinute(): number;
}
export declare class DataAzurermMysqlFlexibleServerMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMysqlFlexibleServerMaintenanceWindowOutputReference;
}
export interface DataAzurermMysqlFlexibleServerStorage {
}
export declare function dataAzurermMysqlFlexibleServerStorageToTerraform(struct?: DataAzurermMysqlFlexibleServerStorage): any;
export declare class DataAzurermMysqlFlexibleServerStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMysqlFlexibleServerStorage | undefined;
    set internalValue(value: DataAzurermMysqlFlexibleServerStorage | undefined);
    get autoGrowEnabled(): cdktf.IResolvable;
    get iops(): number;
    get sizeGb(): number;
}
export declare class DataAzurermMysqlFlexibleServerStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMysqlFlexibleServerStorageOutputReference;
}
export interface DataAzurermMysqlFlexibleServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/mysql_flexible_server#read DataAzurermMysqlFlexibleServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMysqlFlexibleServerTimeoutsToTerraform(struct?: DataAzurermMysqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMysqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMysqlFlexibleServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMysqlFlexibleServerTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/mysql_flexible_server azurerm_mysql_flexible_server}
*/
export declare class DataAzurermMysqlFlexibleServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mysql_flexible_server";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/mysql_flexible_server azurerm_mysql_flexible_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMysqlFlexibleServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMysqlFlexibleServerConfig);
    get administratorLogin(): string;
    get backupRetentionDays(): number;
    get delegatedSubnetId(): string;
    get fqdn(): string;
    get geoRedundantBackupEnabled(): cdktf.IResolvable;
    private _highAvailability;
    get highAvailability(): DataAzurermMysqlFlexibleServerHighAvailabilityList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _maintenanceWindow;
    get maintenanceWindow(): DataAzurermMysqlFlexibleServerMaintenanceWindowList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateDnsZoneId(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    get replicaCapacity(): number;
    get replicationRole(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get restorePointInTime(): string;
    get skuName(): string;
    private _storage;
    get storage(): DataAzurermMysqlFlexibleServerStorageList;
    private _tags;
    get tags(): cdktf.StringMap;
    get version(): string;
    get zone(): string;
    private _timeouts;
    get timeouts(): DataAzurermMysqlFlexibleServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMysqlFlexibleServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMysqlFlexibleServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
