import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNatGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/nat_gateway#id DataAzurermNatGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/nat_gateway#name DataAzurermNatGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/nat_gateway#public_ip_address_ids DataAzurermNatGateway#public_ip_address_ids}
    */
    readonly publicIpAddressIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/nat_gateway#public_ip_prefix_ids DataAzurermNatGateway#public_ip_prefix_ids}
    */
    readonly publicIpPrefixIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/nat_gateway#resource_group_name DataAzurermNatGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/nat_gateway#timeouts DataAzurermNatGateway#timeouts}
    */
    readonly timeouts?: DataAzurermNatGatewayTimeouts;
}
export interface DataAzurermNatGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/nat_gateway#read DataAzurermNatGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNatGatewayTimeoutsToTerraform(struct?: DataAzurermNatGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNatGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNatGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNatGatewayTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/nat_gateway azurerm_nat_gateway}
*/
export declare class DataAzurermNatGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_nat_gateway";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/nat_gateway azurerm_nat_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNatGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNatGatewayConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idleTimeoutInMinutes(): number;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicIpAddressIds?;
    get publicIpAddressIds(): string[];
    set publicIpAddressIds(value: string[]);
    resetPublicIpAddressIds(): void;
    get publicIpAddressIdsInput(): string[] | undefined;
    private _publicIpPrefixIds?;
    get publicIpPrefixIds(): string[];
    set publicIpPrefixIds(value: string[]);
    resetPublicIpPrefixIds(): void;
    get publicIpPrefixIdsInput(): string[] | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get resourceGuid(): string;
    get skuName(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermNatGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNatGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNatGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
