import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkWatcherConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/network_watcher#id DataAzurermNetworkWatcher#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/network_watcher#name DataAzurermNetworkWatcher#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/network_watcher#resource_group_name DataAzurermNetworkWatcher#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/network_watcher#timeouts DataAzurermNetworkWatcher#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkWatcherTimeouts;
}
export interface DataAzurermNetworkWatcherTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/network_watcher#read DataAzurermNetworkWatcher#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkWatcherTimeoutsToTerraform(struct?: DataAzurermNetworkWatcherTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkWatcherTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetworkWatcherTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetworkWatcherTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/network_watcher azurerm_network_watcher}
*/
export declare class DataAzurermNetworkWatcher extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_network_watcher";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/network_watcher azurerm_network_watcher} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkWatcherConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkWatcherConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermNetworkWatcherTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkWatcherTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetworkWatcherTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
