import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateLinkServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/private_link_service#id DataAzurermPrivateLinkService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/private_link_service#name DataAzurermPrivateLinkService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/private_link_service#resource_group_name DataAzurermPrivateLinkService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/private_link_service#timeouts DataAzurermPrivateLinkService#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateLinkServiceTimeouts;
}
export interface DataAzurermPrivateLinkServiceNatIpConfiguration {
}
export declare function dataAzurermPrivateLinkServiceNatIpConfigurationToTerraform(struct?: DataAzurermPrivateLinkServiceNatIpConfiguration): any;
export declare class DataAzurermPrivateLinkServiceNatIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPrivateLinkServiceNatIpConfiguration | undefined;
    set internalValue(value: DataAzurermPrivateLinkServiceNatIpConfiguration | undefined);
    get name(): string;
    get primary(): cdktf.IResolvable;
    get privateIpAddress(): string;
    get privateIpAddressVersion(): string;
    get subnetId(): string;
}
export declare class DataAzurermPrivateLinkServiceNatIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPrivateLinkServiceNatIpConfigurationOutputReference;
}
export interface DataAzurermPrivateLinkServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/private_link_service#read DataAzurermPrivateLinkService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateLinkServiceTimeoutsToTerraform(struct?: DataAzurermPrivateLinkServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateLinkServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPrivateLinkServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPrivateLinkServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/private_link_service azurerm_private_link_service}
*/
export declare class DataAzurermPrivateLinkService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_private_link_service";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/private_link_service azurerm_private_link_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateLinkServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateLinkServiceConfig);
    get alias(): string;
    get autoApprovalSubscriptionIds(): string[];
    get enableProxyProtocol(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get loadBalancerFrontendIpConfigurationIds(): string[];
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _natIpConfiguration;
    get natIpConfiguration(): DataAzurermPrivateLinkServiceNatIpConfigurationList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get visibilitySubscriptionIds(): string[];
    private _timeouts;
    get timeouts(): DataAzurermPrivateLinkServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateLinkServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPrivateLinkServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
