import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermUserAssignedIdentityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/user_assigned_identity#id DataAzurermUserAssignedIdentity#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/user_assigned_identity#name DataAzurermUserAssignedIdentity#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/user_assigned_identity#resource_group_name DataAzurermUserAssignedIdentity#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/user_assigned_identity#timeouts DataAzurermUserAssignedIdentity#timeouts}
    */
    readonly timeouts?: DataAzurermUserAssignedIdentityTimeouts;
}
export interface DataAzurermUserAssignedIdentityTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/user_assigned_identity#read DataAzurermUserAssignedIdentity#read}
    */
    readonly read?: string;
}
export declare function dataAzurermUserAssignedIdentityTimeoutsToTerraform(struct?: DataAzurermUserAssignedIdentityTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermUserAssignedIdentityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermUserAssignedIdentityTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermUserAssignedIdentityTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/user_assigned_identity azurerm_user_assigned_identity}
*/
export declare class DataAzurermUserAssignedIdentity extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_user_assigned_identity";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/user_assigned_identity azurerm_user_assigned_identity} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermUserAssignedIdentityConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermUserAssignedIdentityConfig);
    get clientId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get principalId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzurermUserAssignedIdentityTimeoutsOutputReference;
    putTimeouts(value: DataAzurermUserAssignedIdentityTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermUserAssignedIdentityTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
