import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_hub#id DataAzurermVirtualHub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_hub#name DataAzurermVirtualHub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_hub#resource_group_name DataAzurermVirtualHub#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_hub#timeouts DataAzurermVirtualHub#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualHubTimeouts;
}
export interface DataAzurermVirtualHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_hub#read DataAzurermVirtualHub#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualHubTimeoutsToTerraform(struct?: DataAzurermVirtualHubTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualHubTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualHubTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_hub azurerm_virtual_hub}
*/
export declare class DataAzurermVirtualHub extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_hub";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_hub azurerm_virtual_hub} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualHubConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualHubConfig);
    get addressPrefix(): string;
    get defaultRouteTableId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get virtualRouterAsn(): number;
    get virtualRouterIps(): string[];
    get virtualWanId(): string;
    private _timeouts;
    get timeouts(): DataAzurermVirtualHubTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
