import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualNetworkGatewayConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_network_gateway_connection#id DataAzurermVirtualNetworkGatewayConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_network_gateway_connection#name DataAzurermVirtualNetworkGatewayConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_network_gateway_connection#resource_group_name DataAzurermVirtualNetworkGatewayConnection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_network_gateway_connection#timeouts DataAzurermVirtualNetworkGatewayConnection#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualNetworkGatewayConnectionTimeouts;
}
export interface DataAzurermVirtualNetworkGatewayConnectionIpsecPolicy {
}
export declare function dataAzurermVirtualNetworkGatewayConnectionIpsecPolicyToTerraform(struct?: DataAzurermVirtualNetworkGatewayConnectionIpsecPolicy): any;
export declare class DataAzurermVirtualNetworkGatewayConnectionIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayConnectionIpsecPolicy | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayConnectionIpsecPolicy | undefined);
    get dhGroup(): string;
    get ikeEncryption(): string;
    get ikeIntegrity(): string;
    get ipsecEncryption(): string;
    get ipsecIntegrity(): string;
    get pfsGroup(): string;
    get saDatasize(): number;
    get saLifetime(): number;
}
export declare class DataAzurermVirtualNetworkGatewayConnectionIpsecPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualNetworkGatewayConnectionIpsecPolicyOutputReference;
}
export interface DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicy {
}
export declare function dataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicyToTerraform(struct?: DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicy): any;
export declare class DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicy | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicy | undefined);
    get localAddressCidrs(): string[];
    get remoteAddressCidrs(): string[];
}
export declare class DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference;
}
export interface DataAzurermVirtualNetworkGatewayConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_network_gateway_connection#read DataAzurermVirtualNetworkGatewayConnection#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualNetworkGatewayConnectionTimeoutsToTerraform(struct?: DataAzurermVirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualNetworkGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualNetworkGatewayConnectionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_network_gateway_connection azurerm_virtual_network_gateway_connection}
*/
export declare class DataAzurermVirtualNetworkGatewayConnection extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_network_gateway_connection";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/data-sources/virtual_network_gateway_connection azurerm_virtual_network_gateway_connection} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualNetworkGatewayConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualNetworkGatewayConnectionConfig);
    get authorizationKey(): string;
    get connectionProtocol(): string;
    get dpdTimeoutSeconds(): number;
    get egressBytesTransferred(): number;
    get enableBgp(): cdktf.IResolvable;
    get expressRouteCircuitId(): string;
    get expressRouteGatewayBypass(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ingressBytesTransferred(): number;
    private _ipsecPolicy;
    get ipsecPolicy(): DataAzurermVirtualNetworkGatewayConnectionIpsecPolicyList;
    get localAzureIpAddressEnabled(): cdktf.IResolvable;
    get localNetworkGatewayId(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get peerVirtualNetworkGatewayId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get resourceGuid(): string;
    get routingWeight(): number;
    get sharedKey(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _trafficSelectorPolicy;
    get trafficSelectorPolicy(): DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicyList;
    get type(): string;
    get usePolicyBasedTrafficSelectors(): cdktf.IResolvable;
    get virtualNetworkGatewayId(): string;
    private _timeouts;
    get timeouts(): DataAzurermVirtualNetworkGatewayConnectionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualNetworkGatewayConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualNetworkGatewayConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
