import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataboxEdgeDeviceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#id DataboxEdgeDevice#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#location DataboxEdgeDevice#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#name DataboxEdgeDevice#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#resource_group_name DataboxEdgeDevice#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#sku_name DataboxEdgeDevice#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#tags DataboxEdgeDevice#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#timeouts DataboxEdgeDevice#timeouts}
    */
    readonly timeouts?: DataboxEdgeDeviceTimeouts;
}
export interface DataboxEdgeDeviceDeviceProperties {
}
export declare function databoxEdgeDeviceDevicePropertiesToTerraform(struct?: DataboxEdgeDeviceDeviceProperties): any;
export declare class DataboxEdgeDeviceDevicePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataboxEdgeDeviceDeviceProperties | undefined;
    set internalValue(value: DataboxEdgeDeviceDeviceProperties | undefined);
    get capacity(): number;
    get configuredRoleTypes(): string[];
    get culture(): string;
    get hcsVersion(): string;
    get model(): string;
    get nodeCount(): number;
    get serialNumber(): string;
    get softwareVersion(): string;
    get status(): string;
    get timeZone(): string;
    get type(): string;
}
export declare class DataboxEdgeDeviceDevicePropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataboxEdgeDeviceDevicePropertiesOutputReference;
}
export interface DataboxEdgeDeviceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#create DataboxEdgeDevice#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#delete DataboxEdgeDevice#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#read DataboxEdgeDevice#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device#update DataboxEdgeDevice#update}
    */
    readonly update?: string;
}
export declare function databoxEdgeDeviceTimeoutsToTerraform(struct?: DataboxEdgeDeviceTimeouts | cdktf.IResolvable): any;
export declare class DataboxEdgeDeviceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataboxEdgeDeviceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataboxEdgeDeviceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device azurerm_databox_edge_device}
*/
export declare class DataboxEdgeDevice extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_databox_edge_device";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/databox_edge_device azurerm_databox_edge_device} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataboxEdgeDeviceConfig
    */
    constructor(scope: Construct, id: string, config: DataboxEdgeDeviceConfig);
    private _deviceProperties;
    get deviceProperties(): DataboxEdgeDeviceDevicePropertiesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataboxEdgeDeviceTimeoutsOutputReference;
    putTimeouts(value: DataboxEdgeDeviceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataboxEdgeDeviceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
