import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FrontdoorRulesEngineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#enabled FrontdoorRulesEngine#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#frontdoor_name FrontdoorRulesEngine#frontdoor_name}
    */
    readonly frontdoorName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#id FrontdoorRulesEngine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#name FrontdoorRulesEngine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#resource_group_name FrontdoorRulesEngine#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#rule FrontdoorRulesEngine#rule}
    */
    readonly rule?: FrontdoorRulesEngineRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#timeouts FrontdoorRulesEngine#timeouts}
    */
    readonly timeouts?: FrontdoorRulesEngineTimeouts;
}
export interface FrontdoorRulesEngineRuleActionRequestHeader {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#header_action_type FrontdoorRulesEngine#header_action_type}
    */
    readonly headerActionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#header_name FrontdoorRulesEngine#header_name}
    */
    readonly headerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#value FrontdoorRulesEngine#value}
    */
    readonly value?: string;
}
export declare function frontdoorRulesEngineRuleActionRequestHeaderToTerraform(struct?: FrontdoorRulesEngineRuleActionRequestHeader | cdktf.IResolvable): any;
export declare class FrontdoorRulesEngineRuleActionRequestHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorRulesEngineRuleActionRequestHeader | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorRulesEngineRuleActionRequestHeader | cdktf.IResolvable | undefined);
    private _headerActionType?;
    get headerActionType(): string;
    set headerActionType(value: string);
    resetHeaderActionType(): void;
    get headerActionTypeInput(): string | undefined;
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class FrontdoorRulesEngineRuleActionRequestHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorRulesEngineRuleActionRequestHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorRulesEngineRuleActionRequestHeaderOutputReference;
}
export interface FrontdoorRulesEngineRuleActionResponseHeader {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#header_action_type FrontdoorRulesEngine#header_action_type}
    */
    readonly headerActionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#header_name FrontdoorRulesEngine#header_name}
    */
    readonly headerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#value FrontdoorRulesEngine#value}
    */
    readonly value?: string;
}
export declare function frontdoorRulesEngineRuleActionResponseHeaderToTerraform(struct?: FrontdoorRulesEngineRuleActionResponseHeader | cdktf.IResolvable): any;
export declare class FrontdoorRulesEngineRuleActionResponseHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorRulesEngineRuleActionResponseHeader | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorRulesEngineRuleActionResponseHeader | cdktf.IResolvable | undefined);
    private _headerActionType?;
    get headerActionType(): string;
    set headerActionType(value: string);
    resetHeaderActionType(): void;
    get headerActionTypeInput(): string | undefined;
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class FrontdoorRulesEngineRuleActionResponseHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorRulesEngineRuleActionResponseHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorRulesEngineRuleActionResponseHeaderOutputReference;
}
export interface FrontdoorRulesEngineRuleAction {
    /**
    * request_header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#request_header FrontdoorRulesEngine#request_header}
    */
    readonly requestHeader?: FrontdoorRulesEngineRuleActionRequestHeader[] | cdktf.IResolvable;
    /**
    * response_header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#response_header FrontdoorRulesEngine#response_header}
    */
    readonly responseHeader?: FrontdoorRulesEngineRuleActionResponseHeader[] | cdktf.IResolvable;
}
export declare function frontdoorRulesEngineRuleActionToTerraform(struct?: FrontdoorRulesEngineRuleActionOutputReference | FrontdoorRulesEngineRuleAction): any;
export declare class FrontdoorRulesEngineRuleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorRulesEngineRuleAction | undefined;
    set internalValue(value: FrontdoorRulesEngineRuleAction | undefined);
    private _requestHeader;
    get requestHeader(): FrontdoorRulesEngineRuleActionRequestHeaderList;
    putRequestHeader(value: FrontdoorRulesEngineRuleActionRequestHeader[] | cdktf.IResolvable): void;
    resetRequestHeader(): void;
    get requestHeaderInput(): cdktf.IResolvable | FrontdoorRulesEngineRuleActionRequestHeader[] | undefined;
    private _responseHeader;
    get responseHeader(): FrontdoorRulesEngineRuleActionResponseHeaderList;
    putResponseHeader(value: FrontdoorRulesEngineRuleActionResponseHeader[] | cdktf.IResolvable): void;
    resetResponseHeader(): void;
    get responseHeaderInput(): cdktf.IResolvable | FrontdoorRulesEngineRuleActionResponseHeader[] | undefined;
}
export interface FrontdoorRulesEngineRuleMatchCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#negate_condition FrontdoorRulesEngine#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#operator FrontdoorRulesEngine#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#selector FrontdoorRulesEngine#selector}
    */
    readonly selector?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#transform FrontdoorRulesEngine#transform}
    */
    readonly transform?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#value FrontdoorRulesEngine#value}
    */
    readonly value?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#variable FrontdoorRulesEngine#variable}
    */
    readonly variable?: string;
}
export declare function frontdoorRulesEngineRuleMatchConditionToTerraform(struct?: FrontdoorRulesEngineRuleMatchCondition | cdktf.IResolvable): any;
export declare class FrontdoorRulesEngineRuleMatchConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorRulesEngineRuleMatchCondition | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorRulesEngineRuleMatchCondition | cdktf.IResolvable | undefined);
    private _negateCondition?;
    get negateCondition(): boolean | cdktf.IResolvable;
    set negateCondition(value: boolean | cdktf.IResolvable);
    resetNegateCondition(): void;
    get negateConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    resetSelector(): void;
    get selectorInput(): string | undefined;
    private _transform?;
    get transform(): string[];
    set transform(value: string[]);
    resetTransform(): void;
    get transformInput(): string[] | undefined;
    private _value?;
    get value(): string[];
    set value(value: string[]);
    resetValue(): void;
    get valueInput(): string[] | undefined;
    private _variable?;
    get variable(): string;
    set variable(value: string);
    resetVariable(): void;
    get variableInput(): string | undefined;
}
export declare class FrontdoorRulesEngineRuleMatchConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorRulesEngineRuleMatchCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorRulesEngineRuleMatchConditionOutputReference;
}
export interface FrontdoorRulesEngineRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#name FrontdoorRulesEngine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#priority FrontdoorRulesEngine#priority}
    */
    readonly priority: number;
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#action FrontdoorRulesEngine#action}
    */
    readonly action?: FrontdoorRulesEngineRuleAction;
    /**
    * match_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#match_condition FrontdoorRulesEngine#match_condition}
    */
    readonly matchCondition?: FrontdoorRulesEngineRuleMatchCondition[] | cdktf.IResolvable;
}
export declare function frontdoorRulesEngineRuleToTerraform(struct?: FrontdoorRulesEngineRule | cdktf.IResolvable): any;
export declare class FrontdoorRulesEngineRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorRulesEngineRule | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorRulesEngineRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _action;
    get action(): FrontdoorRulesEngineRuleActionOutputReference;
    putAction(value: FrontdoorRulesEngineRuleAction): void;
    resetAction(): void;
    get actionInput(): FrontdoorRulesEngineRuleAction | undefined;
    private _matchCondition;
    get matchCondition(): FrontdoorRulesEngineRuleMatchConditionList;
    putMatchCondition(value: FrontdoorRulesEngineRuleMatchCondition[] | cdktf.IResolvable): void;
    resetMatchCondition(): void;
    get matchConditionInput(): cdktf.IResolvable | FrontdoorRulesEngineRuleMatchCondition[] | undefined;
}
export declare class FrontdoorRulesEngineRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorRulesEngineRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorRulesEngineRuleOutputReference;
}
export interface FrontdoorRulesEngineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#create FrontdoorRulesEngine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#delete FrontdoorRulesEngine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#read FrontdoorRulesEngine#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine#update FrontdoorRulesEngine#update}
    */
    readonly update?: string;
}
export declare function frontdoorRulesEngineTimeoutsToTerraform(struct?: FrontdoorRulesEngineTimeouts | cdktf.IResolvable): any;
export declare class FrontdoorRulesEngineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorRulesEngineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorRulesEngineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine azurerm_frontdoor_rules_engine}
*/
export declare class FrontdoorRulesEngine extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_frontdoor_rules_engine";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/frontdoor_rules_engine azurerm_frontdoor_rules_engine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FrontdoorRulesEngineConfig
    */
    constructor(scope: Construct, id: string, config: FrontdoorRulesEngineConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frontdoorName?;
    get frontdoorName(): string;
    set frontdoorName(value: string);
    get frontdoorNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rule;
    get rule(): FrontdoorRulesEngineRuleList;
    putRule(value: FrontdoorRulesEngineRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | FrontdoorRulesEngineRule[] | undefined;
    private _timeouts;
    get timeouts(): FrontdoorRulesEngineTimeoutsOutputReference;
    putTimeouts(value: FrontdoorRulesEngineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FrontdoorRulesEngineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
