import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyVaultKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#curve KeyVaultKey#curve}
    */
    readonly curve?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#expiration_date KeyVaultKey#expiration_date}
    */
    readonly expirationDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#id KeyVaultKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#key_opts KeyVaultKey#key_opts}
    */
    readonly keyOpts: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#key_size KeyVaultKey#key_size}
    */
    readonly keySize?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#key_type KeyVaultKey#key_type}
    */
    readonly keyType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#key_vault_id KeyVaultKey#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#name KeyVaultKey#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#not_before_date KeyVaultKey#not_before_date}
    */
    readonly notBeforeDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#tags KeyVaultKey#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * rotation_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#rotation_policy KeyVaultKey#rotation_policy}
    */
    readonly rotationPolicy?: KeyVaultKeyRotationPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#timeouts KeyVaultKey#timeouts}
    */
    readonly timeouts?: KeyVaultKeyTimeouts;
}
export interface KeyVaultKeyRotationPolicyAutomatic {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#time_after_creation KeyVaultKey#time_after_creation}
    */
    readonly timeAfterCreation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#time_before_expiry KeyVaultKey#time_before_expiry}
    */
    readonly timeBeforeExpiry?: string;
}
export declare function keyVaultKeyRotationPolicyAutomaticToTerraform(struct?: KeyVaultKeyRotationPolicyAutomaticOutputReference | KeyVaultKeyRotationPolicyAutomatic): any;
export declare class KeyVaultKeyRotationPolicyAutomaticOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultKeyRotationPolicyAutomatic | undefined;
    set internalValue(value: KeyVaultKeyRotationPolicyAutomatic | undefined);
    private _timeAfterCreation?;
    get timeAfterCreation(): string;
    set timeAfterCreation(value: string);
    resetTimeAfterCreation(): void;
    get timeAfterCreationInput(): string | undefined;
    private _timeBeforeExpiry?;
    get timeBeforeExpiry(): string;
    set timeBeforeExpiry(value: string);
    resetTimeBeforeExpiry(): void;
    get timeBeforeExpiryInput(): string | undefined;
}
export interface KeyVaultKeyRotationPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#expire_after KeyVaultKey#expire_after}
    */
    readonly expireAfter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#notify_before_expiry KeyVaultKey#notify_before_expiry}
    */
    readonly notifyBeforeExpiry?: string;
    /**
    * automatic block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#automatic KeyVaultKey#automatic}
    */
    readonly automatic?: KeyVaultKeyRotationPolicyAutomatic;
}
export declare function keyVaultKeyRotationPolicyToTerraform(struct?: KeyVaultKeyRotationPolicyOutputReference | KeyVaultKeyRotationPolicy): any;
export declare class KeyVaultKeyRotationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultKeyRotationPolicy | undefined;
    set internalValue(value: KeyVaultKeyRotationPolicy | undefined);
    private _expireAfter?;
    get expireAfter(): string;
    set expireAfter(value: string);
    resetExpireAfter(): void;
    get expireAfterInput(): string | undefined;
    private _notifyBeforeExpiry?;
    get notifyBeforeExpiry(): string;
    set notifyBeforeExpiry(value: string);
    resetNotifyBeforeExpiry(): void;
    get notifyBeforeExpiryInput(): string | undefined;
    private _automatic;
    get automatic(): KeyVaultKeyRotationPolicyAutomaticOutputReference;
    putAutomatic(value: KeyVaultKeyRotationPolicyAutomatic): void;
    resetAutomatic(): void;
    get automaticInput(): KeyVaultKeyRotationPolicyAutomatic | undefined;
}
export interface KeyVaultKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#create KeyVaultKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#delete KeyVaultKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#read KeyVaultKey#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key#update KeyVaultKey#update}
    */
    readonly update?: string;
}
export declare function keyVaultKeyTimeoutsToTerraform(struct?: KeyVaultKeyTimeouts | cdktf.IResolvable): any;
export declare class KeyVaultKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key azurerm_key_vault_key}
*/
export declare class KeyVaultKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_key_vault_key";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/key_vault_key azurerm_key_vault_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyVaultKeyConfig
    */
    constructor(scope: Construct, id: string, config: KeyVaultKeyConfig);
    private _curve?;
    get curve(): string;
    set curve(value: string);
    resetCurve(): void;
    get curveInput(): string | undefined;
    get e(): string;
    private _expirationDate?;
    get expirationDate(): string;
    set expirationDate(value: string);
    resetExpirationDate(): void;
    get expirationDateInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyOpts?;
    get keyOpts(): string[];
    set keyOpts(value: string[]);
    get keyOptsInput(): string[] | undefined;
    private _keySize?;
    get keySize(): number;
    set keySize(value: number);
    resetKeySize(): void;
    get keySizeInput(): number | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    get keyTypeInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    get n(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notBeforeDate?;
    get notBeforeDate(): string;
    set notBeforeDate(value: string);
    resetNotBeforeDate(): void;
    get notBeforeDateInput(): string | undefined;
    get publicKeyOpenssh(): string;
    get publicKeyPem(): string;
    get resourceId(): string;
    get resourceVersionlessId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get version(): string;
    get versionlessId(): string;
    get x(): string;
    get y(): string;
    private _rotationPolicy;
    get rotationPolicy(): KeyVaultKeyRotationPolicyOutputReference;
    putRotationPolicy(value: KeyVaultKeyRotationPolicy): void;
    resetRotationPolicy(): void;
    get rotationPolicyInput(): KeyVaultKeyRotationPolicy | undefined;
    private _timeouts;
    get timeouts(): KeyVaultKeyTimeoutsOutputReference;
    putTimeouts(value: KeyVaultKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KeyVaultKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
