import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppWorkflowConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#enabled LogicAppWorkflow#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#id LogicAppWorkflow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#integration_service_environment_id LogicAppWorkflow#integration_service_environment_id}
    */
    readonly integrationServiceEnvironmentId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#location LogicAppWorkflow#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#logic_app_integration_account_id LogicAppWorkflow#logic_app_integration_account_id}
    */
    readonly logicAppIntegrationAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#name LogicAppWorkflow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#parameters LogicAppWorkflow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#resource_group_name LogicAppWorkflow#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#tags LogicAppWorkflow#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#workflow_parameters LogicAppWorkflow#workflow_parameters}
    */
    readonly workflowParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#workflow_schema LogicAppWorkflow#workflow_schema}
    */
    readonly workflowSchema?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#workflow_version LogicAppWorkflow#workflow_version}
    */
    readonly workflowVersion?: string;
    /**
    * access_control block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#access_control LogicAppWorkflow#access_control}
    */
    readonly accessControl?: LogicAppWorkflowAccessControl;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#identity LogicAppWorkflow#identity}
    */
    readonly identity?: LogicAppWorkflowIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#timeouts LogicAppWorkflow#timeouts}
    */
    readonly timeouts?: LogicAppWorkflowTimeouts;
}
export interface LogicAppWorkflowAccessControlAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#allowed_caller_ip_address_range LogicAppWorkflow#allowed_caller_ip_address_range}
    */
    readonly allowedCallerIpAddressRange: string[];
}
export declare function logicAppWorkflowAccessControlActionToTerraform(struct?: LogicAppWorkflowAccessControlActionOutputReference | LogicAppWorkflowAccessControlAction): any;
export declare class LogicAppWorkflowAccessControlActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppWorkflowAccessControlAction | undefined;
    set internalValue(value: LogicAppWorkflowAccessControlAction | undefined);
    private _allowedCallerIpAddressRange?;
    get allowedCallerIpAddressRange(): string[];
    set allowedCallerIpAddressRange(value: string[]);
    get allowedCallerIpAddressRangeInput(): string[] | undefined;
}
export interface LogicAppWorkflowAccessControlContent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#allowed_caller_ip_address_range LogicAppWorkflow#allowed_caller_ip_address_range}
    */
    readonly allowedCallerIpAddressRange: string[];
}
export declare function logicAppWorkflowAccessControlContentToTerraform(struct?: LogicAppWorkflowAccessControlContentOutputReference | LogicAppWorkflowAccessControlContent): any;
export declare class LogicAppWorkflowAccessControlContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppWorkflowAccessControlContent | undefined;
    set internalValue(value: LogicAppWorkflowAccessControlContent | undefined);
    private _allowedCallerIpAddressRange?;
    get allowedCallerIpAddressRange(): string[];
    set allowedCallerIpAddressRange(value: string[]);
    get allowedCallerIpAddressRangeInput(): string[] | undefined;
}
export interface LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaim {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#name LogicAppWorkflow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#value LogicAppWorkflow#value}
    */
    readonly value: string;
}
export declare function logicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaimToTerraform(struct?: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaim | cdktf.IResolvable): any;
export declare class LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaim | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaim | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaimList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaim[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaimOutputReference;
}
export interface LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#name LogicAppWorkflow#name}
    */
    readonly name: string;
    /**
    * claim block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#claim LogicAppWorkflow#claim}
    */
    readonly claim: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaim[] | cdktf.IResolvable;
}
export declare function logicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyToTerraform(struct?: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicy | cdktf.IResolvable): any;
export declare class LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicy | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _claim;
    get claim(): LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaimList;
    putClaim(value: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaim[] | cdktf.IResolvable): void;
    get claimInput(): cdktf.IResolvable | LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyClaim[] | undefined;
}
export declare class LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyOutputReference;
}
export interface LogicAppWorkflowAccessControlTrigger {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#allowed_caller_ip_address_range LogicAppWorkflow#allowed_caller_ip_address_range}
    */
    readonly allowedCallerIpAddressRange: string[];
    /**
    * open_authentication_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#open_authentication_policy LogicAppWorkflow#open_authentication_policy}
    */
    readonly openAuthenticationPolicy?: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicy[] | cdktf.IResolvable;
}
export declare function logicAppWorkflowAccessControlTriggerToTerraform(struct?: LogicAppWorkflowAccessControlTriggerOutputReference | LogicAppWorkflowAccessControlTrigger): any;
export declare class LogicAppWorkflowAccessControlTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppWorkflowAccessControlTrigger | undefined;
    set internalValue(value: LogicAppWorkflowAccessControlTrigger | undefined);
    private _allowedCallerIpAddressRange?;
    get allowedCallerIpAddressRange(): string[];
    set allowedCallerIpAddressRange(value: string[]);
    get allowedCallerIpAddressRangeInput(): string[] | undefined;
    private _openAuthenticationPolicy;
    get openAuthenticationPolicy(): LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicyList;
    putOpenAuthenticationPolicy(value: LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicy[] | cdktf.IResolvable): void;
    resetOpenAuthenticationPolicy(): void;
    get openAuthenticationPolicyInput(): cdktf.IResolvable | LogicAppWorkflowAccessControlTriggerOpenAuthenticationPolicy[] | undefined;
}
export interface LogicAppWorkflowAccessControlWorkflowManagement {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#allowed_caller_ip_address_range LogicAppWorkflow#allowed_caller_ip_address_range}
    */
    readonly allowedCallerIpAddressRange: string[];
}
export declare function logicAppWorkflowAccessControlWorkflowManagementToTerraform(struct?: LogicAppWorkflowAccessControlWorkflowManagementOutputReference | LogicAppWorkflowAccessControlWorkflowManagement): any;
export declare class LogicAppWorkflowAccessControlWorkflowManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppWorkflowAccessControlWorkflowManagement | undefined;
    set internalValue(value: LogicAppWorkflowAccessControlWorkflowManagement | undefined);
    private _allowedCallerIpAddressRange?;
    get allowedCallerIpAddressRange(): string[];
    set allowedCallerIpAddressRange(value: string[]);
    get allowedCallerIpAddressRangeInput(): string[] | undefined;
}
export interface LogicAppWorkflowAccessControl {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#action LogicAppWorkflow#action}
    */
    readonly action?: LogicAppWorkflowAccessControlAction;
    /**
    * content block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#content LogicAppWorkflow#content}
    */
    readonly content?: LogicAppWorkflowAccessControlContent;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#trigger LogicAppWorkflow#trigger}
    */
    readonly trigger?: LogicAppWorkflowAccessControlTrigger;
    /**
    * workflow_management block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#workflow_management LogicAppWorkflow#workflow_management}
    */
    readonly workflowManagement?: LogicAppWorkflowAccessControlWorkflowManagement;
}
export declare function logicAppWorkflowAccessControlToTerraform(struct?: LogicAppWorkflowAccessControlOutputReference | LogicAppWorkflowAccessControl): any;
export declare class LogicAppWorkflowAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppWorkflowAccessControl | undefined;
    set internalValue(value: LogicAppWorkflowAccessControl | undefined);
    private _action;
    get action(): LogicAppWorkflowAccessControlActionOutputReference;
    putAction(value: LogicAppWorkflowAccessControlAction): void;
    resetAction(): void;
    get actionInput(): LogicAppWorkflowAccessControlAction | undefined;
    private _content;
    get content(): LogicAppWorkflowAccessControlContentOutputReference;
    putContent(value: LogicAppWorkflowAccessControlContent): void;
    resetContent(): void;
    get contentInput(): LogicAppWorkflowAccessControlContent | undefined;
    private _trigger;
    get trigger(): LogicAppWorkflowAccessControlTriggerOutputReference;
    putTrigger(value: LogicAppWorkflowAccessControlTrigger): void;
    resetTrigger(): void;
    get triggerInput(): LogicAppWorkflowAccessControlTrigger | undefined;
    private _workflowManagement;
    get workflowManagement(): LogicAppWorkflowAccessControlWorkflowManagementOutputReference;
    putWorkflowManagement(value: LogicAppWorkflowAccessControlWorkflowManagement): void;
    resetWorkflowManagement(): void;
    get workflowManagementInput(): LogicAppWorkflowAccessControlWorkflowManagement | undefined;
}
export interface LogicAppWorkflowIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#identity_ids LogicAppWorkflow#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#type LogicAppWorkflow#type}
    */
    readonly type: string;
}
export declare function logicAppWorkflowIdentityToTerraform(struct?: LogicAppWorkflowIdentityOutputReference | LogicAppWorkflowIdentity): any;
export declare class LogicAppWorkflowIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppWorkflowIdentity | undefined;
    set internalValue(value: LogicAppWorkflowIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface LogicAppWorkflowTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#create LogicAppWorkflow#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#delete LogicAppWorkflow#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#read LogicAppWorkflow#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow#update LogicAppWorkflow#update}
    */
    readonly update?: string;
}
export declare function logicAppWorkflowTimeoutsToTerraform(struct?: LogicAppWorkflowTimeouts | cdktf.IResolvable): any;
export declare class LogicAppWorkflowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppWorkflowTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppWorkflowTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow azurerm_logic_app_workflow}
*/
export declare class LogicAppWorkflow extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_workflow";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/logic_app_workflow azurerm_logic_app_workflow} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppWorkflowConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppWorkflowConfig);
    get accessEndpoint(): string;
    get connectorEndpointIpAddresses(): string[];
    get connectorOutboundIpAddresses(): string[];
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationServiceEnvironmentId?;
    get integrationServiceEnvironmentId(): string;
    set integrationServiceEnvironmentId(value: string);
    resetIntegrationServiceEnvironmentId(): void;
    get integrationServiceEnvironmentIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _logicAppIntegrationAccountId?;
    get logicAppIntegrationAccountId(): string;
    set logicAppIntegrationAccountId(value: string);
    resetLogicAppIntegrationAccountId(): void;
    get logicAppIntegrationAccountIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get workflowEndpointIpAddresses(): string[];
    get workflowOutboundIpAddresses(): string[];
    private _workflowParameters?;
    get workflowParameters(): {
        [key: string]: string;
    };
    set workflowParameters(value: {
        [key: string]: string;
    });
    resetWorkflowParameters(): void;
    get workflowParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _workflowSchema?;
    get workflowSchema(): string;
    set workflowSchema(value: string);
    resetWorkflowSchema(): void;
    get workflowSchemaInput(): string | undefined;
    private _workflowVersion?;
    get workflowVersion(): string;
    set workflowVersion(value: string);
    resetWorkflowVersion(): void;
    get workflowVersionInput(): string | undefined;
    private _accessControl;
    get accessControl(): LogicAppWorkflowAccessControlOutputReference;
    putAccessControl(value: LogicAppWorkflowAccessControl): void;
    resetAccessControl(): void;
    get accessControlInput(): LogicAppWorkflowAccessControl | undefined;
    private _identity;
    get identity(): LogicAppWorkflowIdentityOutputReference;
    putIdentity(value: LogicAppWorkflowIdentity): void;
    resetIdentity(): void;
    get identityInput(): LogicAppWorkflowIdentity | undefined;
    private _timeouts;
    get timeouts(): LogicAppWorkflowTimeoutsOutputReference;
    putTimeouts(value: LogicAppWorkflowTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogicAppWorkflowTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
