import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicePlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#app_service_environment_id ServicePlan#app_service_environment_id}
    */
    readonly appServiceEnvironmentId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#id ServicePlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#location ServicePlan#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#maximum_elastic_worker_count ServicePlan#maximum_elastic_worker_count}
    */
    readonly maximumElasticWorkerCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#name ServicePlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#os_type ServicePlan#os_type}
    */
    readonly osType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#per_site_scaling_enabled ServicePlan#per_site_scaling_enabled}
    */
    readonly perSiteScalingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#resource_group_name ServicePlan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#sku_name ServicePlan#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#tags ServicePlan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#worker_count ServicePlan#worker_count}
    */
    readonly workerCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#zone_balancing_enabled ServicePlan#zone_balancing_enabled}
    */
    readonly zoneBalancingEnabled?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#timeouts ServicePlan#timeouts}
    */
    readonly timeouts?: ServicePlanTimeouts;
}
export interface ServicePlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#create ServicePlan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#delete ServicePlan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#read ServicePlan#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan#update ServicePlan#update}
    */
    readonly update?: string;
}
export declare function servicePlanTimeoutsToTerraform(struct?: ServicePlanTimeouts | cdktf.IResolvable): any;
export declare class ServicePlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicePlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServicePlanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan azurerm_service_plan}
*/
export declare class ServicePlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_service_plan";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/service_plan azurerm_service_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicePlanConfig
    */
    constructor(scope: Construct, id: string, config: ServicePlanConfig);
    private _appServiceEnvironmentId?;
    get appServiceEnvironmentId(): string;
    set appServiceEnvironmentId(value: string);
    resetAppServiceEnvironmentId(): void;
    get appServiceEnvironmentIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maximumElasticWorkerCount?;
    get maximumElasticWorkerCount(): number;
    set maximumElasticWorkerCount(value: number);
    resetMaximumElasticWorkerCount(): void;
    get maximumElasticWorkerCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    get osTypeInput(): string | undefined;
    private _perSiteScalingEnabled?;
    get perSiteScalingEnabled(): boolean | cdktf.IResolvable;
    set perSiteScalingEnabled(value: boolean | cdktf.IResolvable);
    resetPerSiteScalingEnabled(): void;
    get perSiteScalingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get reserved(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workerCount?;
    get workerCount(): number;
    set workerCount(value: number);
    resetWorkerCount(): void;
    get workerCountInput(): number | undefined;
    private _zoneBalancingEnabled?;
    get zoneBalancingEnabled(): boolean | cdktf.IResolvable;
    set zoneBalancingEnabled(value: boolean | cdktf.IResolvable);
    resetZoneBalancingEnabled(): void;
    get zoneBalancingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): ServicePlanTimeoutsOutputReference;
    putTimeouts(value: ServicePlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServicePlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
