import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusTopicAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#id ServicebusTopicAuthorizationRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#listen ServicebusTopicAuthorizationRule#listen}
    */
    readonly listen?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#manage ServicebusTopicAuthorizationRule#manage}
    */
    readonly manage?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#name ServicebusTopicAuthorizationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#send ServicebusTopicAuthorizationRule#send}
    */
    readonly send?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#topic_id ServicebusTopicAuthorizationRule#topic_id}
    */
    readonly topicId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#timeouts ServicebusTopicAuthorizationRule#timeouts}
    */
    readonly timeouts?: ServicebusTopicAuthorizationRuleTimeouts;
}
export interface ServicebusTopicAuthorizationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#create ServicebusTopicAuthorizationRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#delete ServicebusTopicAuthorizationRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#read ServicebusTopicAuthorizationRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule#update ServicebusTopicAuthorizationRule#update}
    */
    readonly update?: string;
}
export declare function servicebusTopicAuthorizationRuleTimeoutsToTerraform(struct?: ServicebusTopicAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare class ServicebusTopicAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicebusTopicAuthorizationRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServicebusTopicAuthorizationRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule azurerm_servicebus_topic_authorization_rule}
*/
export declare class ServicebusTopicAuthorizationRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_servicebus_topic_authorization_rule";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/servicebus_topic_authorization_rule azurerm_servicebus_topic_authorization_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusTopicAuthorizationRuleConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusTopicAuthorizationRuleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _listen?;
    get listen(): boolean | cdktf.IResolvable;
    set listen(value: boolean | cdktf.IResolvable);
    resetListen(): void;
    get listenInput(): boolean | cdktf.IResolvable | undefined;
    private _manage?;
    get manage(): boolean | cdktf.IResolvable;
    set manage(value: boolean | cdktf.IResolvable);
    resetManage(): void;
    get manageInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryConnectionStringAlias(): string;
    get primaryKey(): string;
    get secondaryConnectionString(): string;
    get secondaryConnectionStringAlias(): string;
    get secondaryKey(): string;
    private _send?;
    get send(): boolean | cdktf.IResolvable;
    set send(value: boolean | cdktf.IResolvable);
    resetSend(): void;
    get sendInput(): boolean | cdktf.IResolvable | undefined;
    private _topicId?;
    get topicId(): string;
    set topicId(value: string);
    get topicIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ServicebusTopicAuthorizationRuleTimeoutsOutputReference;
    putTimeouts(value: ServicebusTopicAuthorizationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServicebusTopicAuthorizationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
