import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SharedImageVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#blob_uri SharedImageVersion#blob_uri}
    */
    readonly blobUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#end_of_life_date SharedImageVersion#end_of_life_date}
    */
    readonly endOfLifeDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#exclude_from_latest SharedImageVersion#exclude_from_latest}
    */
    readonly excludeFromLatest?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#gallery_name SharedImageVersion#gallery_name}
    */
    readonly galleryName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#id SharedImageVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#image_name SharedImageVersion#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#location SharedImageVersion#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#managed_image_id SharedImageVersion#managed_image_id}
    */
    readonly managedImageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#name SharedImageVersion#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#os_disk_snapshot_id SharedImageVersion#os_disk_snapshot_id}
    */
    readonly osDiskSnapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#replication_mode SharedImageVersion#replication_mode}
    */
    readonly replicationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#resource_group_name SharedImageVersion#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#storage_account_id SharedImageVersion#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#tags SharedImageVersion#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * target_region block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#target_region SharedImageVersion#target_region}
    */
    readonly targetRegion: SharedImageVersionTargetRegion[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#timeouts SharedImageVersion#timeouts}
    */
    readonly timeouts?: SharedImageVersionTimeouts;
}
export interface SharedImageVersionTargetRegion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#disk_encryption_set_id SharedImageVersion#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#name SharedImageVersion#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#regional_replica_count SharedImageVersion#regional_replica_count}
    */
    readonly regionalReplicaCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#storage_account_type SharedImageVersion#storage_account_type}
    */
    readonly storageAccountType?: string;
}
export declare function sharedImageVersionTargetRegionToTerraform(struct?: SharedImageVersionTargetRegion | cdktf.IResolvable): any;
export declare class SharedImageVersionTargetRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SharedImageVersionTargetRegion | cdktf.IResolvable | undefined;
    set internalValue(value: SharedImageVersionTargetRegion | cdktf.IResolvable | undefined);
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _regionalReplicaCount?;
    get regionalReplicaCount(): number;
    set regionalReplicaCount(value: number);
    get regionalReplicaCountInput(): number | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    resetStorageAccountType(): void;
    get storageAccountTypeInput(): string | undefined;
}
export declare class SharedImageVersionTargetRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SharedImageVersionTargetRegion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SharedImageVersionTargetRegionOutputReference;
}
export interface SharedImageVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#create SharedImageVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#delete SharedImageVersion#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#read SharedImageVersion#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version#update SharedImageVersion#update}
    */
    readonly update?: string;
}
export declare function sharedImageVersionTimeoutsToTerraform(struct?: SharedImageVersionTimeouts | cdktf.IResolvable): any;
export declare class SharedImageVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SharedImageVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SharedImageVersionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version azurerm_shared_image_version}
*/
export declare class SharedImageVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_shared_image_version";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/shared_image_version azurerm_shared_image_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SharedImageVersionConfig
    */
    constructor(scope: Construct, id: string, config: SharedImageVersionConfig);
    private _blobUri?;
    get blobUri(): string;
    set blobUri(value: string);
    resetBlobUri(): void;
    get blobUriInput(): string | undefined;
    private _endOfLifeDate?;
    get endOfLifeDate(): string;
    set endOfLifeDate(value: string);
    resetEndOfLifeDate(): void;
    get endOfLifeDateInput(): string | undefined;
    private _excludeFromLatest?;
    get excludeFromLatest(): boolean | cdktf.IResolvable;
    set excludeFromLatest(value: boolean | cdktf.IResolvable);
    resetExcludeFromLatest(): void;
    get excludeFromLatestInput(): boolean | cdktf.IResolvable | undefined;
    private _galleryName?;
    get galleryName(): string;
    set galleryName(value: string);
    get galleryNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managedImageId?;
    get managedImageId(): string;
    set managedImageId(value: string);
    resetManagedImageId(): void;
    get managedImageIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _osDiskSnapshotId?;
    get osDiskSnapshotId(): string;
    set osDiskSnapshotId(value: string);
    resetOsDiskSnapshotId(): void;
    get osDiskSnapshotIdInput(): string | undefined;
    private _replicationMode?;
    get replicationMode(): string;
    set replicationMode(value: string);
    resetReplicationMode(): void;
    get replicationModeInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _targetRegion;
    get targetRegion(): SharedImageVersionTargetRegionList;
    putTargetRegion(value: SharedImageVersionTargetRegion[] | cdktf.IResolvable): void;
    get targetRegionInput(): cdktf.IResolvable | SharedImageVersionTargetRegion[] | undefined;
    private _timeouts;
    get timeouts(): SharedImageVersionTimeoutsOutputReference;
    putTimeouts(value: SharedImageVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SharedImageVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
