import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SignalrServiceNetworkAclConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#default_action SignalrServiceNetworkAcl#default_action}
    */
    readonly defaultAction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#id SignalrServiceNetworkAcl#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#signalr_service_id SignalrServiceNetworkAcl#signalr_service_id}
    */
    readonly signalrServiceId: string;
    /**
    * private_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#private_endpoint SignalrServiceNetworkAcl#private_endpoint}
    */
    readonly privateEndpoint?: SignalrServiceNetworkAclPrivateEndpoint[] | cdktf.IResolvable;
    /**
    * public_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#public_network SignalrServiceNetworkAcl#public_network}
    */
    readonly publicNetwork: SignalrServiceNetworkAclPublicNetwork;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#timeouts SignalrServiceNetworkAcl#timeouts}
    */
    readonly timeouts?: SignalrServiceNetworkAclTimeouts;
}
export interface SignalrServiceNetworkAclPrivateEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#allowed_request_types SignalrServiceNetworkAcl#allowed_request_types}
    */
    readonly allowedRequestTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#denied_request_types SignalrServiceNetworkAcl#denied_request_types}
    */
    readonly deniedRequestTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#id SignalrServiceNetworkAcl#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function signalrServiceNetworkAclPrivateEndpointToTerraform(struct?: SignalrServiceNetworkAclPrivateEndpoint | cdktf.IResolvable): any;
export declare class SignalrServiceNetworkAclPrivateEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SignalrServiceNetworkAclPrivateEndpoint | cdktf.IResolvable | undefined;
    set internalValue(value: SignalrServiceNetworkAclPrivateEndpoint | cdktf.IResolvable | undefined);
    private _allowedRequestTypes?;
    get allowedRequestTypes(): string[];
    set allowedRequestTypes(value: string[]);
    resetAllowedRequestTypes(): void;
    get allowedRequestTypesInput(): string[] | undefined;
    private _deniedRequestTypes?;
    get deniedRequestTypes(): string[];
    set deniedRequestTypes(value: string[]);
    resetDeniedRequestTypes(): void;
    get deniedRequestTypesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export declare class SignalrServiceNetworkAclPrivateEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SignalrServiceNetworkAclPrivateEndpoint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SignalrServiceNetworkAclPrivateEndpointOutputReference;
}
export interface SignalrServiceNetworkAclPublicNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#allowed_request_types SignalrServiceNetworkAcl#allowed_request_types}
    */
    readonly allowedRequestTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#denied_request_types SignalrServiceNetworkAcl#denied_request_types}
    */
    readonly deniedRequestTypes?: string[];
}
export declare function signalrServiceNetworkAclPublicNetworkToTerraform(struct?: SignalrServiceNetworkAclPublicNetworkOutputReference | SignalrServiceNetworkAclPublicNetwork): any;
export declare class SignalrServiceNetworkAclPublicNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SignalrServiceNetworkAclPublicNetwork | undefined;
    set internalValue(value: SignalrServiceNetworkAclPublicNetwork | undefined);
    private _allowedRequestTypes?;
    get allowedRequestTypes(): string[];
    set allowedRequestTypes(value: string[]);
    resetAllowedRequestTypes(): void;
    get allowedRequestTypesInput(): string[] | undefined;
    private _deniedRequestTypes?;
    get deniedRequestTypes(): string[];
    set deniedRequestTypes(value: string[]);
    resetDeniedRequestTypes(): void;
    get deniedRequestTypesInput(): string[] | undefined;
}
export interface SignalrServiceNetworkAclTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#create SignalrServiceNetworkAcl#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#delete SignalrServiceNetworkAcl#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#read SignalrServiceNetworkAcl#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl#update SignalrServiceNetworkAcl#update}
    */
    readonly update?: string;
}
export declare function signalrServiceNetworkAclTimeoutsToTerraform(struct?: SignalrServiceNetworkAclTimeouts | cdktf.IResolvable): any;
export declare class SignalrServiceNetworkAclTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SignalrServiceNetworkAclTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SignalrServiceNetworkAclTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl azurerm_signalr_service_network_acl}
*/
export declare class SignalrServiceNetworkAcl extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_signalr_service_network_acl";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/signalr_service_network_acl azurerm_signalr_service_network_acl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SignalrServiceNetworkAclConfig
    */
    constructor(scope: Construct, id: string, config: SignalrServiceNetworkAclConfig);
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    get defaultActionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _signalrServiceId?;
    get signalrServiceId(): string;
    set signalrServiceId(value: string);
    get signalrServiceIdInput(): string | undefined;
    private _privateEndpoint;
    get privateEndpoint(): SignalrServiceNetworkAclPrivateEndpointList;
    putPrivateEndpoint(value: SignalrServiceNetworkAclPrivateEndpoint[] | cdktf.IResolvable): void;
    resetPrivateEndpoint(): void;
    get privateEndpointInput(): cdktf.IResolvable | SignalrServiceNetworkAclPrivateEndpoint[] | undefined;
    private _publicNetwork;
    get publicNetwork(): SignalrServiceNetworkAclPublicNetworkOutputReference;
    putPublicNetwork(value: SignalrServiceNetworkAclPublicNetwork): void;
    get publicNetworkInput(): SignalrServiceNetworkAclPublicNetwork | undefined;
    private _timeouts;
    get timeouts(): SignalrServiceNetworkAclTimeoutsOutputReference;
    putTimeouts(value: SignalrServiceNetworkAclTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SignalrServiceNetworkAclTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
