"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.2.1912
    Contact: servicedesk@veeroute.com
    Auto Generated
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_agro.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from vrt_lss_agro.exceptions import ApiAttributeError


def lazy_import():
    from vrt_lss_agro.model.crop import Crop
    from vrt_lss_agro.model.elevator import Elevator
    from vrt_lss_agro.model.factory import Factory
    from vrt_lss_agro.model.field import Field
    from vrt_lss_agro.model.leftover import Leftover
    from vrt_lss_agro.model.market import Market
    from vrt_lss_agro.model.movement_matrix import MovementMatrix
    from vrt_lss_agro.model.plan_settings import PlanSettings
    globals()['Crop'] = Crop
    globals()['Elevator'] = Elevator
    globals()['Factory'] = Factory
    globals()['Field'] = Field
    globals()['Leftover'] = Leftover
    globals()['Market'] = Market
    globals()['MovementMatrix'] = MovementMatrix
    globals()['PlanSettings'] = PlanSettings


class PlanTask(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('crops',): {
            'max_items': 201,
            'min_items': 1,
        },
        ('fields',): {
            'max_items': 20001,
            'min_items': 1,
        },
        ('factories',): {
            'max_items': 201,
            'min_items': 1,
        },
        ('elevators',): {
            'max_items': 201,
            'min_items': 1,
        },
        ('markets',): {
            'max_items': 201,
            'min_items': 1,
        },
        ('leftovers',): {
            'max_items': 25001,
            'min_items': 0,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'crops': ([Crop],),  
            'fields': ([Field],),  
            'factories': ([Factory],),  
            'movement_matrix': (MovementMatrix,),  
            'plan_settings': (PlanSettings,),  
            'elevators': ([Elevator],),  
            'markets': ([Market],),  
            'leftovers': ([Leftover],),  
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'crops': 'crops',  
        'fields': 'fields',  
        'factories': 'factories',  
        'movement_matrix': 'movement_matrix',  
        'plan_settings': 'plan_settings',  
        'elevators': 'elevators',  
        'markets': 'markets',  
        'leftovers': 'leftovers',  
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, crops, fields, factories, movement_matrix, plan_settings, *args, **kwargs):  
        """PlanTask - a model defined in OpenAPI

        Args:
            crops ([Crop]): List of crops.
            fields ([Field]): List of fields.
            factories ([Factory]): List of factories.
            movement_matrix (MovementMatrix):
            plan_settings (PlanSettings):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            elevators ([Elevator]): List of elevators.. [optional]  
            markets ([Market]): List of markets.. [optional]  
            leftovers ([Leftover]): List of leftovers.. [optional]  
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.crops = crops
        self.fields = fields
        self.factories = factories
        self.movement_matrix = movement_matrix
        self.plan_settings = plan_settings
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, crops, fields, factories, movement_matrix, plan_settings, *args, **kwargs):  
        """PlanTask - a model defined in OpenAPI

        Args:
            crops ([Crop]): List of crops.
            fields ([Field]): List of fields.
            factories ([Factory]): List of factories.
            movement_matrix (MovementMatrix):
            plan_settings (PlanSettings):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            elevators ([Elevator]): List of elevators.. [optional]  
            markets ([Market]): List of markets.. [optional]  
            leftovers ([Leftover]): List of leftovers.. [optional]  
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.crops = crops
        self.fields = fields
        self.factories = factories
        self.movement_matrix = movement_matrix
        self.plan_settings = plan_settings
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
