# Copyright Contributors to the Amundsen project.
# SPDX-License-Identifier: Apache-2.0
from typing import Union

from amundsen_rds.models.application import Application, ApplicationTable
from amundsen_rds.models.badge import Badge
from amundsen_rds.models.cluster import Cluster
from amundsen_rds.models.column import (
    ColumnBadge, ColumnDescription, ColumnStat, TableColumn
)
from amundsen_rds.models.dashboard import (
    Dashboard, DashboardBadge, DashboardChart, DashboardCluster,
    DashboardDescription, DashboardExecution, DashboardFollower,
    DashboardGroup, DashboardGroupDescription, DashboardOwner, DashboardQuery,
    DashboardTable, DashboardTag, DashboardTimestamp, DashboardUsage
)
from amundsen_rds.models.database import Database
from amundsen_rds.models.schema import (
    Schema, SchemaDescription, SchemaProgrammaticDescription
)
from amundsen_rds.models.table import (
    Table, TableBadge, TableDescription, TableFollower, TableOwner,
    TableProgrammaticDescription, TableSource, TableTag, TableTimestamp,
    TableUsage, TableWatermark
)
from amundsen_rds.models.tag import Tag
from amundsen_rds.models.updated_timestamp import UpdatedTimestamp
from amundsen_rds.models.user import User

RDSModel = Union[Application, ApplicationTable, Badge, Cluster,
                 TableColumn, ColumnBadge, ColumnDescription, ColumnStat,
                 Dashboard, DashboardBadge, DashboardChart, DashboardCluster,
                 DashboardDescription, DashboardExecution, DashboardFollower, DashboardGroup,
                 DashboardGroupDescription, DashboardOwner, DashboardQuery, DashboardTable,
                 DashboardTag, DashboardTimestamp, DashboardUsage, Database,
                 Schema, SchemaDescription, SchemaProgrammaticDescription, Table,
                 TableBadge, TableDescription, TableFollower, TableOwner,
                 TableProgrammaticDescription, TableSource, TableTag, TableTimestamp,
                 TableUsage, TableWatermark, Tag, UpdatedTimestamp,
                 User]

__all__ = [
    'Application', 'ApplicationTable', 'Badge', 'Cluster',
    'TableColumn', 'ColumnBadge', 'ColumnDescription', 'ColumnStat',
    'Dashboard', 'DashboardBadge', 'DashboardChart', 'DashboardCluster',
    'DashboardDescription', 'DashboardExecution', 'DashboardFollower', 'DashboardGroup',
    'DashboardGroupDescription', 'DashboardOwner', 'DashboardQuery', 'DashboardTable',
    'DashboardTag', 'DashboardTimestamp', 'DashboardUsage', 'Database',
    'Schema', 'SchemaDescription', 'SchemaProgrammaticDescription', 'Table',
    'TableBadge', 'TableDescription', 'TableFollower', 'TableOwner',
    'TableProgrammaticDescription', 'TableSource', 'TableTag', 'TableTimestamp',
    'TableUsage', 'TableWatermark', 'Tag', 'UpdatedTimestamp',
    'User', 'RDSModel'
]
