# coding: utf-8

"""
--------------------------------------------------------------------------------------------------------------------
<copyright company="Aspose" file="object_exist.py">
Copyright (c) 2022 Aspose.HTML for Cloud
</copyright>

<summary>
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
</summary>
--------------------------------------------------------------------------------------------------------------------
"""

from asposehtmlcloud.models import BaseModel

class ObjectExist(BaseModel):
    """
    Attributes:
      model_types (dict):   The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    model_types = {
        'exists': 'bool',
        'is_folder': 'bool'
    }

    attribute_map = {
        'exists': 'exists',
        'is_folder': 'isFolder'
    }

    def __init__(self, exists=None, is_folder=None):

        self._exists = None
        self._is_folder = None

        self.exists = exists
        self.is_folder = is_folder

    @property
    def exists(self):
        """Gets the exists of this ObjectExist.

        Indicates that the file or folder exists.

        :return: The exists of this ObjectExist.
        :rtype: bool
        """
        return self._exists

    @exists.setter
    def exists(self, exists):
        """Sets the exists of this ObjectExist.

        Indicates that the file or folder exists.

        :param exists: The exists of this ObjectExist.
        :type: bool
        """
        if exists is None:
            raise ValueError("Invalid value for `exists`, must not be `None`")

        self._exists = exists

    @property
    def is_folder(self):
        """Gets the is_folder of this ObjectExist.

        True if it is a folder, false if it is a file.

        :return: The is_folder of this ObjectExist.
        :rtype: bool
        """
        return self._is_folder

    @is_folder.setter
    def is_folder(self, is_folder):
        """Sets the is_folder of this ObjectExist.

        True if it is a folder, false if it is a file.

        :param is_folder: The is_folder of this ObjectExist.
        :type: bool
        """
        if is_folder is None:
            raise ValueError("Invalid value for `is_folder`, must not be `None`")

        self._is_folder = is_folder
