"""Modul za testiranje objekata iz modula trajektorije
"""

"""
*** BIBLIOTEKE ***
"""
import mehanika_robota.mehanika.trajektorija as traj
import numpy as np
import pytest

"""
*** TESTOVI ***
"""
def test_vreme_skal() -> None:
    f = traj.vreme_skal

    # Pravilna upotreba
    assert np.allclose(
        f(0.6, 2, 3),
        0.216
    )

    assert np.allclose(
        f([[0.2], [1]], 2, 3),
        [[0.028], [0.5]]
    )

    assert np.allclose(
        f([[1, 2], [3, 4]], 5, 5),
        [[0.05792, 0.31744], [0.68256, 0.94208]]
    )

    # Nepravilna upotreba
    with pytest.raises(ValueError):
        assert f([1, 0, 0], -3, 3)
    
    with pytest.raises(ValueError):
        assert f([1, 2, 3], 2, 5)
    
    with pytest.raises(ValueError):
        assert f(1, 4, -3)

def test_pravolin_traj() -> None:
    f = traj.pravolin_traj

    # Pravilna upotreba
    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"n": 2}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"n": 3}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 1.5],
             [0, 1, 0,   0],
             [0, 0, 1,   0],
             [0, 0, 0,   1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"n": 4}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 1],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 2],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"skal": [0, 1]}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"skal": [0, 0.2, 0.75, 1]}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0.6],
             [0, 1, 0,   0],
             [0, 0, 1,   0],
             [0, 0, 0,   1]],
            [[1, 0, 0, 2.25],
             [0, 1, 0,    0],
             [0, 0, 1,    0],
             [0, 0, 0,    1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"n": 2, "t_ukupno": 3, "stepen": 3}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"t_ukupno": 4, "n": 3, "stepen": 5}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 1.5],
             [0, 1, 0,   0],
             [0, 0, 1,   0],
             [0, 0, 0,   1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"stepen": 3, "t_ukupno": 10, "n": 5}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0.46875],
             [0, 1, 0,       0],
             [0, 0, 1,       0],
             [0, 0, 0,       1]],
            [[1, 0, 0, 1.5],
             [0, 1, 0,   0],
             [0, 0, 1,   0],
             [0, 0, 0,   1]],
            [[1, 0, 0, 2.53125],
             [0, 1, 0,       0],
             [0, 0, 1,       0],
             [0, 0, 0,       1]],
            [[1, 0, 0, 3],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]],
            {"n": 2}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]],
            {"n": 3}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,          0,                 0],
             [0, 0.70710678119, -0.70710678119, 0],
             [0, 0.70710678119,  0.70710678119, 0],
             [0, 0,          0,                 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]],
            {"n": 4}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,          0,                 0],
             [0, 0.86602540378,           -0.5, 0],
             [0,           0.5,  0.86602540378, 0],
             [0, 0,          0,                 1]],
            [[1, 0,          0,                 0],
             [0,           0.5, -0.86602540378, 0],
             [0, 0.86602540378,            0.5, 0],
             [0, 0,          0,                 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]],
            {"skal": [0, 1]}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]],
            {"skal": [0, 0.2, 0.75, 1]}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,                          0, 0],
             [0, 0.95105651630, -0.30901699437, 0],
             [0, 0.30901699437,  0.95105651630, 0],
             [0, 0,                          0, 1]],
            [[1, 0,                          0, 0],
             [0, 0.38268343237, -0.92387953251, 0],
             [0, 0.92387953251,  0.38268343237, 0],
             [0, 0,                          0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]],
            {
                "n": 2,
                "t_ukupno": 3,
                "stepen": 3
            }
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]],
            {
                "n": 3,
                "t_ukupno": 4,
                "stepen": 5
            }
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,          0,                 0],
             [0, 0.70710678119, -0.70710678119, 0],
             [0, 0.70710678119,  0.70710678119, 0],
             [0, 0,          0,                 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]],
            {
                "n": 5,
                "t_ukupno": 10,
                "stepen": 3
            }
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,                         0, 0],
             [0, 0.97003125319, -0.2429801799, 0],
             [0,  0.2429801799, 0.97003125319, 0],
             [0, 0,                         0, 1]],
            [[1, 0,          0,                 0],
             [0, 0.70710678119, -0.70710678119, 0],
             [0, 0.70710678119,  0.70710678119, 0],
             [0, 0,          0,                 1]],
            [[1, 0,                          0, 0],
             [0,  0.2429801799, -0.97003125319, 0],
             [0, 0.97003125319,   0.2429801799, 0],
             [0, 0,                          0, 1]],
            [[1, 0,  0, 0],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]]
        )
    )

    assert np.allclose(
        f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,  0, 3],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]],
            {"skal": [0, 0.2, 0.75, 1]}
        ),
        (
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0,                          0, 0.6],
             [0, 0.95105651630, -0.30901699437,   0],
             [0, 0.30901699437,  0.95105651630,   0],
             [0, 0,                          0,   1]],
            [[1, 0,                          0, 2.25],
             [0, 0.38268343237, -0.92387953251,    0],
             [0, 0.92387953251,  0.38268343237,    0],
             [0, 0,                          0,    1]],
            [[1, 0,  0, 3],
             [0, 0, -1, 0],
             [0, 1,  0, 0],
             [0, 0,  0, 1]]
        )
    )

    # Nepravilna upotreba
    with pytest.raises(ValueError):
        assert f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"n": 1}
        )

    with pytest.raises(ValueError):
        assert f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"skal": [[1, 2], [3, 4]]}
        )

    with pytest.raises(ValueError):
        assert f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"skal": [[1, 2, 3], [4, 5, 6], [7, 8, 9]]}
        )

    with pytest.raises(ValueError):
        assert f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"skal": [2.3]}
        )

    with pytest.raises(ValueError):
        assert f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"skal": [0.0, 0.2, 0.1, 1.0]}
        )

    with pytest.raises(ValueError):
        assert f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"skal": [0.2, 0.3, 0.4, 1.0]}
        )

    with pytest.raises(ValueError):
        assert f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {
                "t_ukupno": 3.0,
                "stepen": 5,
                "n": -2
            }
        )

    with pytest.raises(ValueError):
        assert f(
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            [[1, 0, 0, 0],
             [0, 1, 0, 0],
             [0, 0, 1, 0],
             [0, 0, 0, 1]],
            {"a": 2}
        )