# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: a4695a3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, Optional
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class RespChunkLineageEdge(BaseModel):
    """
    RespChunkLineageEdge
    """ # noqa: E501
    chunk_id: UUID = Field(description="The child chunk ID")
    parent_chunk_id: Optional[UUID] = Field(default=None, description="The parent chunk ID if any (None for SOURCE)")
    parent_chunk_container_id: Optional[UUID] = Field(default=None, description="The parent chunk container ID if any")
    generation_reasoning: StrictStr = Field(description="Reasoning for how the child was generated from the parent")
    level: StrictInt = Field(description="Depth level in lineage traversal")
    __properties: ClassVar[List[str]] = ["chunk_id", "parent_chunk_id", "parent_chunk_container_id", "generation_reasoning", "level"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespChunkLineageEdge from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespChunkLineageEdge from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chunk_id": obj.get("chunk_id"),
            "parent_chunk_id": obj.get("parent_chunk_id"),
            "parent_chunk_container_id": obj.get("parent_chunk_container_id"),
            "generation_reasoning": obj.get("generation_reasoning"),
            "level": obj.get("level")
        })
        return _obj


