# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: a4695a3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, Optional
from uuid import UUID
from knowledge_stack.models.api_key_credential_type import APIKeyCredentialType
from typing import Optional, Set
from typing_extensions import Self

class RespGetAccessTokenIdentity(BaseModel):
    """
    Schema for access token validation response.
    """ # noqa: E501
    organization_id: Optional[UUID] = Field(default=None, description="ID of the organization")
    tenant_id: Optional[UUID] = Field(default=None, description="ID of the tenant")
    participant_id: Optional[UUID] = Field(default=None, description="ID of the participant")
    expires_at: Optional[datetime] = Field(default=None, description="Expiration time of the token")
    credential_type: APIKeyCredentialType = Field(description="Type of token")
    __properties: ClassVar[List[str]] = ["organization_id", "tenant_id", "participant_id", "expires_at", "credential_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespGetAccessTokenIdentity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespGetAccessTokenIdentity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "organization_id": obj.get("organization_id"),
            "tenant_id": obj.get("tenant_id"),
            "participant_id": obj.get("participant_id"),
            "expires_at": obj.get("expires_at"),
            "credential_type": obj.get("credential_type")
        })
        return _obj


