(function(){RB.DatagridPage=RB.Page.extend({defaults:_.defaults({count:0,localSiteName:null},RB.Page.prototype.defaults),rowObjectType:null,initialize:function(){this.selection=new Backbone.Collection([],{model:this.rowObjectType});this.listenTo(this.selection,"add remove reset",function(){this.set("count",this.selection.length)})},select:function(id){var localSiteName=this.get("localSiteName");this.selection.add({id:id,localSitePrefix:localSiteName?"s/"+localSiteName+"/":null})},unselect:function(id){this.selection.remove(this.selection.get(id))},clearSelection:function(){this.selection.reset()}});RB.Dashboard=RB.DatagridPage.extend({rowObjectType:RB.ReviewRequest,closeReviewRequests:function(options){var reviewRequests=this.selection.clone(),successes=[],failures=[];function closeNext(){var reviewRequest;if(reviewRequests.length===0){this.selection.reset();this.trigger("refresh");options.onDone(successes,failures);return}reviewRequest=reviewRequests.shift();reviewRequest.close({type:options.closeType,success:function(){successes.push(reviewRequest)},error:function(){failures.push(reviewRequest)},complete:_.bind(closeNext,this)})}closeNext.call(this)},updateVisibility:function(visibilityFunc){var reviewRequests=this.selection.clone(),successes=[],failures=[];function hideNext(){var reviewRequest;if(reviewRequests.length===0){this.selection.reset();this.trigger("refresh");return}reviewRequest=reviewRequests.shift();visibilityFunc(reviewRequest,{success:function(){successes.push(reviewRequest);hideNext.call(this)},error:function(){failures.push(reviewRequest);hideNext.call(this)}},this)}hideNext.call(this)}});RB.DatagridPageView=RB.PageView.extend({RELOAD_INTERVAL_MS:5*60*1e3,actionsViewType:null,events:{"change tbody input[data-checkbox-name=select]":"_onRowSelected","reloaded .datagrid-wrapper":"_setupDatagrid"},initialize:function(options){RB.PageView.prototype.initialize.call(this,options);options=options||{};this.periodicReload=!!options.periodicReload;this._bottomSpacing=null;this._reloadTimer=null;this._datagrid=null;this._$wrapper=null;this._$datagridBody=null;this._$datagridBodyContainer=null;this._$window=null;this._menuShown=false;this._origActionsLeft=null},render:function(){RB.InfoboxManagerView.getInstance().setPositioning(RB.ReviewRequestInfoboxView,{side:"Ll",LDistance:300,lDistance:20,yOffset:-20});this._$window=$(window);if(this.actionsViewType){this._setupActionsView()}this.listenTo(this.model,"refresh",function(){this._reload(false)});this._setupDatagrid();if(this.periodicReload){this._startReloadTimer()}this._$window.resize(_.bind(this._updateSize,this));return this},_setupActionsView:function(){this._actionsView=new this.actionsViewType({model:this.model,datagridView:this});this._actionsView.$el.addClass("datagrid-actions");this._actionsView.render();this.listenTo(this.model,"change:count",function(model,count){var showMenu=count>0;if(showMenu===this._menuShown){return}if(showMenu){this._showActions();this._stopReloadTimer()}else{this._hideActions();if(this.periodicReload){this._startReloadTimer()}}this._menuShown=showMenu})},_setupDatagrid:function(){this._$wrapper=this.$("#content_container");this._$datagrid=this._$wrapper.find(".datagrid-wrapper");this._datagrid=this._$datagrid.data("datagrid");this._$main=this._$wrapper.find(".datagrid-main");this._$sidebarItems=this.$(".page-sidebar-items");if(this._actionsView){this._$actionsContainer=$("<div/>").addClass("datagrid-actions-container").append(this._actionsView.$el).appendTo($("#page_sidebar"));this._actionsView.delegateEvents()}this.$("time.timesince").timesince();this.$(".user").user_infobox();this.$(".bugs").find("a").bug_infobox();this.$(".review-request-link").review_request_infobox();this.model.clearSelection();_.each(this.$("input[data-checkbox-name=select]:checked"),function(checkbox){this.model.select($(checkbox).data("object-id"))},this);this._updateSize();if(RB.UserSession.instance.get("authenticated")){this._starManager=new RB.StarManagerView({model:new RB.StarManager,el:this._$main,datagridMode:true})}this._$datagrid.on("reloaded",_.bind(this._setupDatagrid,this))},_showActions:function(){var $actionsViewEl=this._actionsView.$el;if(this._origActionsLeft===null){this._origActionsLeft=$actionsViewEl.css("left")}this._$sidebarItems.fadeOut("fast");this._$actionsContainer.show();$actionsViewEl.css("left",$actionsViewEl.outerWidth()).show().animate({left:this._origActionsLeft})},_hideActions:function(){var $actionsViewEl=this._actionsView.$el;this._$sidebarItems.fadeIn("slow");$actionsViewEl.animate({left:$actionsViewEl.outerWidth()},{complete:_.bind(function(){$actionsViewEl.hide();this._$actionsContainer.hide()},this)})},_updateSize:function(){this.$el.show().outerHeight(this._$window.height()-this.$el.offset().top-this._getBottomSpacing());this._datagrid.resizeToFit()},_getBottomSpacing:function(){if(this._bottomSpacing===null){this._bottomSpacing=0;_.each(this.$el.parents(),function(parentEl){this._bottomSpacing+=$(parentEl).getExtents("bmp","b")},this)}return this._bottomSpacing},_startReloadTimer:function(){if(!this._reloadTimer){this._reloadTimer=setInterval(_.bind(this._reload,this),this.RELOAD_INTERVAL_MS)}},_stopReloadTimer:function(){if(this._reloadTimer){window.clearInterval(this._reloadTimer);this._reloadTimer=null}},_reload:function(periodicReload){var $editCols=this.$(".edit-columns");if(periodicReload===false){this._stopReloadTimer()}this.model.clearSelection();$editCols.width($editCols.width()-$editCols.getExtents("b","lr")).html('<span class="fa fa-spinner fa-pulse"></span>');this._$wrapper.load(window.location+" #content_container",_.bind(function(){this.$(".datagrid-wrapper").datagrid();this._setupDatagrid();if(periodicReload!==false){this._startReloadTimer()}},this))},_onRowSelected:function(e){var $checkbox=$(e.target),objectID=$checkbox.data("object-id");if($checkbox.prop("checked")){this.model.select(objectID)}else{this.model.unselect(objectID)}}});(function(){var DashboardActionsView=Backbone.View.extend({template:_.template(['<div class="datagrid-actions-content">',' <p class="count"></p>'," <ul>",'  <li><a class="discard" href="#"><%= close_discarded_text %></a></li>','  <li><a class="submit" href="#"><%= close_submitted_text %></a></li>',"  <li>&nbsp;</li>",'  <li><a class="archive" href="#"><%= archive_text %></a></li>',"<% if (show_archived) { %>",'  <li><a class="unarchive" href="#"><%= unarchive_text %></a></li>',"<% } %>","  <li>&nbsp;</li>",'  <li><a class="mute" href="#"><%= mute_text %></a></li>',"<% if (show_archived) { %>",'  <li><a class="unmute" href="#"><%= unmute_text %></a></li>',"<% } %>"," </ul>","</div>"].join("")),events:{"click .discard":"_onCloseDiscardedClicked","click .submit":"_onCloseSubmittedClicked","click .archive":"_onArchiveClicked","click .unarchive":"_onUnarchiveClicked","click .mute":"_onMuteClicked","click .unmute":"_onUnmuteClicked"},initialize:function(){this._$content=null;this._$count=null},render:function(){var show_archived=(this.model.get("data")||{}).show_archived;this.$el.hide().html(this.template({close_discarded_text:gettext("<b>Close</b> Discarded"),close_submitted_text:gettext("<b>Close</b> Submitted"),archive_text:gettext("<b>Archive</b>"),mute_text:gettext("<b>Mute</b>"),unarchive_text:gettext("<b>Unarchive</b>"),unmute_text:gettext("<b>Unmute</b>"),show_archived:show_archived}));this._$content=this.$(".datagrid-actions-content");this._$count=this.$(".count");this.listenTo(this.model,"change:count",function(model,count){this._$count.text(interpolate(ngettext("%s review request selected","%s review requests selected",count),[count]))});return this},_onCloseDiscardedClicked:function(){this._closeReviewRequests(RB.ReviewRequest.CLOSE_DISCARDED);return false},_onCloseSubmittedClicked:function(){this._closeReviewRequests(RB.ReviewRequest.CLOSE_SUBMITTED);return false},_closeReviewRequests:function(closeType){this._confirmClose(function(){this.model.closeReviewRequests({closeType:closeType,onDone:_.bind(this._showCloseResults,this)})})},_showCloseResults:function(successes,failures){var numSuccesses=successes.length,numFailures=failures.length,$dlg=$("<div/>").append($("<p/>").text(interpolate(ngettext("%s review request has been closed.","%s review requests have been closed.",numSuccesses),[numSuccesses])));if(numFailures>0){$dlg.append($("<p/>").text(interpolate(ngettext("%s review request could not be closed.","%s review requests could not be closed.",numFailures),[numFailures]))).append($("<p/>").text(gettext("You may not have permission to close them.")))}$dlg.modalBox({title:gettext("Close review requests"),buttons:[$('<input type="button"/>').val(gettext("Thanks!"))]})},_confirmClose:function(onConfirmed){$("<div/>").append($("<p/>").text(gettext("If these review requests have unpublished drafts, they will be discarded."))).append($("<p/>").text(gettext("Are you sure you want to close these review requests?"))).modalBox({title:gettext("Close review requests"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input type="button"/>').val(gettext("Close Review Requests")).click(_.bind(onConfirmed,this))]})},_onArchiveClicked:function(){var collection=RB.UserSession.instance.archivedReviewRequests;this._updateVisibility(_.bind(collection.addImmediately,collection));return false},_onUnarchiveClicked:function(){var collection=RB.UserSession.instance.archivedReviewRequests;this._updateVisibility(_.bind(collection.removeImmediately,collection));return false},_onMuteClicked:function(){var collection=RB.UserSession.instance.mutedReviewRequests,visibilityFunc=_.bind(collection.addImmediately,collection);$("<div/>").append($("<p/>").text(gettext("Are you sure you want to mute these review requests?"))).modalBox({title:gettext("Mute review requests"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input type="button"/>').val(gettext("Mute Review Requests")).click(_.bind(this._updateVisibility,this,visibilityFunc))]});return false},_onUnmuteClicked:function(){var collection=RB.UserSession.instance.mutedReviewRequests;this._updateVisibility(_.bind(collection.removeImmediately,collection));return false},_updateVisibility:function(visibilityFunc){this.model.updateVisibility(visibilityFunc)}});RB.DashboardView=RB.DatagridPageView.extend({actionsViewType:DashboardActionsView})})()}).call(this);
