from typing import Dict

# source: https://github.com/hyperreality/American-British-English-Translator/blob/master/data/american_spellings.json
american_spellings: Dict[str, str] = {
    "accessorize": "accessorise",
    "accessorized": "accessorised",
    "accessorizes": "accessorises",
    "accessorizing": "accessorising",
    "acclimatization": "acclimatisation",
    "acclimatize": "acclimatise",
    "acclimatized": "acclimatised",
    "acclimatizes": "acclimatises",
    "acclimatizing": "acclimatising",
    "accouterments": "accoutrements",
    "eon": "aeon",
    "eons": "aeons",
    "aerogram": "aerogramme",
    "aerograms": "aerogrammes",
    "airplane": "aeroplane",
    "airplanes": "aeroplanes",
    "esthete": "aesthete",
    "esthetes": "aesthetes",
    "esthetic": "aesthetic",
    "esthetically": "aesthetically",
    "esthetics": "aesthetics",
    "etiology": "aetiology",
    "aging": "ageing",
    "aggrandizement": "aggrandisement",
    "agonize": "agonise",
    "agonized": "agonised",
    "agonizes": "agonises",
    "agonizing": "agonising",
    "agonizingly": "agonisingly",
    "almanac": "almanack",
    "almanacs": "almanacks",
    "aluminum": "aluminium",
    "amortizable": "amortisable",
    "amortization": "amortisation",
    "amortizations": "amortisations",
    "amortize": "amortise",
    "amortized": "amortised",
    "amortizes": "amortises",
    "amortizing": "amortising",
    "amphitheater": "amphitheatre",
    "amphitheaters": "amphitheatres",
    "anemia": "anaemia",
    "anemic": "anaemic",
    "anesthesia": "anaesthesia",
    "anesthetic": "anaesthetic",
    "anesthetics": "anaesthetics",
    "anesthetize": "anaesthetize",
    "anesthetized": "anaesthetized",
    "anesthetizes": "anaesthetizes",
    "anesthetizing": "anaesthetizing",
    "anesthetist": "anaesthetist",
    "anesthetists": "anaesthetists",
    "analog": "analogue",
    "analogs": "analogues",
    "analyze": "analyse",
    "analyzed": "analysed",
    "analyzes": "analyses",
    "analyzing": "analysing",
    "anglicize": "anglicise",
    "anglicized": "anglicised",
    "anglicizes": "anglicises",
    "anglicizing": "anglicising",
    "annualized": "annualised",
    "antagonize": "antagonise",
    "antagonized": "antagonised",
    "antagonizes": "antagonises",
    "antagonizing": "antagonising",
    "apologize": "apologise",
    "apologized": "apologised",
    "apologizes": "apologises",
    "apologizing": "apologising",
    "appall": "appal",
    "appalls": "appals",
    "appetizer": "appetiser",
    "appetizers": "appetisers",
    "appetizing": "appetising",
    "appetizingly": "appetisingly",
    "arbor": "arbour",
    "arbors": "arbours",
    "archeological": "archaeological",
    "archeologically": "archaeologically",
    "archeologist": "archaeologist",
    "archeologists": "archaeologists",
    "archeology": "archaeology",
    "ardor": "ardour",
    "armor": "armour",
    "armored": "armoured",
    "armorer": "armourer",
    "armorers": "armourers",
    "armories": "armouries",
    "armory": "armoury",
    "artifact": "artefact",
    "artifacts": "artefacts",
    "authorize": "authorise",
    "authorized": "authorised",
    "authorizes": "authorises",
    "authorizing": "authorising",
    "ax": "axe",
    "backpedaled": "backpedalled",
    "backpedaling": "backpedalling",
    "banister": "bannister",
    "banisters": "bannisters",
    "baptize": "baptise",
    "baptized": "baptised",
    "baptizes": "baptises",
    "baptizing": "baptising",
    "bastardize": "bastardise",
    "bastardized": "bastardised",
    "bastardizes": "bastardises",
    "bastardizing": "bastardising",
    "battleax": "battleaxe",
    "balk": "baulk",
    "balked": "baulked",
    "balking": "baulking",
    "balks": "baulks",
    "bedeviled": "bedevilled",
    "bedeviling": "bedevilling",
    "behavior": "behaviour",
    "behavioral": "behavioural",
    "behaviorism": "behaviourism",
    "behaviorist": "behaviourist",
    "behaviorists": "behaviourists",
    "behaviors": "behaviours",
    "behoove": "behove",
    "behooved": "behoved",
    "behooves": "behoves",
    "bejeweled": "bejewelled",
    "belabor": "belabour",
    "belabored": "belaboured",
    "belaboring": "belabouring",
    "belabors": "belabours",
    "beveled": "bevelled",
    "bevies": "bevvies",
    "bevy": "bevvy",
    "biased": "biassed",
    "biasing": "biassing",
    "binging": "bingeing",
    "bougainvillea": "bougainvillaea",
    "bougainvilleas": "bougainvillaeas",
    "bowdlerize": "bowdlerise",
    "bowdlerized": "bowdlerised",
    "bowdlerizes": "bowdlerises",
    "bowdlerizing": "bowdlerising",
    "breathalyze": "breathalyse",
    "breathalyzed": "breathalysed",
    "breathalyzer": "breathalyser",
    "breathalyzers": "breathalysers",
    "breathalyzes": "breathalyses",
    "breathalyzing": "breathalysing",
    "brutalize": "brutalise",
    "brutalized": "brutalised",
    "brutalizes": "brutalises",
    "brutalizing": "brutalising",
    "busses": "buses",
    "bussing": "busing",
    "cesarean": "caesarean",
    "cesareans": "caesareans",
    "caliber": "calibre",
    "calibers": "calibres",
    "caliper": "calliper",
    "calipers": "callipers",
    "calisthenics": "callisthenics",
    "canalize": "canalise",
    "canalized": "canalised",
    "canalizes": "canalises",
    "canalizing": "canalising",
    "cancelation": "cancellation",
    "cancelations": "cancellations",
    "canceled": "cancelled",
    "canceling": "cancelling",
    "candor": "candour",
    "cannibalize": "cannibalise",
    "cannibalized": "cannibalised",
    "cannibalizes": "cannibalises",
    "cannibalizing": "cannibalising",
    "canonize": "canonise",
    "canonized": "canonised",
    "canonizes": "canonises",
    "canonizing": "canonising",
    "capitalize": "capitalise",
    "capitalized": "capitalised",
    "capitalizes": "capitalises",
    "capitalizing": "capitalising",
    "caramelize": "caramelise",
    "caramelized": "caramelised",
    "caramelizes": "caramelises",
    "caramelizing": "caramelising",
    "carbonize": "carbonise",
    "carbonized": "carbonised",
    "carbonizes": "carbonises",
    "carbonizing": "carbonising",
    "caroled": "carolled",
    "caroling": "carolling",
    "catalog": "catalogue",
    "cataloged": "catalogued",
    "catalogs": "catalogues",
    "cataloging": "cataloguing",
    "catalyze": "catalyse",
    "catalyzed": "catalysed",
    "catalyzes": "catalyses",
    "catalyzing": "catalysing",
    "categorize": "categorise",
    "categorized": "categorised",
    "categorizes": "categorises",
    "categorizing": "categorising",
    "cauterize": "cauterise",
    "cauterized": "cauterised",
    "cauterizes": "cauterises",
    "cauterizing": "cauterising",
    "caviled": "cavilled",
    "caviling": "cavilling",
    "centigram": "centigramme",
    "centigrams": "centigrammes",
    "centiliter": "centilitre",
    "centiliters": "centilitres",
    "centimeter": "centimetre",
    "centimeters": "centimetres",
    "centralize": "centralise",
    "centralized": "centralised",
    "centralizes": "centralises",
    "centralizing": "centralising",
    "center": "centre",
    "centered": "centred",
    "centerfold": "centrefold",
    "centerfolds": "centrefolds",
    "centerpiece": "centrepiece",
    "centerpieces": "centrepieces",
    "centers": "centres",
    "channeled": "channelled",
    "channeling": "channelling",
    "characterize": "characterise",
    "characterized": "characterised",
    "characterizes": "characterises",
    "characterizing": "characterising",
    "checkbook": "chequebook",
    "checkbooks": "chequebooks",
    "checkered": "chequered",
    "chili": "chilli",
    "chimera": "chimaera",
    "chimeras": "chimaeras",
    "chiseled": "chiselled",
    "chiseling": "chiselling",
    "circularize": "circularise",
    "circularized": "circularised",
    "circularizes": "circularises",
    "circularizing": "circularising",
    "civilize": "civilise",
    "civilized": "civilised",
    "civilizes": "civilises",
    "civilizing": "civilising",
    "clamor": "clamour",
    "clamored": "clamoured",
    "clamoring": "clamouring",
    "clamors": "clamours",
    "clangor": "clangour",
    "clarinetist": "clarinettist",
    "clarinetists": "clarinettists",
    "collectivize": "collectivise",
    "collectivized": "collectivised",
    "collectivizes": "collectivises",
    "collectivizing": "collectivising",
    "colonization": "colonisation",
    "colonize": "colonise",
    "colonized": "colonised",
    "colonizer": "coloniser",
    "colonizers": "colonisers",
    "colonizes": "colonises",
    "colonizing": "colonising",
    "color": "colour",
    "colorant": "colourant",
    "colorants": "colourants",
    "colored": "coloured",
    "coloreds": "coloureds",
    "colorful": "colourful",
    "colorfully": "colourfully",
    "coloring": "colouring",
    "colorize": "colourize",
    "colorized": "colourized",
    "colorizes": "colourizes",
    "colorizing": "colourizing",
    "colorless": "colourless",
    "colors": "colours",
    "commercialize": "commercialise",
    "commercialized": "commercialised",
    "commercializes": "commercialises",
    "commercializing": "commercialising",
    "compartmentalize": "compartmentalise",
    "compartmentalized": "compartmentalised",
    "compartmentalizes": "compartmentalises",
    "compartmentalizing": "compartmentalising",
    "computerize": "computerise",
    "computerized": "computerised",
    "computerizes": "computerises",
    "computerizing": "computerising",
    "conceptualize": "conceptualise",
    "conceptualized": "conceptualised",
    "conceptualizes": "conceptualises",
    "conceptualizing": "conceptualising",
    "connection": "connexion",
    "connections": "connexions",
    "contextualize": "contextualise",
    "contextualized": "contextualised",
    "contextualizes": "contextualises",
    "contextualizing": "contextualising",
    "cozier": "cosier",
    "cozies": "cosies",
    "coziest": "cosiest",
    "cozily": "cosily",
    "coziness": "cosiness",
    "cozy": "cosy",
    "councilor": "councillor",
    "councilors": "councillors",
    "counseled": "counselled",
    "counseling": "counselling",
    "counselor": "counsellor",
    "counselors": "counsellors",
    "crenelated": "crenellated",
    "criminalize": "criminalise",
    "criminalized": "criminalised",
    "criminalizes": "criminalises",
    "criminalizing": "criminalising",
    "criticize": "criticise",
    "criticized": "criticised",
    "criticizes": "criticises",
    "criticizing": "criticising",
    "crueler": "crueller",
    "cruelest": "cruellest",
    "crystallization": "crystallisation",
    "crystallize": "crystallise",
    "crystallized": "crystallised",
    "crystallizes": "crystallises",
    "crystallizing": "crystallising",
    "cudgeled": "cudgelled",
    "cudgeling": "cudgelling",
    "customize": "customise",
    "customized": "customised",
    "customizes": "customises",
    "customizing": "customising",
    "decentralization": "decentralisation",
    "decentralize": "decentralise",
    "decentralized": "decentralised",
    "decentralizes": "decentralises",
    "decentralizing": "decentralising",
    "decriminalization": "decriminalisation",
    "decriminalize": "decriminalise",
    "decriminalized": "decriminalised",
    "decriminalizes": "decriminalises",
    "decriminalizing": "decriminalising",
    "defense": "defence",
    "defenseless": "defenceless",
    "defenses": "defences",
    "dehumanization": "dehumanisation",
    "dehumanize": "dehumanise",
    "dehumanized": "dehumanised",
    "dehumanizes": "dehumanises",
    "dehumanizing": "dehumanising",
    "demeanor": "demeanour",
    "demilitarization": "demilitarisation",
    "demilitarize": "demilitarise",
    "demilitarized": "demilitarised",
    "demilitarizes": "demilitarises",
    "demilitarizing": "demilitarising",
    "demobilization": "demobilisation",
    "demobilize": "demobilise",
    "demobilized": "demobilised",
    "demobilizes": "demobilises",
    "demobilizing": "demobilising",
    "democratization": "democratisation",
    "democratize": "democratise",
    "democratized": "democratised",
    "democratizes": "democratises",
    "democratizing": "democratising",
    "demonize": "demonise",
    "demonized": "demonised",
    "demonizes": "demonises",
    "demonizing": "demonising",
    "demoralization": "demoralisation",
    "demoralize": "demoralise",
    "demoralized": "demoralised",
    "demoralizes": "demoralises",
    "demoralizing": "demoralising",
    "denationalization": "denationalisation",
    "denationalize": "denationalise",
    "denationalized": "denationalised",
    "denationalizes": "denationalises",
    "denationalizing": "denationalising",
    "deodorize": "deodorise",
    "deodorized": "deodorised",
    "deodorizes": "deodorises",
    "deodorizing": "deodorising",
    "depersonalize": "depersonalise",
    "depersonalized": "depersonalised",
    "depersonalizes": "depersonalises",
    "depersonalizing": "depersonalising",
    "deputize": "deputise",
    "deputized": "deputised",
    "deputizes": "deputises",
    "deputizing": "deputising",
    "desensitization": "desensitisation",
    "desensitize": "desensitise",
    "desensitized": "desensitised",
    "desensitizes": "desensitises",
    "desensitizing": "desensitising",
    "destabilization": "destabilisation",
    "destabilize": "destabilise",
    "destabilized": "destabilised",
    "destabilizes": "destabilises",
    "destabilizing": "destabilising",
    "dialed": "dialled",
    "dialing": "dialling",
    "dialog": "dialogue",
    "dialogs": "dialogues",
    "diarrhea": "diarrhoea",
    "digitize": "digitise",
    "digitized": "digitised",
    "digitizes": "digitises",
    "digitizing": "digitising",
    "disk": "disc",
    "discolor": "discolour",
    "discolored": "discoloured",
    "discoloring": "discolouring",
    "discolors": "discolours",
    "disks": "discs",
    "disemboweled": "disembowelled",
    "disemboweling": "disembowelling",
    "disfavor": "disfavour",
    "disheveled": "dishevelled",
    "dishonor": "dishonour",
    "dishonorable": "dishonourable",
    "dishonorably": "dishonourably",
    "dishonored": "dishonoured",
    "dishonoring": "dishonouring",
    "dishonors": "dishonours",
    "disorganization": "disorganisation",
    "disorganized": "disorganised",
    "distill": "distil",
    "distills": "distils",
    "dramatization": "dramatisation",
    "dramatizations": "dramatisations",
    "dramatize": "dramatise",
    "dramatized": "dramatised",
    "dramatizes": "dramatises",
    "dramatizing": "dramatising",
    "draft": "draught",
    "draftboard": "draughtboard",
    "draftboards": "draughtboards",
    "draftier": "draughtier",
    "draftiest": "draughtiest",
    "drafts": "draughts",
    "draftsman": "draughtsman",
    "draftsmanship": "draughtsmanship",
    "draftsmen": "draughtsmen",
    "draftswoman": "draughtswoman",
    "draftswomen": "draughtswomen",
    "drafty": "draughty",
    "driveled": "drivelled",
    "driveling": "drivelling",
    "dueled": "duelled",
    "dueling": "duelling",
    "economize": "economise",
    "economized": "economised",
    "economizes": "economises",
    "economizing": "economising",
    "edema": "edoema",
    "editorialize": "editorialise",
    "editorialized": "editorialised",
    "editorializes": "editorialises",
    "editorializing": "editorialising",
    "empathize": "empathise",
    "empathized": "empathised",
    "empathizes": "empathises",
    "empathizing": "empathising",
    "emphasize": "emphasise",
    "emphasized": "emphasised",
    "emphasizes": "emphasises",
    "emphasizing": "emphasising",
    "enameled": "enamelled",
    "enameling": "enamelling",
    "enamored": "enamoured",
    "encyclopedia": "encyclopaedia",
    "encyclopedias": "encyclopaedias",
    "encyclopedic": "encyclopaedic",
    "endeavor": "endeavour",
    "endeavored": "endeavoured",
    "endeavoring": "endeavouring",
    "endeavors": "endeavours",
    "energize": "energise",
    "energized": "energised",
    "energizes": "energises",
    "energizing": "energising",
    "enroll": "enrol",
    "enrolls": "enrols",
    "enthrall": "enthral",
    "enthralls": "enthrals",
    "epaulet": "epaulette",
    "epaulets": "epaulettes",
    "epicenter": "epicentre",
    "epicenters": "epicentres",
    "epilog": "epilogue",
    "epilogs": "epilogues",
    "epitomize": "epitomise",
    "epitomized": "epitomised",
    "epitomizes": "epitomises",
    "epitomizing": "epitomising",
    "equalization": "equalisation",
    "equalize": "equalise",
    "equalized": "equalised",
    "equalizer": "equaliser",
    "equalizers": "equalisers",
    "equalizes": "equalises",
    "equalizing": "equalising",
    "eulogize": "eulogise",
    "eulogized": "eulogised",
    "eulogizes": "eulogises",
    "eulogizing": "eulogising",
    "evangelize": "evangelise",
    "evangelized": "evangelised",
    "evangelizes": "evangelises",
    "evangelizing": "evangelising",
    "exorcize": "exorcise",
    "exorcized": "exorcised",
    "exorcizes": "exorcises",
    "exorcizing": "exorcising",
    "extemporization": "extemporisation",
    "extemporize": "extemporise",
    "extemporized": "extemporised",
    "extemporizes": "extemporises",
    "extemporizing": "extemporising",
    "externalization": "externalisation",
    "externalizations": "externalisations",
    "externalize": "externalise",
    "externalized": "externalised",
    "externalizes": "externalises",
    "externalizing": "externalising",
    "factorize": "factorise",
    "factorized": "factorised",
    "factorizes": "factorises",
    "factorizing": "factorising",
    "fecal": "faecal",
    "feces": "faeces",
    "familiarization": "familiarisation",
    "familiarize": "familiarise",
    "familiarized": "familiarised",
    "familiarizes": "familiarises",
    "familiarizing": "familiarising",
    "fantasize": "fantasise",
    "fantasized": "fantasised",
    "fantasizes": "fantasises",
    "fantasizing": "fantasising",
    "favor": "favour",
    "favorable": "favourable",
    "favorably": "favourably",
    "favored": "favoured",
    "favoring": "favouring",
    "favorite": "favourite",
    "favorites": "favourites",
    "favoritism": "favouritism",
    "favors": "favours",
    "feminize": "feminise",
    "feminized": "feminised",
    "feminizes": "feminises",
    "feminizing": "feminising",
    "fertilization": "fertilisation",
    "fertilize": "fertilise",
    "fertilized": "fertilised",
    "fertilizer": "fertiliser",
    "fertilizers": "fertilisers",
    "fertilizes": "fertilises",
    "fertilizing": "fertilising",
    "fervor": "fervour",
    "fiber": "fibre",
    "fiberglass": "fibreglass",
    "fibers": "fibres",
    "fictionalization": "fictionalisation",
    "fictionalizations": "fictionalisations",
    "fictionalize": "fictionalise",
    "fictionalized": "fictionalised",
    "fictionalizes": "fictionalises",
    "fictionalizing": "fictionalising",
    "filet": "fillet",
    "fileted": "filleted",
    "fileting": "filleting",
    "filets": "fillets",
    "finalization": "finalisation",
    "finalize": "finalise",
    "finalized": "finalised",
    "finalizes": "finalises",
    "finalizing": "finalising",
    "flutist": "flautist",
    "flutists": "flautists",
    "flavor": "flavour",
    "flavored": "flavoured",
    "flavoring": "flavouring",
    "flavorings": "flavourings",
    "flavorless": "flavourless",
    "flavors": "flavours",
    "flavorsome": "flavoursome",
    "fetal": "foetal",
    "fetid": "foetid",
    "fetus": "foetus",
    "fetuses": "foetuses",
    "formalization": "formalisation",
    "formalize": "formalise",
    "formalized": "formalised",
    "formalizes": "formalises",
    "formalizing": "formalising",
    "fossilization": "fossilisation",
    "fossilize": "fossilise",
    "fossilized": "fossilised",
    "fossilizes": "fossilises",
    "fossilizing": "fossilising",
    "fraternization": "fraternisation",
    "fraternize": "fraternise",
    "fraternized": "fraternised",
    "fraternizes": "fraternises",
    "fraternizing": "fraternising",
    "fulfill": "fulfil",
    "fulfillment": "fulfilment",
    "fulfills": "fulfils",
    "funneled": "funnelled",
    "funneling": "funnelling",
    "galvanize": "galvanise",
    "galvanized": "galvanised",
    "galvanizes": "galvanises",
    "galvanizing": "galvanising",
    "gamboled": "gambolled",
    "gamboling": "gambolling",
    "gasses": "gases",
    "gage": "gauge",
    "gaged": "gauged",
    "gages": "gauges",
    "gaging": "gauging",
    "generalization": "generalisation",
    "generalizations": "generalisations",
    "generalize": "generalise",
    "generalized": "generalised",
    "generalizes": "generalises",
    "generalizing": "generalising",
    "ghettoize": "ghettoise",
    "ghettoized": "ghettoised",
    "ghettoizes": "ghettoises",
    "ghettoizing": "ghettoising",
    "gypsies": "gipsies",
    "glamorize": "glamorise",
    "glamorized": "glamorised",
    "glamorizes": "glamorises",
    "glamorizing": "glamorising",
    "glamor": "glamour",
    "globalization": "globalisation",
    "globalize": "globalise",
    "globalized": "globalised",
    "globalizes": "globalises",
    "globalizing": "globalising",
    "gluing": "glueing",
    "goiter": "goitre",
    "goiters": "goitres",
    "gonorrhea": "gonorrhoea",
    "gram": "gramme",
    "grams": "grammes",
    "graveled": "gravelled",
    "gray": "grey",
    "grayed": "greyed",
    "graying": "greying",
    "grayish": "greyish",
    "grayness": "greyness",
    "grays": "greys",
    "groveled": "grovelled",
    "groveling": "grovelling",
    "groin": "groyne",
    "groins": "groynes",
    "grueling": "gruelling",
    "gruelingly": "gruellingly",
    "griffin": "gryphon",
    "griffins": "gryphons",
    "gynecological": "gynaecological",
    "gynecologist": "gynaecologist",
    "gynecologists": "gynaecologists",
    "gynecology": "gynaecology",
    "hematological": "haematological",
    "hematologist": "haematologist",
    "hematologists": "haematologists",
    "hematology": "haematology",
    "hemoglobin": "haemoglobin",
    "hemophilia": "haemophilia",
    "hemophiliac": "haemophiliac",
    "hemophiliacs": "haemophiliacs",
    "hemorrhage": "haemorrhage",
    "hemorrhaged": "haemorrhaged",
    "hemorrhages": "haemorrhages",
    "hemorrhaging": "haemorrhaging",
    "hemorrhoids": "haemorrhoids",
    "harbor": "harbour",
    "harbored": "harboured",
    "harboring": "harbouring",
    "harbors": "harbours",
    "harmonization": "harmonisation",
    "harmonize": "harmonise",
    "harmonized": "harmonised",
    "harmonizes": "harmonises",
    "harmonizing": "harmonising",
    "homeopath": "homoeopath",
    "homeopathic": "homoeopathic",
    "homeopaths": "homoeopaths",
    "homeopathy": "homoeopathy",
    "homogenize": "homogenise",
    "homogenized": "homogenised",
    "homogenizes": "homogenises",
    "homogenizing": "homogenising",
    "honor": "honour",
    "honorable": "honourable",
    "honorably": "honourably",
    "honored": "honoured",
    "honoring": "honouring",
    "honors": "honours",
    "hospitalization": "hospitalisation",
    "hospitalize": "hospitalise",
    "hospitalized": "hospitalised",
    "hospitalizes": "hospitalises",
    "hospitalizing": "hospitalising",
    "humanize": "humanise",
    "humanized": "humanised",
    "humanizes": "humanises",
    "humanizing": "humanising",
    "humor": "humour",
    "humored": "humoured",
    "humoring": "humouring",
    "humorless": "humourless",
    "humors": "humours",
    "hybridize": "hybridise",
    "hybridized": "hybridised",
    "hybridizes": "hybridises",
    "hybridizing": "hybridising",
    "hypnotize": "hypnotise",
    "hypnotized": "hypnotised",
    "hypnotizes": "hypnotises",
    "hypnotizing": "hypnotising",
    "hypothesize": "hypothesise",
    "hypothesized": "hypothesised",
    "hypothesizes": "hypothesises",
    "hypothesizing": "hypothesising",
    "idealization": "idealisation",
    "idealize": "idealise",
    "idealized": "idealised",
    "idealizes": "idealises",
    "idealizing": "idealising",
    "idolize": "idolise",
    "idolized": "idolised",
    "idolizes": "idolises",
    "idolizing": "idolising",
    "immobilization": "immobilisation",
    "immobilize": "immobilise",
    "immobilized": "immobilised",
    "immobilizer": "immobiliser",
    "immobilizers": "immobilisers",
    "immobilizes": "immobilises",
    "immobilizing": "immobilising",
    "immortalize": "immortalise",
    "immortalized": "immortalised",
    "immortalizes": "immortalises",
    "immortalizing": "immortalising",
    "immunization": "immunisation",
    "immunize": "immunise",
    "immunized": "immunised",
    "immunizes": "immunises",
    "immunizing": "immunising",
    "impaneled": "impanelled",
    "impaneling": "impanelling",
    "imperiled": "imperilled",
    "imperiling": "imperilling",
    "individualize": "individualise",
    "individualized": "individualised",
    "individualizes": "individualises",
    "individualizing": "individualising",
    "industrialize": "industrialise",
    "industrialized": "industrialised",
    "industrializes": "industrialises",
    "industrializing": "industrialising",
    "inflection": "inflexion",
    "inflections": "inflexions",
    "initialize": "initialise",
    "initialized": "initialised",
    "initializes": "initialises",
    "initializing": "initialising",
    "initialed": "initialled",
    "initialing": "initialling",
    "install": "instal",
    "installment": "instalment",
    "installments": "instalments",
    "installs": "instals",
    "instill": "instil",
    "instills": "instils",
    "institutionalization": "institutionalisation",
    "institutionalize": "institutionalise",
    "institutionalized": "institutionalised",
    "institutionalizes": "institutionalises",
    "institutionalizing": "institutionalising",
    "intellectualize": "intellectualise",
    "intellectualized": "intellectualised",
    "intellectualizes": "intellectualises",
    "intellectualizing": "intellectualising",
    "internalization": "internalisation",
    "internalize": "internalise",
    "internalized": "internalised",
    "internalizes": "internalises",
    "internalizing": "internalising",
    "internationalization": "internationalisation",
    "internationalize": "internationalise",
    "internationalized": "internationalised",
    "internationalizes": "internationalises",
    "internationalizing": "internationalising",
    "ionization": "ionisation",
    "ionize": "ionise",
    "ionized": "ionised",
    "ionizer": "ioniser",
    "ionizers": "ionisers",
    "ionizes": "ionises",
    "ionizing": "ionising",
    "italicize": "italicise",
    "italicized": "italicised",
    "italicizes": "italicises",
    "italicizing": "italicising",
    "itemize": "itemise",
    "itemized": "itemised",
    "itemizes": "itemises",
    "itemizing": "itemising",
    "jeopardize": "jeopardise",
    "jeopardized": "jeopardised",
    "jeopardizes": "jeopardises",
    "jeopardizing": "jeopardising",
    "jeweled": "jewelled",
    "jeweler": "jeweller",
    "jewelers": "jewellers",
    "jewelry": "jewellery",
    "judgment": "judgement",
    "kilogram": "kilogramme",
    "kilograms": "kilogrammes",
    "kilometer": "kilometre",
    "kilometers": "kilometres",
    "labeled": "labelled",
    "labeling": "labelling",
    "labor": "labour",
    "labored": "laboured",
    "laborer": "labourer",
    "laborers": "labourers",
    "laboring": "labouring",
    "labors": "labours",
    "lackluster": "lacklustre",
    "legalization": "legalisation",
    "legalize": "legalise",
    "legalized": "legalised",
    "legalizes": "legalises",
    "legalizing": "legalising",
    "legitimize": "legitimise",
    "legitimized": "legitimised",
    "legitimizes": "legitimises",
    "legitimizing": "legitimising",
    "leukemia": "leukaemia",
    "leveled": "levelled",
    "leveler": "leveller",
    "levelers": "levellers",
    "leveling": "levelling",
    "libeled": "libelled",
    "libeling": "libelling",
    "libelous": "libellous",
    "liberalization": "liberalisation",
    "liberalize": "liberalise",
    "liberalized": "liberalised",
    "liberalizes": "liberalises",
    "liberalizing": "liberalising",
    "license": "licence",
    "licensed": "licenced",
    "licenses": "licences",
    "licensing": "licencing",
    "likable": "likeable",
    "lionization": "lionisation",
    "lionize": "lionise",
    "lionized": "lionised",
    "lionizes": "lionises",
    "lionizing": "lionising",
    "liquidize": "liquidise",
    "liquidized": "liquidised",
    "liquidizer": "liquidiser",
    "liquidizers": "liquidisers",
    "liquidizes": "liquidises",
    "liquidizing": "liquidising",
    "liter": "litre",
    "liters": "litres",
    "localize": "localise",
    "localized": "localised",
    "localizes": "localises",
    "localizing": "localising",
    "louver": "louvre",
    "louvered": "louvred",
    "louvers": "louvres",
    "luster": "lustre",
    "magnetize": "magnetise",
    "magnetized": "magnetised",
    "magnetizes": "magnetises",
    "magnetizing": "magnetising",
    "maneuverability": "manoeuvrability",
    "maneuverable": "manoeuvrable",
    "maneuver": "manoeuvre",
    "maneuvered": "manoeuvred",
    "maneuvers": "manoeuvres",
    "maneuvering": "manoeuvring",
    "maneuverings": "manoeuvrings",
    "marginalization": "marginalisation",
    "marginalize": "marginalise",
    "marginalized": "marginalised",
    "marginalizes": "marginalises",
    "marginalizing": "marginalising",
    "marshaled": "marshalled",
    "marshaling": "marshalling",
    "marveled": "marvelled",
    "marveling": "marvelling",
    "marvelous": "marvellous",
    "marvelously": "marvellously",
    "materialization": "materialisation",
    "materialize": "materialise",
    "materialized": "materialised",
    "materializes": "materialises",
    "materializing": "materialising",
    "maximization": "maximisation",
    "maximize": "maximise",
    "maximized": "maximised",
    "maximizes": "maximises",
    "maximizing": "maximising",
    "meager": "meagre",
    "mechanization": "mechanisation",
    "mechanize": "mechanise",
    "mechanized": "mechanised",
    "mechanizes": "mechanises",
    "mechanizing": "mechanising",
    "medieval": "mediaeval",
    "memorialize": "memorialise",
    "memorialized": "memorialised",
    "memorializes": "memorialises",
    "memorializing": "memorialising",
    "memorize": "memorise",
    "memorized": "memorised",
    "memorizes": "memorises",
    "memorizing": "memorising",
    "mesmerize": "mesmerise",
    "mesmerized": "mesmerised",
    "mesmerizes": "mesmerises",
    "mesmerizing": "mesmerising",
    "metabolize": "metabolise",
    "metabolized": "metabolised",
    "metabolizes": "metabolises",
    "metabolizing": "metabolising",
    "meter": "metre",
    "meters": "metres",
    "micrometer": "micrometre",
    "micrometers": "micrometres",
    "militarize": "militarise",
    "militarized": "militarised",
    "militarizes": "militarises",
    "militarizing": "militarising",
    "milligram": "milligramme",
    "milligrams": "milligrammes",
    "milliliter": "millilitre",
    "milliliters": "millilitres",
    "millimeter": "millimetre",
    "millimeters": "millimetres",
    "miniaturization": "miniaturisation",
    "miniaturize": "miniaturise",
    "miniaturized": "miniaturised",
    "miniaturizes": "miniaturises",
    "miniaturizing": "miniaturising",
    "minibusses": "minibuses",
    "minimize": "minimise",
    "minimized": "minimised",
    "minimizes": "minimises",
    "minimizing": "minimising",
    "misbehavior": "misbehaviour",
    "misdemeanor": "misdemeanour",
    "misdemeanors": "misdemeanours",
    "misspelled": "misspelt",
    "miter": "mitre",
    "miters": "mitres",
    "mobilization": "mobilisation",
    "mobilize": "mobilise",
    "mobilized": "mobilised",
    "mobilizes": "mobilises",
    "mobilizing": "mobilising",
    "modeled": "modelled",
    "modeler": "modeller",
    "modelers": "modellers",
    "modeling": "modelling",
    "modernize": "modernise",
    "modernized": "modernised",
    "modernizes": "modernises",
    "modernizing": "modernising",
    "moisturize": "moisturise",
    "moisturized": "moisturised",
    "moisturizer": "moisturiser",
    "moisturizers": "moisturisers",
    "moisturizes": "moisturises",
    "moisturizing": "moisturising",
    "monolog": "monologue",
    "monologs": "monologues",
    "monopolization": "monopolisation",
    "monopolize": "monopolise",
    "monopolized": "monopolised",
    "monopolizes": "monopolises",
    "monopolizing": "monopolising",
    "moralize": "moralise",
    "moralized": "moralised",
    "moralizes": "moralises",
    "moralizing": "moralising",
    "motorized": "motorised",
    "mold": "mould",
    "molded": "moulded",
    "molder": "moulder",
    "moldered": "mouldered",
    "moldering": "mouldering",
    "molders": "moulders",
    "moldier": "mouldier",
    "moldiest": "mouldiest",
    "molding": "moulding",
    "moldings": "mouldings",
    "molds": "moulds",
    "moldy": "mouldy",
    "molt": "moult",
    "molted": "moulted",
    "molting": "moulting",
    "molts": "moults",
    "mustache": "moustache",
    "mustached": "moustached",
    "mustaches": "moustaches",
    "mustachioed": "moustachioed",
    "multicolored": "multicoloured",
    "nationalization": "nationalisation",
    "nationalizations": "nationalisations",
    "nationalize": "nationalise",
    "nationalized": "nationalised",
    "nationalizes": "nationalises",
    "nationalizing": "nationalising",
    "naturalization": "naturalisation",
    "naturalize": "naturalise",
    "naturalized": "naturalised",
    "naturalizes": "naturalises",
    "naturalizing": "naturalising",
    "neighbor": "neighbour",
    "neighborhood": "neighbourhood",
    "neighborhoods": "neighbourhoods",
    "neighboring": "neighbouring",
    "neighborliness": "neighbourliness",
    "neighborly": "neighbourly",
    "neighbors": "neighbours",
    "neutralization": "neutralisation",
    "neutralize": "neutralise",
    "neutralized": "neutralised",
    "neutralizes": "neutralises",
    "neutralizing": "neutralising",
    "normalization": "normalisation",
    "normalize": "normalise",
    "normalized": "normalised",
    "normalizes": "normalises",
    "normalizing": "normalising",
    "odor": "odour",
    "odorless": "odourless",
    "odors": "odours",
    "esophagus": "oesophagus",
    "esophaguses": "oesophaguses",
    "estrogen": "oestrogen",
    "offense": "offence",
    "offenses": "offences",
    "omelet": "omelette",
    "omelets": "omelettes",
    "optimization": "optimisation",
    "optimizations": "optimisations",
    "optimize": "optimise",
    "optimized": "optimised",
    "optimizes": "optimises",
    "optimizing": "optimising",
    "organization": "organisation",
    "organizational": "organisational",
    "organizations": "organisations",
    "organize": "organise",
    "organized": "organised",
    "organizer": "organiser",
    "organizers": "organisers",
    "organizes": "organises",
    "organizing": "organising",
    "orthopedic": "orthopaedic",
    "orthopedics": "orthopaedics",
    "ostracize": "ostracise",
    "ostracized": "ostracised",
    "ostracizes": "ostracises",
    "ostracizing": "ostracising",
    "outmaneuver": "outmanoeuvre",
    "outmaneuvered": "outmanoeuvred",
    "outmaneuvers": "outmanoeuvres",
    "outmaneuvering": "outmanoeuvring",
    "overemphasize": "overemphasise",
    "overemphasized": "overemphasised",
    "overemphasizes": "overemphasises",
    "overemphasizing": "overemphasising",
    "oxidization": "oxidisation",
    "oxidize": "oxidise",
    "oxidized": "oxidised",
    "oxidizes": "oxidises",
    "oxidizing": "oxidising",
    "pederast": "paederast",
    "pederasts": "paederasts",
    "pediatric": "paediatric",
    "pediatrician": "paediatrician",
    "pediatricians": "paediatricians",
    "pediatrics": "paediatrics",
    "pedophile": "paedophile",
    "pedophiles": "paedophiles",
    "pedophilia": "paedophilia",
    "paleolithic": "palaeolithic",
    "paleontologist": "palaeontologist",
    "paleontologists": "palaeontologists",
    "paleontology": "palaeontology",
    "paneled": "panelled",
    "paneling": "panelling",
    "panelist": "panellist",
    "panelists": "panellists",
    "paralyze": "paralyse",
    "paralyzed": "paralysed",
    "paralyzes": "paralyses",
    "paralyzing": "paralysing",
    "parceled": "parcelled",
    "parceling": "parcelling",
    "parlor": "parlour",
    "parlors": "parlours",
    "particularize": "particularise",
    "particularized": "particularised",
    "particularizes": "particularises",
    "particularizing": "particularising",
    "passivization": "passivisation",
    "passivize": "passivise",
    "passivized": "passivised",
    "passivizes": "passivises",
    "passivizing": "passivising",
    "pasteurization": "pasteurisation",
    "pasteurize": "pasteurise",
    "pasteurized": "pasteurised",
    "pasteurizes": "pasteurises",
    "pasteurizing": "pasteurising",
    "patronize": "patronise",
    "patronized": "patronised",
    "patronizes": "patronises",
    "patronizing": "patronising",
    "patronizingly": "patronisingly",
    "pedaled": "pedalled",
    "pedaling": "pedalling",
    "pedestrianization": "pedestrianisation",
    "pedestrianize": "pedestrianise",
    "pedestrianized": "pedestrianised",
    "pedestrianizes": "pedestrianises",
    "pedestrianizing": "pedestrianising",
    "penalize": "penalise",
    "penalized": "penalised",
    "penalizes": "penalises",
    "penalizing": "penalising",
    "penciled": "pencilled",
    "penciling": "pencilling",
    "personalize": "personalise",
    "personalized": "personalised",
    "personalizes": "personalises",
    "personalizing": "personalising",
    "pharmacopeia": "pharmacopoeia",
    "pharmacopeias": "pharmacopoeias",
    "philosophize": "philosophise",
    "philosophized": "philosophised",
    "philosophizes": "philosophises",
    "philosophizing": "philosophising",
    "filter": "philtre",
    "filters": "philtres",
    "phony": "phoney",
    "plagiarize": "plagiarise",
    "plagiarized": "plagiarised",
    "plagiarizes": "plagiarises",
    "plagiarizing": "plagiarising",
    "plow": "plough",
    "plowed": "ploughed",
    "plowing": "ploughing",
    "plowman": "ploughman",
    "plowmen": "ploughmen",
    "plows": "ploughs",
    "plowshare": "ploughshare",
    "plowshares": "ploughshares",
    "polarization": "polarisation",
    "polarize": "polarise",
    "polarized": "polarised",
    "polarizes": "polarises",
    "polarizing": "polarising",
    "politicization": "politicisation",
    "politicize": "politicise",
    "politicized": "politicised",
    "politicizes": "politicises",
    "politicizing": "politicising",
    "popularization": "popularisation",
    "popularize": "popularise",
    "popularized": "popularised",
    "popularizes": "popularises",
    "popularizing": "popularising",
    "pouf": "pouffe",
    "poufs": "pouffes",
    "practice": "practise",
    "practiced": "practised",
    "practices": "practises",
    "practicing": "practising",
    "presidium": "praesidium",
    "presidiums": "praesidiums",
    "pressurization": "pressurisation",
    "pressurize": "pressurise",
    "pressurized": "pressurised",
    "pressurizes": "pressurises",
    "pressurizing": "pressurising",
    "pretense": "pretence",
    "pretenses": "pretences",
    "primeval": "primaeval",
    "prioritization": "prioritisation",
    "prioritize": "prioritise",
    "prioritized": "prioritised",
    "prioritizes": "prioritises",
    "prioritizing": "prioritising",
    "privatization": "privatisation",
    "privatizations": "privatisations",
    "privatize": "privatise",
    "privatized": "privatised",
    "privatizes": "privatises",
    "privatizing": "privatising",
    "professionalization": "professionalisation",
    "professionalize": "professionalise",
    "professionalized": "professionalised",
    "professionalizes": "professionalises",
    "professionalizing": "professionalising",
    "program": "programme",
    "programs": "programmes",
    "prolog": "prologue",
    "prologs": "prologues",
    "propagandize": "propagandise",
    "propagandized": "propagandised",
    "propagandizes": "propagandises",
    "propagandizing": "propagandising",
    "proselytize": "proselytise",
    "proselytized": "proselytised",
    "proselytizer": "proselytiser",
    "proselytizers": "proselytisers",
    "proselytizes": "proselytises",
    "proselytizing": "proselytising",
    "psychoanalyze": "psychoanalyse",
    "psychoanalyzed": "psychoanalysed",
    "psychoanalyzes": "psychoanalyses",
    "psychoanalyzing": "psychoanalysing",
    "publicize": "publicise",
    "publicized": "publicised",
    "publicizes": "publicises",
    "publicizing": "publicising",
    "pulverization": "pulverisation",
    "pulverize": "pulverise",
    "pulverized": "pulverised",
    "pulverizes": "pulverises",
    "pulverizing": "pulverising",
    "pummel": "pummelled",
    "pummeled": "pummelling",
    "pajama": "pyjama",
    "pajamas": "pyjamas",
    "pizzazz": "pzazz",
    "quarreled": "quarrelled",
    "quarreling": "quarrelling",
    "radicalize": "radicalise",
    "radicalized": "radicalised",
    "radicalizes": "radicalises",
    "radicalizing": "radicalising",
    "rancor": "rancour",
    "randomize": "randomise",
    "randomized": "randomised",
    "randomizes": "randomises",
    "randomizing": "randomising",
    "rationalization": "rationalisation",
    "rationalizations": "rationalisations",
    "rationalize": "rationalise",
    "rationalized": "rationalised",
    "rationalizes": "rationalises",
    "rationalizing": "rationalising",
    "raveled": "ravelled",
    "raveling": "ravelling",
    "realizable": "realisable",
    "realization": "realisation",
    "realizations": "realisations",
    "realize": "realise",
    "realized": "realised",
    "realizes": "realises",
    "realizing": "realising",
    "recognizable": "recognisable",
    "recognizably": "recognisably",
    "recognizance": "recognisance",
    "recognize": "recognise",
    "recognized": "recognised",
    "recognizes": "recognises",
    "recognizing": "recognising",
    "reconnoiter": "reconnoitre",
    "reconnoitered": "reconnoitred",
    "reconnoiters": "reconnoitres",
    "reconnoitering": "reconnoitring",
    "refueled": "refuelled",
    "refueling": "refuelling",
    "regularization": "regularisation",
    "regularize": "regularise",
    "regularized": "regularised",
    "regularizes": "regularises",
    "regularizing": "regularising",
    "remodeled": "remodelled",
    "remodeling": "remodelling",
    "remold": "remould",
    "remolded": "remoulded",
    "remolding": "remoulding",
    "remolds": "remoulds",
    "reorganization": "reorganisation",
    "reorganizations": "reorganisations",
    "reorganize": "reorganise",
    "reorganized": "reorganised",
    "reorganizes": "reorganises",
    "reorganizing": "reorganising",
    "reveled": "revelled",
    "reveler": "reveller",
    "revelers": "revellers",
    "reveling": "revelling",
    "revitalize": "revitalise",
    "revitalized": "revitalised",
    "revitalizes": "revitalises",
    "revitalizing": "revitalising",
    "revolutionize": "revolutionise",
    "revolutionized": "revolutionised",
    "revolutionizes": "revolutionises",
    "revolutionizing": "revolutionising",
    "rhapsodize": "rhapsodise",
    "rhapsodized": "rhapsodised",
    "rhapsodizes": "rhapsodises",
    "rhapsodizing": "rhapsodising",
    "rigor": "rigour",
    "rigors": "rigours",
    "ritualized": "ritualised",
    "rivaled": "rivalled",
    "rivaling": "rivalling",
    "romanticize": "romanticise",
    "romanticized": "romanticised",
    "romanticizes": "romanticises",
    "romanticizing": "romanticising",
    "rumor": "rumour",
    "rumored": "rumoured",
    "rumors": "rumours",
    "saber": "sabre",
    "sabers": "sabres",
    "saltpeter": "saltpetre",
    "sanitize": "sanitise",
    "sanitized": "sanitised",
    "sanitizes": "sanitises",
    "sanitizing": "sanitising",
    "satirize": "satirise",
    "satirized": "satirised",
    "satirizes": "satirises",
    "satirizing": "satirising",
    "savior": "saviour",
    "saviors": "saviours",
    "savor": "savour",
    "savored": "savoured",
    "savories": "savouries",
    "savoring": "savouring",
    "savors": "savours",
    "savory": "savoury",
    "scandalize": "scandalise",
    "scandalized": "scandalised",
    "scandalizes": "scandalises",
    "scandalizing": "scandalising",
    "skeptic": "sceptic",
    "skeptical": "sceptical",
    "skeptically": "sceptically",
    "skepticism": "scepticism",
    "skeptics": "sceptics",
    "scepter": "sceptre",
    "scepters": "sceptres",
    "scrutinize": "scrutinise",
    "scrutinized": "scrutinised",
    "scrutinizes": "scrutinises",
    "scrutinizing": "scrutinising",
    "secularization": "secularisation",
    "secularize": "secularise",
    "secularized": "secularised",
    "secularizes": "secularises",
    "secularizing": "secularising",
    "sensationalize": "sensationalise",
    "sensationalized": "sensationalised",
    "sensationalizes": "sensationalises",
    "sensationalizing": "sensationalising",
    "sensitize": "sensitise",
    "sensitized": "sensitised",
    "sensitizes": "sensitises",
    "sensitizing": "sensitising",
    "sentimentalize": "sentimentalise",
    "sentimentalized": "sentimentalised",
    "sentimentalizes": "sentimentalises",
    "sentimentalizing": "sentimentalising",
    "sepulcher": "sepulchre",
    "sepulchers": "sepulchres",
    "serialization": "serialisation",
    "serializations": "serialisations",
    "serialize": "serialise",
    "serialized": "serialised",
    "serializes": "serialises",
    "serializing": "serialising",
    "sermonize": "sermonise",
    "sermonized": "sermonised",
    "sermonizes": "sermonises",
    "sermonizing": "sermonising",
    "sheik": "sheikh",
    "shoveled": "shovelled",
    "shoveling": "shovelling",
    "shriveled": "shrivelled",
    "shriveling": "shrivelling",
    "signalize": "signalise",
    "signalized": "signalised",
    "signalizes": "signalises",
    "signalizing": "signalising",
    "signaled": "signalled",
    "signaling": "signalling",
    "smolder": "smoulder",
    "smoldered": "smouldered",
    "smoldering": "smouldering",
    "smolders": "smoulders",
    "sniveled": "snivelled",
    "sniveling": "snivelling",
    "snorkeled": "snorkelled",
    "snorkeling": "snorkelling",
    "snowplow": "snowploughs",
    "socialization": "socialisation",
    "socialize": "socialise",
    "socialized": "socialised",
    "socializes": "socialises",
    "socializing": "socialising",
    "sodomize": "sodomise",
    "sodomized": "sodomised",
    "sodomizes": "sodomises",
    "sodomizing": "sodomising",
    "solemnize": "solemnise",
    "solemnized": "solemnised",
    "solemnizes": "solemnises",
    "solemnizing": "solemnising",
    "somber": "sombre",
    "specialization": "specialisation",
    "specializations": "specialisations",
    "specialize": "specialise",
    "specialized": "specialised",
    "specializes": "specialises",
    "specializing": "specialising",
    "specter": "spectre",
    "specters": "spectres",
    "spiraled": "spiralled",
    "spiraling": "spiralling",
    "splendor": "splendour",
    "splendors": "splendours",
    "squirreled": "squirrelled",
    "squirreling": "squirrelling",
    "stabilization": "stabilisation",
    "stabilize": "stabilise",
    "stabilized": "stabilised",
    "stabilizer": "stabiliser",
    "stabilizers": "stabilisers",
    "stabilizes": "stabilises",
    "stabilizing": "stabilising",
    "standardization": "standardisation",
    "standardize": "standardise",
    "standardized": "standardised",
    "standardizes": "standardises",
    "standardizing": "standardising",
    "stenciled": "stencilled",
    "stenciling": "stencilling",
    "sterilization": "sterilisation",
    "sterilizations": "sterilisations",
    "sterilize": "sterilise",
    "sterilized": "sterilised",
    "sterilizer": "steriliser",
    "sterilizers": "sterilisers",
    "sterilizes": "sterilises",
    "sterilizing": "sterilising",
    "stigmatization": "stigmatisation",
    "stigmatize": "stigmatise",
    "stigmatized": "stigmatised",
    "stigmatizes": "stigmatises",
    "stigmatizing": "stigmatising",
    "subsidization": "subsidisation",
    "subsidize": "subsidise",
    "subsidized": "subsidised",
    "subsidizer": "subsidiser",
    "subsidizers": "subsidisers",
    "subsidizes": "subsidises",
    "subsidizing": "subsidising",
    "succor": "succour",
    "succored": "succoured",
    "succoring": "succouring",
    "succors": "succours",
    "sulfate": "sulphate",
    "sulfates": "sulphates",
    "sulfide": "sulphide",
    "sulfides": "sulphides",
    "sulfur": "sulphur",
    "sulfurous": "sulphurous",
    "summarize": "summarise",
    "summarized": "summarised",
    "summarizes": "summarises",
    "summarizing": "summarising",
    "swiveled": "swivelled",
    "swiveling": "swivelling",
    "symbolize": "symbolise",
    "symbolized": "symbolised",
    "symbolizes": "symbolises",
    "symbolizing": "symbolising",
    "sympathize": "sympathise",
    "sympathized": "sympathised",
    "sympathizer": "sympathiser",
    "sympathizers": "sympathisers",
    "sympathizes": "sympathises",
    "sympathizing": "sympathising",
    "synchronization": "synchronisation",
    "synchronize": "synchronise",
    "synchronized": "synchronised",
    "synchronizes": "synchronises",
    "synchronizing": "synchronising",
    "synthesize": "synthesise",
    "synthesized": "synthesised",
    "synthesizer": "synthesiser",
    "synthesizers": "synthesisers",
    "synthesizes": "synthesises",
    "synthesizing": "synthesising",
    "siphon": "syphon",
    "siphoned": "syphoned",
    "siphoning": "syphoning",
    "siphons": "syphons",
    "systematization": "systematisation",
    "systematize": "systematise",
    "systematized": "systematised",
    "systematizes": "systematises",
    "systematizing": "systematising",
    "tantalize": "tantalise",
    "tantalized": "tantalised",
    "tantalizes": "tantalises",
    "tantalizing": "tantalising",
    "tantalizingly": "tantalisingly",
    "tasseled": "tasselled",
    "technicolor": "technicolour",
    "temporize": "temporise",
    "temporized": "temporised",
    "temporizes": "temporises",
    "temporizing": "temporising",
    "tenderize": "tenderise",
    "tenderized": "tenderised",
    "tenderizes": "tenderises",
    "tenderizing": "tenderising",
    "terrorize": "terrorise",
    "terrorized": "terrorised",
    "terrorizes": "terrorises",
    "terrorizing": "terrorising",
    "theater": "theatre",
    "theatergoer": "theatregoer",
    "theatergoers": "theatregoers",
    "theaters": "theatres",
    "theorize": "theorise",
    "theorized": "theorised",
    "theorizes": "theorises",
    "theorizing": "theorising",
    "ton": "tonne",
    "tons": "tonnes",
    "toweled": "towelled",
    "toweling": "towelling",
    "toxemia": "toxaemia",
    "tranquilize": "tranquillize",
    "tranquilized": "tranquillized",
    "tranquilizer": "tranquillizer",
    "tranquilizers": "tranquillizers",
    "tranquilizes": "tranquillizes",
    "tranquilizing": "tranquillizing",
    "tranquility": "tranquilly",
    "transistorized": "transistorised",
    "traumatize": "traumatise",
    "traumatized": "traumatised",
    "traumatizes": "traumatises",
    "traumatizing": "traumatising",
    "traveled": "travelled",
    "traveler": "traveller",
    "travelers": "travellers",
    "traveling": "travelling",
    "travelog": "travelogue",
    "travelogs": "travelogues",
    "trialed": "trialled",
    "trialing": "trialling",
    "tricolor": "tricolour",
    "tricolors": "tricolours",
    "trivialize": "trivialise",
    "trivialized": "trivialised",
    "trivializes": "trivialises",
    "trivializing": "trivialising",
    "tumor": "tumour",
    "tumors": "tumours",
    "tunneled": "tunnelled",
    "tunneling": "tunnelling",
    "tyrannize": "tyrannise",
    "tyrannized": "tyrannised",
    "tyrannizes": "tyrannises",
    "tyrannizing": "tyrannising",
    "tire": "tyre",
    "tires": "tyres",
    "unauthorized": "unauthorised",
    "uncivilized": "uncivilised",
    "underutilized": "underutilised",
    "unequaled": "unequalled",
    "unfavorable": "unfavourable",
    "unfavorably": "unfavourably",
    "unionization": "unionisation",
    "unionize": "unionise",
    "unionized": "unionised",
    "unionizes": "unionises",
    "unionizing": "unionising",
    "unorganized": "unorganised",
    "unraveled": "unravelled",
    "unraveling": "unravelling",
    "unrecognizable": "unrecognisable",
    "unrecognized": "unrecognised",
    "unrivaled": "unrivalled",
    "unsavory": "unsavoury",
    "untrammeled": "untrammelled",
    "urbanization": "urbanisation",
    "urbanize": "urbanise",
    "urbanized": "urbanised",
    "urbanizes": "urbanises",
    "urbanizing": "urbanising",
    "utilizable": "utilisable",
    "utilization": "utilisation",
    "utilize": "utilise",
    "utilized": "utilised",
    "utilizes": "utilises",
    "utilizing": "utilising",
    "valor": "valour",
    "vandalize": "vandalise",
    "vandalized": "vandalised",
    "vandalizes": "vandalises",
    "vandalizing": "vandalising",
    "vaporization": "vaporisation",
    "vaporize": "vaporise",
    "vaporized": "vaporised",
    "vaporizes": "vaporises",
    "vaporizing": "vaporising",
    "vapor": "vapour",
    "vapors": "vapours",
    "verbalize": "verbalise",
    "verbalized": "verbalised",
    "verbalizes": "verbalises",
    "verbalizing": "verbalising",
    "victimization": "victimisation",
    "victimize": "victimise",
    "victimized": "victimised",
    "victimizes": "victimises",
    "victimizing": "victimising",
    "videodisk": "videodisc",
    "videodisks": "videodiscs",
    "vigor": "vigour",
    "visualization": "visualisation",
    "visualizations": "visualisations",
    "visualize": "visualise",
    "visualized": "visualised",
    "visualizes": "visualises",
    "visualizing": "visualising",
    "vocalization": "vocalisation",
    "vocalizations": "vocalisations",
    "vocalize": "vocalise",
    "vocalized": "vocalised",
    "vocalizes": "vocalises",
    "vocalizing": "vocalising",
    "vulcanized": "vulcanised",
    "vulgarization": "vulgarisation",
    "vulgarize": "vulgarise",
    "vulgarized": "vulgarised",
    "vulgarizes": "vulgarises",
    "vulgarizing": "vulgarising",
    "watercolor": "watercolour",
    "watercolors": "watercolours",
    "weaseled": "weaselled",
    "weaseling": "weaselling",
    "westernization": "westernisation",
    "westernize": "westernise",
    "westernized": "westernised",
    "westernizes": "westernises",
    "westernizing": "westernising",
    "womanize": "womanise",
    "womanized": "womanised",
    "womanizer": "womaniser",
    "womanizers": "womanisers",
    "womanizes": "womanises",
    "womanizing": "womanising",
    "woolen": "woollen",
    "woolens": "woollens",
    "woolies": "woollies",
    "wooly": "woolly",
    "worshiped": "worshipped",
    "worshiping": "worshipping",
    "worshiper": "worshipper",
    "yodeled": "yodelled",
    "yodeling": "yodelling",
    "yogurt": "yoghurt",
    "yogurts": "yoghurts",
}
