# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabaseBackupsResult',
    'AwaitableGetAutonomousDatabaseBackupsResult',
    'get_autonomous_database_backups',
    'get_autonomous_database_backups_output',
]

@pulumi.output_type
class GetAutonomousDatabaseBackupsResult:
    """
    A collection of values returned by getAutonomousDatabaseBackups.
    """
    def __init__(__self__, autonomous_database_backups=None, autonomous_database_id=None, compartment_id=None, display_name=None, filters=None, id=None, state=None, type=None):
        if autonomous_database_backups and not isinstance(autonomous_database_backups, list):
            raise TypeError("Expected argument 'autonomous_database_backups' to be a list")
        pulumi.set(__self__, "autonomous_database_backups", autonomous_database_backups)
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autonomousDatabaseBackups")
    def autonomous_database_backups(self) -> Sequence['outputs.GetAutonomousDatabaseBackupsAutonomousDatabaseBackupResult']:
        """
        The list of autonomous_database_backups.
        """
        return pulumi.get(self, "autonomous_database_backups")

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the backup. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabaseBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of backup.
        """
        return pulumi.get(self, "type")


class AwaitableGetAutonomousDatabaseBackupsResult(GetAutonomousDatabaseBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseBackupsResult(
            autonomous_database_backups=self.autonomous_database_backups,
            autonomous_database_id=self.autonomous_database_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            type=self.type)


def get_autonomous_database_backups(autonomous_database_id: Optional[str] = None,
                                    compartment_id: Optional[str] = None,
                                    display_name: Optional[str] = None,
                                    filters: Optional[Sequence[pulumi.InputType['GetAutonomousDatabaseBackupsFilterArgs']]] = None,
                                    state: Optional[str] = None,
                                    type: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseBackupsResult:
    """
    This data source provides the list of Autonomous Database Backups in Oracle Cloud Infrastructure Database service.

    Gets a list of Autonomous Database backups based on either the `autonomousDatabaseId` or `compartmentId` specified as a query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_backups = oci.Database.get_autonomous_database_backups(autonomous_database_id=oci_database_autonomous_database["test_autonomous_database"]["id"],
        compartment_id=var["compartment_id"],
        display_name=var["autonomous_database_backup_display_name"],
        state=var["autonomous_database_backup_state"],
        type=var["autonomous_database_backup_type"])
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str type: A filter to return only backups that matches with the given type of Backup.
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseBackups:getAutonomousDatabaseBackups', __args__, opts=opts, typ=GetAutonomousDatabaseBackupsResult).value

    return AwaitableGetAutonomousDatabaseBackupsResult(
        autonomous_database_backups=pulumi.get(__ret__, 'autonomous_database_backups'),
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_autonomous_database_backups)
def get_autonomous_database_backups_output(autonomous_database_id: Optional[pulumi.Input[Optional[str]]] = None,
                                           compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                           display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAutonomousDatabaseBackupsFilterArgs']]]]] = None,
                                           state: Optional[pulumi.Input[Optional[str]]] = None,
                                           type: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousDatabaseBackupsResult]:
    """
    This data source provides the list of Autonomous Database Backups in Oracle Cloud Infrastructure Database service.

    Gets a list of Autonomous Database backups based on either the `autonomousDatabaseId` or `compartmentId` specified as a query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_backups = oci.Database.get_autonomous_database_backups(autonomous_database_id=oci_database_autonomous_database["test_autonomous_database"]["id"],
        compartment_id=var["compartment_id"],
        display_name=var["autonomous_database_backup_display_name"],
        state=var["autonomous_database_backup_state"],
        type=var["autonomous_database_backup_type"])
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str type: A filter to return only backups that matches with the given type of Backup.
    """
    ...
