# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbSystemConnectionDetailResult',
    'AwaitableGetDbSystemConnectionDetailResult',
    'get_db_system_connection_detail',
    'get_db_system_connection_detail_output',
]

@pulumi.output_type
class GetDbSystemConnectionDetailResult:
    """
    A collection of values returned by getDbSystemConnectionDetail.
    """
    def __init__(__self__, ca_certificate=None, db_system_id=None, id=None, instance_endpoints=None, primary_db_endpoints=None):
        if ca_certificate and not isinstance(ca_certificate, str):
            raise TypeError("Expected argument 'ca_certificate' to be a str")
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_endpoints and not isinstance(instance_endpoints, list):
            raise TypeError("Expected argument 'instance_endpoints' to be a list")
        pulumi.set(__self__, "instance_endpoints", instance_endpoints)
        if primary_db_endpoints and not isinstance(primary_db_endpoints, list):
            raise TypeError("Expected argument 'primary_db_endpoints' to be a list")
        pulumi.set(__self__, "primary_db_endpoints", primary_db_endpoints)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        The CA certificate to be used by the Posgresql client to connect to the database. The CA certificate is used to authenticate the server identity.  It is issued by PostgreSQL Service Private CA.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceEndpoints")
    def instance_endpoints(self) -> Sequence['outputs.GetDbSystemConnectionDetailInstanceEndpointResult']:
        """
        The list of DbInstance endpoints in the DbSystem.
        """
        return pulumi.get(self, "instance_endpoints")

    @property
    @pulumi.getter(name="primaryDbEndpoints")
    def primary_db_endpoints(self) -> Sequence['outputs.GetDbSystemConnectionDetailPrimaryDbEndpointResult']:
        """
        The node endpoint information.
        """
        return pulumi.get(self, "primary_db_endpoints")


class AwaitableGetDbSystemConnectionDetailResult(GetDbSystemConnectionDetailResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemConnectionDetailResult(
            ca_certificate=self.ca_certificate,
            db_system_id=self.db_system_id,
            id=self.id,
            instance_endpoints=self.instance_endpoints,
            primary_db_endpoints=self.primary_db_endpoints)


def get_db_system_connection_detail(db_system_id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemConnectionDetailResult:
    """
    This data source provides details about a specific Db System Connection Detail resource in Oracle Cloud Infrastructure Psql service.

    Gets the DbSystem connection details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_system_connection_detail = oci.Psql.get_db_system_connection_detail(db_system_id=oci_psql_db_system["test_db_system"]["id"])
    ```


    :param str db_system_id: unique DbSystem identifier
    """
    __args__ = dict()
    __args__['dbSystemId'] = db_system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Psql/getDbSystemConnectionDetail:getDbSystemConnectionDetail', __args__, opts=opts, typ=GetDbSystemConnectionDetailResult).value

    return AwaitableGetDbSystemConnectionDetailResult(
        ca_certificate=pulumi.get(__ret__, 'ca_certificate'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_endpoints=pulumi.get(__ret__, 'instance_endpoints'),
        primary_db_endpoints=pulumi.get(__ret__, 'primary_db_endpoints'))


@_utilities.lift_output_func(get_db_system_connection_detail)
def get_db_system_connection_detail_output(db_system_id: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbSystemConnectionDetailResult]:
    """
    This data source provides details about a specific Db System Connection Detail resource in Oracle Cloud Infrastructure Psql service.

    Gets the DbSystem connection details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_system_connection_detail = oci.Psql.get_db_system_connection_detail(db_system_id=oci_psql_db_system["test_db_system"]["id"])
    ```


    :param str db_system_id: unique DbSystem identifier
    """
    ...
