from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersCore

class vtkHyperTreeGridAxisClip(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    class ClipType(int): ...
    BOX:'ClipType'
    PLANE:'ClipType'
    QUADRIC:'ClipType'
    bounds:'getset_descriptor'
    clip_type:'getset_descriptor'
    inside_out:'getset_descriptor'
    m_time:'getset_descriptor'
    plane_normal_axis:'getset_descriptor'
    plane_position:'getset_descriptor'
    quadric:'getset_descriptor'
    quadric_coefficients:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetClipType(self) -> int: ...
    def GetClipTypeMaxValue(self) -> int: ...
    def GetClipTypeMinValue(self) -> int: ...
    def GetInsideOut(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMaximumBounds(self, __a:MutableSequence[float]) -> None: ...
    def GetMinimumBounds(self, __a:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlaneNormalAxis(self) -> int: ...
    def GetPlaneNormalAxisMaxValue(self) -> int: ...
    def GetPlaneNormalAxisMinValue(self) -> int: ...
    def GetPlanePosition(self) -> float: ...
    def GetQuadric(self) -> 'vtkQuadric': ...
    @overload
    def GetQuadricCoefficients(self, __a:MutableSequence[float]) -> None: ...
    @overload
    def GetQuadricCoefficients(self) -> Pointer: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridAxisClip': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridAxisClip': ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetClipType(self, _arg:int) -> None: ...
    def SetClipTypeToBox(self) -> None: ...
    def SetClipTypeToPlane(self) -> None: ...
    def SetClipTypeToQuadric(self) -> None: ...
    def SetInsideOut(self, _arg:bool) -> None: ...
    def SetPlaneNormalAxis(self, _arg:int) -> None: ...
    def SetPlanePosition(self, _arg:float) -> None: ...
    def SetQuadric(self, __a:'vtkQuadric') -> None: ...
    @overload
    def SetQuadricCoefficients(self, a:float, b:float, c:float, d:float, e:float, f:float, g:float, h:float, i:float, j:float) -> None: ...
    @overload
    def SetQuadricCoefficients(self, __a:MutableSequence[float]) -> None: ...

class vtkHyperTreeGridAxisCut(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    plane_normal_axis:'getset_descriptor'
    plane_position:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlaneNormalAxis(self) -> int: ...
    def GetPlaneNormalAxisMaxValue(self) -> int: ...
    def GetPlaneNormalAxisMinValue(self) -> int: ...
    def GetPlanePosition(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridAxisCut': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridAxisCut': ...
    def SetPlaneNormalAxis(self, _arg:int) -> None: ...
    def SetPlanePosition(self, _arg:float) -> None: ...

class vtkHyperTreeGridAxisReflection(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    class AxisReflectionPlane(int): ...
    USE_X:'AxisReflectionPlane'
    USE_X_MAX:'AxisReflectionPlane'
    USE_X_MIN:'AxisReflectionPlane'
    USE_Y:'AxisReflectionPlane'
    USE_Y_MAX:'AxisReflectionPlane'
    USE_Y_MIN:'AxisReflectionPlane'
    USE_Z:'AxisReflectionPlane'
    USE_Z_MAX:'AxisReflectionPlane'
    USE_Z_MIN:'AxisReflectionPlane'
    center:'getset_descriptor'
    plane:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCenter(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlane(self) -> int: ...
    def GetPlaneMaxValue(self) -> int: ...
    def GetPlaneMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridAxisReflection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridAxisReflection': ...
    def SetCenter(self, _arg:float) -> None: ...
    def SetPlane(self, _arg:int) -> None: ...
    def SetPlaneToX(self) -> None: ...
    def SetPlaneToXMax(self) -> None: ...
    def SetPlaneToXMin(self) -> None: ...
    def SetPlaneToY(self) -> None: ...
    def SetPlaneToYMax(self) -> None: ...
    def SetPlaneToYMin(self) -> None: ...
    def SetPlaneToZ(self) -> None: ...
    def SetPlaneToZMax(self) -> None: ...
    def SetPlaneToZMin(self) -> None: ...

class vtkHyperTreeGridCellCenters(vtkmodules.vtkFiltersCore.vtkCellCenters):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridCellCenters': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridCellCenters': ...

class vtkHyperTreeGridContour(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    class CellStrategy3D(int): ...
    USE_DECOMPOSED_POLYHEDRA:'CellStrategy3D'
    USE_VOXELS:'CellStrategy3D'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    strategy3d:'getset_descriptor'
    use_implicit_arrays:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    @overload
    def GenerateValues(self, __a:int, __b:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, __a:int, __b:float, __c:float) -> None: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStrategy3DMaxValue(self) -> int: ...
    def GetStrategy3DMinValue(self) -> int: ...
    def GetUseImplicitArrays(self) -> bool: ...
    def GetValue(self, __a:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, __a:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridContour': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridContour': ...
    def SetLocator(self, __a:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, __a:int) -> None: ...
    def SetStrategy3D(self, _arg:int) -> None: ...
    def SetUseImplicitArrays(self, _arg:bool) -> None: ...
    def SetValue(self, __a:int, __b:float) -> None: ...
    def UseImplicitArraysOff(self) -> None: ...
    def UseImplicitArraysOn(self) -> None: ...

class vtkHyperTreeGridDepthLimiter(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    depth:'getset_descriptor'
    just_create_new_mask:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDepth(self) -> int: ...
    def GetJustCreateNewMask(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridDepthLimiter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridDepthLimiter': ...
    def SetDepth(self, _arg:int) -> None: ...
    def SetJustCreateNewMask(self, _arg:bool) -> None: ...

class vtkHyperTreeGridEvaluateCoarse(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    OPERATOR_AVERAGE:int
    OPERATOR_DON_T_CHANGE:int
    OPERATOR_DON_T_CHANGE_FAST:int
    OPERATOR_ELDER_CHILD:int
    OPERATOR_MAX:int
    OPERATOR_MIN:int
    OPERATOR_SPLATTING_AVERAGE:int
    OPERATOR_SUM:int
    OPERATOR_UNMASKED_AVERAGE:int
    default:'getset_descriptor'
    operator:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOperator(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridEvaluateCoarse': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridEvaluateCoarse': ...
    def SetDefault(self, _arg:float) -> None: ...
    def SetOperator(self, _arg:int) -> None: ...

class vtkHyperTreeGridExtractGhostCells(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    output_ghost_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputGhostArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridExtractGhostCells': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridExtractGhostCells': ...
    def SetOutputGhostArrayName(self, _arg:str) -> None: ...

class vtkHyperTreeGridFeatureEdges(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    merge_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMergePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridFeatureEdges': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridFeatureEdges': ...
    def SetMergePoints(self, _arg:bool) -> None: ...

class vtkHyperTreeGridGeometry(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    merging:'getset_descriptor'
    original_cell_id_array_name:'getset_descriptor'
    pass_through_cell_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMerging(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalCellIdArrayName(self) -> str: ...
    def GetPassThroughCellIds(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridGeometry': ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridGeometry': ...
    def SetMerging(self, _arg:bool) -> None: ...
    def SetOriginalCellIdArrayName(self, _arg:str) -> None: ...
    def SetPassThroughCellIds(self, _arg:bool) -> None: ...

class vtkHyperTreeGridGradient(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    class ComputeMode(int): ...
    UNLIMITED:'ComputeMode'
    UNSTRUCTURED:'ComputeMode'
    compute_divergence:'getset_descriptor'
    compute_gradient:'getset_descriptor'
    compute_q_criterion:'getset_descriptor'
    compute_vorticity:'getset_descriptor'
    divergence_array_name:'getset_descriptor'
    extensive_computation:'getset_descriptor'
    gradient_array_name:'getset_descriptor'
    mode:'getset_descriptor'
    q_criterion_array_name:'getset_descriptor'
    result_array_name:'getset_descriptor'
    vorticity_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeDivergenceOff(self) -> None: ...
    def ComputeDivergenceOn(self) -> None: ...
    def ComputeGradientOff(self) -> None: ...
    def ComputeGradientOn(self) -> None: ...
    def ComputeQCriterionOff(self) -> None: ...
    def ComputeQCriterionOn(self) -> None: ...
    def ComputeVorticityOff(self) -> None: ...
    def ComputeVorticityOn(self) -> None: ...
    def ExtensiveComputationOff(self) -> None: ...
    def ExtensiveComputationOn(self) -> None: ...
    def GetComputeDivergence(self) -> bool: ...
    def GetComputeGradient(self) -> bool: ...
    def GetComputeQCriterion(self) -> bool: ...
    def GetComputeVorticity(self) -> bool: ...
    def GetDivergenceArrayName(self) -> str: ...
    def GetExtensiveComputation(self) -> bool: ...
    def GetGradientArrayName(self) -> str: ...
    def GetMode(self) -> int: ...
    def GetModeMaxValue(self) -> int: ...
    def GetModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetQCriterionArrayName(self) -> str: ...
    def GetResultArrayName(self) -> str: ...
    def GetVorticityArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridGradient': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridGradient': ...
    def SetComputeDivergence(self, _arg:bool) -> None: ...
    def SetComputeGradient(self, _arg:bool) -> None: ...
    def SetComputeQCriterion(self, _arg:bool) -> None: ...
    def SetComputeVorticity(self, _arg:bool) -> None: ...
    def SetDivergenceArrayName(self, _arg:str) -> None: ...
    def SetExtensiveComputation(self, _arg:bool) -> None: ...
    def SetGradientArrayName(self, _arg:str) -> None: ...
    def SetMode(self, _arg:int) -> None: ...
    def SetQCriterionArrayName(self, _arg:str) -> None: ...
    def SetResultArrayName(self, name:str) -> None: ...
    def SetVorticityArrayName(self, _arg:str) -> None: ...

class vtkHyperTreeGridPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    axis_alignment:'getset_descriptor'
    dual:'getset_descriptor'
    plane:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DualOff(self) -> None: ...
    def DualOn(self) -> None: ...
    def GetAxisAlignment(self) -> int: ...
    def GetDual(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlane(self) -> Tuple[float, float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    def IsPlaneOrthogonalToXAxis(self) -> bool: ...
    def IsPlaneOrthogonalToYAxis(self) -> bool: ...
    def IsPlaneOrthogonalToZAxis(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridPlaneCutter': ...
    def SetDual(self, _arg:int) -> None: ...
    def SetPlane(self, a:float, b:float, c:float, d:float) -> None: ...

class vtkHyperTreeGridRemoveGhostCells(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridRemoveGhostCells': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridRemoveGhostCells': ...

class vtkHyperTreeGridThreshold(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    class MemoryStrategyChoice(int): ...
    CopyStructureAndIndexArrays:'MemoryStrategyChoice'
    DeepThreshold:'MemoryStrategyChoice'
    MaskInput:'MemoryStrategyChoice'
    just_create_new_mask:'getset_descriptor'
    lower_threshold:'getset_descriptor'
    memory_strategy:'getset_descriptor'
    upper_threshold:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetJustCreateNewMask(self) -> bool: ...
    def GetLowerThreshold(self) -> float: ...
    def GetMemoryStrategy(self) -> int: ...
    def GetMemoryStrategyMaxValue(self) -> int: ...
    def GetMemoryStrategyMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUpperThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridThreshold': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridThreshold': ...
    def SetJustCreateNewMask(self, __a:bool) -> None: ...
    def SetLowerThreshold(self, _arg:float) -> None: ...
    def SetMemoryStrategy(self, _arg:int) -> None: ...
    def SetUpperThreshold(self, _arg:float) -> None: ...
    def ThresholdBetween(self, __a:float, __b:float) -> None: ...

class vtkHyperTreeGridToDualGrid(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridToDualGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridToDualGrid': ...

class vtkHyperTreeGridToUnstructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    add_original_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddOriginalIdsOff(self) -> None: ...
    def AddOriginalIdsOn(self) -> None: ...
    def GetAddOriginalIds(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridToUnstructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridToUnstructuredGrid': ...
    def SetAddOriginalIds(self, _arg:bool) -> None: ...

class vtkHyperTreeGridVisibleLeavesSize(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    cell_size_array_name:'getset_descriptor'
    valid_cell_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellSizeArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValidCellArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridVisibleLeavesSize': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridVisibleLeavesSize': ...
    def SetCellSizeArrayName(self, _arg:str) -> None: ...
    def SetValidCellArrayName(self, _arg:str) -> None: ...

class vtkImageDataToHyperTreeGrid(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    depth_max:'getset_descriptor'
    nb_colors:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDepthMax(self) -> int: ...
    def GetNbColors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDataToHyperTreeGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDataToHyperTreeGrid': ...
    def SetDepthMax(self, _arg:int) -> None: ...
    def SetNbColors(self, _arg:int) -> None: ...

