/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars.persistency;

import com.siemens.ct.exi.core.context.GrammarContext;
import com.siemens.ct.exi.core.context.GrammarUriContext;
import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.grammars.Grammars;
import com.siemens.ct.exi.core.grammars.SchemaInformedGrammars;
import com.siemens.ct.exi.core.grammars.event.StartElement;
import com.siemens.ct.exi.core.grammars.grammar.DocEnd;
import com.siemens.ct.exi.core.grammars.grammar.Document;
import com.siemens.ct.exi.core.grammars.grammar.Fragment;
import com.siemens.ct.exi.core.grammars.grammar.Grammar;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedDocContent;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedElement;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedFirstStartTag;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedFragmentContent;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.core.grammars.grammar.SchemaInformedStartTag;
import com.siemens.ct.exi.core.grammars.production.Production;
import com.siemens.ct.exi.grammars.persistency.GrammarIdDispenser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GrammarsPreperation {
    protected GrammarIdDispenser grsIdDispenser = new GrammarIdDispenser();
    protected List<Grammar> sortedGrammars = new ArrayList<Grammar>();
    protected int numberOfFirstStartTagGrammars;
    protected int numberOfStartTagGrammars;
    protected int numberOfElementGrammars;

    public void clear() {
        this.grsIdDispenser.clear();
        this.sortedGrammars.clear();
        this.numberOfFirstStartTagGrammars = 0;
        this.numberOfStartTagGrammars = 0;
        this.numberOfElementGrammars = 0;
    }

    public void prepareGrammars(Grammars grammar) throws IOException {
        this.clear();
        Grammar doc = grammar.getDocumentGrammar();
        this.prepareGrammar(doc);
        Grammar frag = grammar.getFragmentGrammar();
        this.prepareGrammar(frag);
        if (grammar instanceof SchemaInformedGrammars) {
            SchemaInformedGrammar elFragGr = ((SchemaInformedGrammars)grammar).getSchemaInformedElementFragmentGrammar();
            this.prepareGrammar(elFragGr);
        }
        GrammarContext gc = grammar.getGrammarContext();
        int uriId = 0;
        while (uriId < gc.getNumberOfGrammarUriContexts()) {
            GrammarUriContext guc = gc.getGrammarUriContext(uriId);
            int qnId = 0;
            while (qnId < guc.getNumberOfQNames()) {
                QNameContext qnc = guc.getQNameContext(qnId);
                SchemaInformedFirstStartTagGrammar typeGrammar = qnc.getTypeGrammar();
                if (typeGrammar != null) {
                    this.prepareGrammar(typeGrammar);
                }
                ++qnId;
            }
            ++uriId;
        }
        this.sortedGrammars.clear();
        int k = 0;
        while (k < 8) {
            Iterator<Grammar> iterGrs = this.grsIdDispenser.getGrammarIterator();
            block13: while (iterGrs.hasNext()) {
                Grammar r = iterGrs.next();
                switch (k) {
                    case 0: {
                        if (!(r instanceof Document)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 1: {
                        if (!(r instanceof SchemaInformedDocContent)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 2: {
                        if (!(r instanceof DocEnd)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 3: {
                        if (!(r instanceof Fragment)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 4: {
                        if (!(r instanceof SchemaInformedFragmentContent)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 5: {
                        if (!(r instanceof SchemaInformedFirstStartTag)) break;
                        ++this.numberOfFirstStartTagGrammars;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 6: {
                        if (!(r instanceof SchemaInformedStartTag) || r instanceof SchemaInformedFirstStartTag) continue block13;
                        ++this.numberOfStartTagGrammars;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 7: {
                        if (!(r instanceof SchemaInformedElement)) break;
                        ++this.numberOfElementGrammars;
                        this.sortedGrammars.add(r);
                    }
                }
            }
            ++k;
        }
        System.out.println("Sorted Grammars: " + this.sortedGrammars);
    }

    void prepareGrammar(Grammar r) throws IOException {
        if (this.grsIdDispenser.isGrammarHandled(r)) {
            return;
        }
        this.grsIdDispenser.addHandledGrammar(r);
        int numberOfEvents = r.getNumberOfEvents();
        int eventCode = 0;
        while (eventCode < numberOfEvents) {
            Production ei = r.getProduction(eventCode);
            switch (ei.getEvent().getEventType()) {
                case START_ELEMENT: {
                    StartElement se = (StartElement)ei.getEvent();
                    if (this.grsIdDispenser.isGrammarHandled(se.getGrammar())) break;
                    this.prepareGrammar(se.getGrammar());
                }
            }
            if (ei.getNextGrammar() != null) {
                this.prepareGrammar(ei.getNextGrammar());
            }
            ++eventCode;
        }
        this.prepareGrammar(r.getElementContentGrammar());
    }

    public int getGrammarID(Grammar r) {
        int id1 = this.grsIdDispenser.getGrammarID(r);
        Grammar g1 = this.grsIdDispenser.getGrammar(id1);
        int i = 0;
        while (i < this.sortedGrammars.size()) {
            Grammar g = this.sortedGrammars.get(i);
            if (g1 == g) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("No grammar id found for: " + r);
    }

    public Grammar getGrammar(int id) {
        return this.sortedGrammars.get(id);
    }

    public int getNumberOfGrammars() {
        return this.sortedGrammars.size();
    }

    public int getNumberOfFirstStartTagGrammars() {
        return this.numberOfFirstStartTagGrammars;
    }

    public int getNumberOfStartTagGrammars() {
        return this.numberOfStartTagGrammars;
    }

    public int getNumberOfElementGrammars() {
        return this.numberOfElementGrammars;
    }
}

