# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from openapi_client.models.create_adjustment_note_support_document200_response import CreateAdjustmentNoteSupportDocument200Response
from openapi_client.models.create_adjustment_note_support_document_request import CreateAdjustmentNoteSupportDocumentRequest
from openapi_client.models.create_support_document200_response import CreateSupportDocument200Response
from openapi_client.models.create_support_document_request import CreateSupportDocumentRequest
from openapi_client.models.get_payroll_file200_response import GetPayrollFile200Response
from openapi_client.models.get_support_documents200_response import GetSupportDocuments200Response

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType


class DocumentosSoporteElectrnicosApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def adjustment_note_support_document_file(
        self,
        id: Annotated[StrictStr, Field(description="Id de la nota de ajuste al documento soporte electrónico")],
        file_type: Annotated[StrictStr, Field(description="Tipo de archivo que se desea obtener")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPayrollFile200Response:
        """Endpoint para obtener un archivo asociado a la nota de ajuste al documento soporte electrónico

        Retorna el archivo asociado a la nota de ajuste al documento soporte electrónico codificado en base 64

        :param id: Id de la nota de ajuste al documento soporte electrónico (required)
        :type id: str
        :param file_type: Tipo de archivo que se desea obtener (required)
        :type file_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._adjustment_note_support_document_file_serialize(
            id=id,
            file_type=file_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPayrollFile200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def adjustment_note_support_document_file_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Id de la nota de ajuste al documento soporte electrónico")],
        file_type: Annotated[StrictStr, Field(description="Tipo de archivo que se desea obtener")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPayrollFile200Response]:
        """Endpoint para obtener un archivo asociado a la nota de ajuste al documento soporte electrónico

        Retorna el archivo asociado a la nota de ajuste al documento soporte electrónico codificado en base 64

        :param id: Id de la nota de ajuste al documento soporte electrónico (required)
        :type id: str
        :param file_type: Tipo de archivo que se desea obtener (required)
        :type file_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._adjustment_note_support_document_file_serialize(
            id=id,
            file_type=file_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPayrollFile200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def adjustment_note_support_document_file_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Id de la nota de ajuste al documento soporte electrónico")],
        file_type: Annotated[StrictStr, Field(description="Tipo de archivo que se desea obtener")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Endpoint para obtener un archivo asociado a la nota de ajuste al documento soporte electrónico

        Retorna el archivo asociado a la nota de ajuste al documento soporte electrónico codificado en base 64

        :param id: Id de la nota de ajuste al documento soporte electrónico (required)
        :type id: str
        :param file_type: Tipo de archivo que se desea obtener (required)
        :type file_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._adjustment_note_support_document_file_serialize(
            id=id,
            file_type=file_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPayrollFile200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _adjustment_note_support_document_file_serialize(
        self,
        id,
        file_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if file_type is not None:
            _path_params['fileType'] = file_type
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/adjustment-note-support-documents/{id}/files/{fileType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_adjustment_note_support_document(
        self,
        create_adjustment_note_support_document_request: Annotated[CreateAdjustmentNoteSupportDocumentRequest, Field(description="Objeto con la información de una nota de ajuste al documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateAdjustmentNoteSupportDocument200Response:
        """Endpoint para emitir una nota de ajuste al documento soporte electrónico a la DIAN

        Este endpoint permite emitir una nota de ajuste al documento soporte electrónico a la DIAN. Recuerda visitar previamente las guías de [Inicio](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-creaci%C3%B3n-de-una-compa%C3%B1%C3%ADa-asociada) y la guía de [Habilitación en la DIAN - Documento Soporte Electrónico](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-del-proceso-de-habilitaci%C3%B3n-en-la-dian-documento-soporte-electr%C3%B3nico)

        :param create_adjustment_note_support_document_request: Objeto con la información de una nota de ajuste al documento soporte electrónico (required)
        :type create_adjustment_note_support_document_request: CreateAdjustmentNoteSupportDocumentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_adjustment_note_support_document_serialize(
            create_adjustment_note_support_document_request=create_adjustment_note_support_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAdjustmentNoteSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_adjustment_note_support_document_with_http_info(
        self,
        create_adjustment_note_support_document_request: Annotated[CreateAdjustmentNoteSupportDocumentRequest, Field(description="Objeto con la información de una nota de ajuste al documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateAdjustmentNoteSupportDocument200Response]:
        """Endpoint para emitir una nota de ajuste al documento soporte electrónico a la DIAN

        Este endpoint permite emitir una nota de ajuste al documento soporte electrónico a la DIAN. Recuerda visitar previamente las guías de [Inicio](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-creaci%C3%B3n-de-una-compa%C3%B1%C3%ADa-asociada) y la guía de [Habilitación en la DIAN - Documento Soporte Electrónico](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-del-proceso-de-habilitaci%C3%B3n-en-la-dian-documento-soporte-electr%C3%B3nico)

        :param create_adjustment_note_support_document_request: Objeto con la información de una nota de ajuste al documento soporte electrónico (required)
        :type create_adjustment_note_support_document_request: CreateAdjustmentNoteSupportDocumentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_adjustment_note_support_document_serialize(
            create_adjustment_note_support_document_request=create_adjustment_note_support_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAdjustmentNoteSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_adjustment_note_support_document_without_preload_content(
        self,
        create_adjustment_note_support_document_request: Annotated[CreateAdjustmentNoteSupportDocumentRequest, Field(description="Objeto con la información de una nota de ajuste al documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Endpoint para emitir una nota de ajuste al documento soporte electrónico a la DIAN

        Este endpoint permite emitir una nota de ajuste al documento soporte electrónico a la DIAN. Recuerda visitar previamente las guías de [Inicio](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-creaci%C3%B3n-de-una-compa%C3%B1%C3%ADa-asociada) y la guía de [Habilitación en la DIAN - Documento Soporte Electrónico](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-del-proceso-de-habilitaci%C3%B3n-en-la-dian-documento-soporte-electr%C3%B3nico)

        :param create_adjustment_note_support_document_request: Objeto con la información de una nota de ajuste al documento soporte electrónico (required)
        :type create_adjustment_note_support_document_request: CreateAdjustmentNoteSupportDocumentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_adjustment_note_support_document_serialize(
            create_adjustment_note_support_document_request=create_adjustment_note_support_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAdjustmentNoteSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_adjustment_note_support_document_serialize(
        self,
        create_adjustment_note_support_document_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_adjustment_note_support_document_request is not None:
            _body_params = create_adjustment_note_support_document_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/adjustment-note-support-documents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_support_document(
        self,
        create_support_document_request: Annotated[CreateSupportDocumentRequest, Field(description="Objeto con la información del documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateSupportDocument200Response:
        """Endpoint para emitir un documento soporte electrónico a la DIAN

        Este endpoint permite emitir un documento soporte electrónico a la DIAN.  Recuerda visitar previamente las guías de [Inicio](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-creaci%C3%B3n-de-una-compa%C3%B1%C3%ADa-asociada) y la guía de [Habilitación en la DIAN - Documento Soporte Electrónico](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-del-proceso-de-habilitaci%C3%B3n-en-la-dian-documento-soporte-electr%C3%B3nico)

        :param create_support_document_request: Objeto con la información del documento soporte electrónico (required)
        :type create_support_document_request: CreateSupportDocumentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_support_document_serialize(
            create_support_document_request=create_support_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_support_document_with_http_info(
        self,
        create_support_document_request: Annotated[CreateSupportDocumentRequest, Field(description="Objeto con la información del documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateSupportDocument200Response]:
        """Endpoint para emitir un documento soporte electrónico a la DIAN

        Este endpoint permite emitir un documento soporte electrónico a la DIAN.  Recuerda visitar previamente las guías de [Inicio](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-creaci%C3%B3n-de-una-compa%C3%B1%C3%ADa-asociada) y la guía de [Habilitación en la DIAN - Documento Soporte Electrónico](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-del-proceso-de-habilitaci%C3%B3n-en-la-dian-documento-soporte-electr%C3%B3nico)

        :param create_support_document_request: Objeto con la información del documento soporte electrónico (required)
        :type create_support_document_request: CreateSupportDocumentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_support_document_serialize(
            create_support_document_request=create_support_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_support_document_without_preload_content(
        self,
        create_support_document_request: Annotated[CreateSupportDocumentRequest, Field(description="Objeto con la información del documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Endpoint para emitir un documento soporte electrónico a la DIAN

        Este endpoint permite emitir un documento soporte electrónico a la DIAN.  Recuerda visitar previamente las guías de [Inicio](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-creaci%C3%B3n-de-una-compa%C3%B1%C3%ADa-asociada) y la guía de [Habilitación en la DIAN - Documento Soporte Electrónico](https://e-provider-docs.alegra.com/docs/gu%C3%ADa-del-proceso-de-habilitaci%C3%B3n-en-la-dian-documento-soporte-electr%C3%B3nico)

        :param create_support_document_request: Objeto con la información del documento soporte electrónico (required)
        :type create_support_document_request: CreateSupportDocumentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_support_document_serialize(
            create_support_document_request=create_support_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_support_document_serialize(
        self,
        create_support_document_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_support_document_request is not None:
            _body_params = create_support_document_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/support-documents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_adjustment_note_support_document(
        self,
        id: Annotated[StrictStr, Field(description="Id de la nota de ajuste a un documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateAdjustmentNoteSupportDocument200Response:
        """Endpoint para consultar una nota de ajuste al documento soporte electrónico

        Retorna toda la información asociada a la nota de ajuste a un documento soporte electrónico enviado como parámetro

        :param id: Id de la nota de ajuste a un documento soporte electrónico (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_adjustment_note_support_document_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAdjustmentNoteSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_adjustment_note_support_document_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Id de la nota de ajuste a un documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateAdjustmentNoteSupportDocument200Response]:
        """Endpoint para consultar una nota de ajuste al documento soporte electrónico

        Retorna toda la información asociada a la nota de ajuste a un documento soporte electrónico enviado como parámetro

        :param id: Id de la nota de ajuste a un documento soporte electrónico (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_adjustment_note_support_document_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAdjustmentNoteSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_adjustment_note_support_document_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Id de la nota de ajuste a un documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Endpoint para consultar una nota de ajuste al documento soporte electrónico

        Retorna toda la información asociada a la nota de ajuste a un documento soporte electrónico enviado como parámetro

        :param id: Id de la nota de ajuste a un documento soporte electrónico (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_adjustment_note_support_document_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAdjustmentNoteSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_adjustment_note_support_document_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/adjustment-note-support-documents/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_support_document(
        self,
        id: Annotated[StrictStr, Field(description="Id del documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateSupportDocument200Response:
        """Endpoint para consultar un documento soporte electrónico

        Retorna toda la información asociada al documento soporte electrónico enviado como parámetro

        :param id: Id del documento soporte electrónico (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_support_document_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_support_document_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Id del documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateSupportDocument200Response]:
        """Endpoint para consultar un documento soporte electrónico

        Retorna toda la información asociada al documento soporte electrónico enviado como parámetro

        :param id: Id del documento soporte electrónico (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_support_document_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_support_document_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Id del documento soporte electrónico")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Endpoint para consultar un documento soporte electrónico

        Retorna toda la información asociada al documento soporte electrónico enviado como parámetro

        :param id: Id del documento soporte electrónico (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_support_document_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateSupportDocument200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_support_document_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/support-documents/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_support_document_file(
        self,
        id: Annotated[StrictStr, Field(description="Id del documento soporte electrónico")],
        file_type: Annotated[StrictStr, Field(description="Tipo de archivo que se desea obtener")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPayrollFile200Response:
        """Endpoint para obtener un archivo asociado al documento soporte electrónico

        Retorna el archivo asociado al documento soporte electrónico codificado en base 64

        :param id: Id del documento soporte electrónico (required)
        :type id: str
        :param file_type: Tipo de archivo que se desea obtener (required)
        :type file_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_support_document_file_serialize(
            id=id,
            file_type=file_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPayrollFile200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_support_document_file_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Id del documento soporte electrónico")],
        file_type: Annotated[StrictStr, Field(description="Tipo de archivo que se desea obtener")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPayrollFile200Response]:
        """Endpoint para obtener un archivo asociado al documento soporte electrónico

        Retorna el archivo asociado al documento soporte electrónico codificado en base 64

        :param id: Id del documento soporte electrónico (required)
        :type id: str
        :param file_type: Tipo de archivo que se desea obtener (required)
        :type file_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_support_document_file_serialize(
            id=id,
            file_type=file_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPayrollFile200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_support_document_file_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Id del documento soporte electrónico")],
        file_type: Annotated[StrictStr, Field(description="Tipo de archivo que se desea obtener")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Endpoint para obtener un archivo asociado al documento soporte electrónico

        Retorna el archivo asociado al documento soporte electrónico codificado en base 64

        :param id: Id del documento soporte electrónico (required)
        :type id: str
        :param file_type: Tipo de archivo que se desea obtener (required)
        :type file_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_support_document_file_serialize(
            id=id,
            file_type=file_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPayrollFile200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_support_document_file_serialize(
        self,
        id,
        file_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if file_type is not None:
            _path_params['fileType'] = file_type
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/support-documents/{id}/files/{fileType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_support_documents(
        self,
        limit: Annotated[Optional[StrictInt], Field(description="Cantidad de resultados a obtener, por defecto es 50.")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por tipo. Este parámetro es opcional, sino se envia este valor, Alegra listará los documentos de tipo 'STANDARD'.")] = None,
        var_from: Annotated[Optional[StrictStr], Field(description="Id del documento a partir del cuál se desea iniciar la consulta.")] = None,
        id_company: Annotated[Optional[StrictStr], Field(description="Id de la empresa. Este parámetro es opcional, sino se envia este objeto, Alegra tomará la empresa asociada al token de autenticación")] = None,
        prefix: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por prefijo")] = None,
        number: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por número, para usar este filtro es obligatorio enviar el de prefijo")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por estado")] = None,
        legal_status: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por estado legal")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetSupportDocuments200Response:
        """Endpoint para consultar documentos soporte electrónicos

        Este endpoint permite consultar todos los documentos soporte electrónicas de una empresa

        :param limit: Cantidad de resultados a obtener, por defecto es 50.
        :type limit: int
        :param type: Filtrar facturas por tipo. Este parámetro es opcional, sino se envia este valor, Alegra listará los documentos de tipo 'STANDARD'.
        :type type: str
        :param var_from: Id del documento a partir del cuál se desea iniciar la consulta.
        :type var_from: str
        :param id_company: Id de la empresa. Este parámetro es opcional, sino se envia este objeto, Alegra tomará la empresa asociada al token de autenticación
        :type id_company: str
        :param prefix: Filtrar facturas por prefijo
        :type prefix: str
        :param number: Filtrar facturas por número, para usar este filtro es obligatorio enviar el de prefijo
        :type number: str
        :param status: Filtrar facturas por estado
        :type status: str
        :param legal_status: Filtrar facturas por estado legal
        :type legal_status: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_support_documents_serialize(
            limit=limit,
            type=type,
            var_from=var_from,
            id_company=id_company,
            prefix=prefix,
            number=number,
            status=status,
            legal_status=legal_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSupportDocuments200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_support_documents_with_http_info(
        self,
        limit: Annotated[Optional[StrictInt], Field(description="Cantidad de resultados a obtener, por defecto es 50.")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por tipo. Este parámetro es opcional, sino se envia este valor, Alegra listará los documentos de tipo 'STANDARD'.")] = None,
        var_from: Annotated[Optional[StrictStr], Field(description="Id del documento a partir del cuál se desea iniciar la consulta.")] = None,
        id_company: Annotated[Optional[StrictStr], Field(description="Id de la empresa. Este parámetro es opcional, sino se envia este objeto, Alegra tomará la empresa asociada al token de autenticación")] = None,
        prefix: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por prefijo")] = None,
        number: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por número, para usar este filtro es obligatorio enviar el de prefijo")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por estado")] = None,
        legal_status: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por estado legal")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetSupportDocuments200Response]:
        """Endpoint para consultar documentos soporte electrónicos

        Este endpoint permite consultar todos los documentos soporte electrónicas de una empresa

        :param limit: Cantidad de resultados a obtener, por defecto es 50.
        :type limit: int
        :param type: Filtrar facturas por tipo. Este parámetro es opcional, sino se envia este valor, Alegra listará los documentos de tipo 'STANDARD'.
        :type type: str
        :param var_from: Id del documento a partir del cuál se desea iniciar la consulta.
        :type var_from: str
        :param id_company: Id de la empresa. Este parámetro es opcional, sino se envia este objeto, Alegra tomará la empresa asociada al token de autenticación
        :type id_company: str
        :param prefix: Filtrar facturas por prefijo
        :type prefix: str
        :param number: Filtrar facturas por número, para usar este filtro es obligatorio enviar el de prefijo
        :type number: str
        :param status: Filtrar facturas por estado
        :type status: str
        :param legal_status: Filtrar facturas por estado legal
        :type legal_status: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_support_documents_serialize(
            limit=limit,
            type=type,
            var_from=var_from,
            id_company=id_company,
            prefix=prefix,
            number=number,
            status=status,
            legal_status=legal_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSupportDocuments200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_support_documents_without_preload_content(
        self,
        limit: Annotated[Optional[StrictInt], Field(description="Cantidad de resultados a obtener, por defecto es 50.")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por tipo. Este parámetro es opcional, sino se envia este valor, Alegra listará los documentos de tipo 'STANDARD'.")] = None,
        var_from: Annotated[Optional[StrictStr], Field(description="Id del documento a partir del cuál se desea iniciar la consulta.")] = None,
        id_company: Annotated[Optional[StrictStr], Field(description="Id de la empresa. Este parámetro es opcional, sino se envia este objeto, Alegra tomará la empresa asociada al token de autenticación")] = None,
        prefix: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por prefijo")] = None,
        number: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por número, para usar este filtro es obligatorio enviar el de prefijo")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por estado")] = None,
        legal_status: Annotated[Optional[StrictStr], Field(description="Filtrar facturas por estado legal")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Endpoint para consultar documentos soporte electrónicos

        Este endpoint permite consultar todos los documentos soporte electrónicas de una empresa

        :param limit: Cantidad de resultados a obtener, por defecto es 50.
        :type limit: int
        :param type: Filtrar facturas por tipo. Este parámetro es opcional, sino se envia este valor, Alegra listará los documentos de tipo 'STANDARD'.
        :type type: str
        :param var_from: Id del documento a partir del cuál se desea iniciar la consulta.
        :type var_from: str
        :param id_company: Id de la empresa. Este parámetro es opcional, sino se envia este objeto, Alegra tomará la empresa asociada al token de autenticación
        :type id_company: str
        :param prefix: Filtrar facturas por prefijo
        :type prefix: str
        :param number: Filtrar facturas por número, para usar este filtro es obligatorio enviar el de prefijo
        :type number: str
        :param status: Filtrar facturas por estado
        :type status: str
        :param legal_status: Filtrar facturas por estado legal
        :type legal_status: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_support_documents_serialize(
            limit=limit,
            type=type,
            var_from=var_from,
            id_company=id_company,
            prefix=prefix,
            number=number,
            status=status,
            legal_status=legal_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSupportDocuments200Response",
            '400': "List[GetDailyDocumentReport400ResponseInner]",
            '404': "List[GetDailyDocumentReport400ResponseInner]",
            '500': "List[GetDailyDocumentReport400ResponseInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_support_documents_serialize(
        self,
        limit,
        type,
        var_from,
        id_company,
        prefix,
        number,
        status,
        legal_status,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if type is not None:
            
            _query_params.append(('type', type))
            
        if var_from is not None:
            
            _query_params.append(('from', var_from))
            
        if id_company is not None:
            
            _query_params.append(('idCompany', id_company))
            
        if prefix is not None:
            
            _query_params.append(('prefix', prefix))
            
        if number is not None:
            
            _query_params.append(('number', number))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if legal_status is not None:
            
            _query_params.append(('legalStatus', legal_status))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/support-documents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


