# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_adjustment_note_equivalent_document_request_customer import CreateAdjustmentNoteEquivalentDocumentRequestCustomer
from openapi_client.models.create_adjustment_note_equivalent_document_request_delivery import CreateAdjustmentNoteEquivalentDocumentRequestDelivery
from openapi_client.models.create_adjustment_note_equivalent_document_request_discrepancy import CreateAdjustmentNoteEquivalentDocumentRequestDiscrepancy
from openapi_client.models.create_adjustment_note_equivalent_document_request_document_reference import CreateAdjustmentNoteEquivalentDocumentRequestDocumentReference
from openapi_client.models.create_adjustment_note_equivalent_document_request_items_inner import CreateAdjustmentNoteEquivalentDocumentRequestItemsInner
from openapi_client.models.create_equivalent_document_pos_request_company import CreateEquivalentDocumentPosRequestCompany
from openapi_client.models.create_equivalent_document_pos_request_discounts_and_charges_inner import CreateEquivalentDocumentPosRequestDiscountsAndChargesInner
from openapi_client.models.create_equivalent_document_pos_request_payments_inner import CreateEquivalentDocumentPosRequestPaymentsInner
from openapi_client.models.create_equivalent_document_pos_request_total_amounts import CreateEquivalentDocumentPosRequestTotalAmounts
from typing import Optional, Set
from typing_extensions import Self

class CreateAdjustmentNoteEquivalentDocumentRequest(BaseModel):
    """
    CreateAdjustmentNoteEquivalentDocumentRequest
    """ # noqa: E501
    prefix: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Prefijo de la nota de ajuste")
    number: Union[StrictFloat, StrictInt] = Field(description="Número de la nota de ajuste del documento equivalente electrónico")
    note: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=5000)]] = Field(default=None, description="Información adicional: Texto libre, relativo al documento")
    document_reference: CreateAdjustmentNoteEquivalentDocumentRequestDocumentReference = Field(alias="documentReference")
    discrepancy: CreateAdjustmentNoteEquivalentDocumentRequestDiscrepancy
    company: CreateEquivalentDocumentPosRequestCompany
    customer: Optional[CreateAdjustmentNoteEquivalentDocumentRequestCustomer] = None
    items: List[CreateAdjustmentNoteEquivalentDocumentRequestItemsInner] = Field(description="Array que contiene el listado de artículos y/o servicios")
    total_amounts: CreateEquivalentDocumentPosRequestTotalAmounts = Field(alias="totalAmounts")
    payments: List[CreateEquivalentDocumentPosRequestPaymentsInner] = Field(description="Array con el listado de pagos. Grupo de campos para información relacionadas con el pago de la factura. <br><i>Grupo de información oficial DIAN &lt;PaymentMeans&gt;</i>")
    discounts_and_charges: Optional[List[CreateEquivalentDocumentPosRequestDiscountsAndChargesInner]] = Field(default=None, description="Array con el listado de Descuentos o Cargos a nivel de factura. Grupo de campos para información relacionada con los descuentos o cargos que no afectan las bases gravables. Los descuentos o cargos que afectan bases gravables se deben informar a nivel de ítem. <br><i>Grupo de información oficial DIAN &lt;AllowanceCharge&gt;</i>", alias="discountsAndCharges")
    delivery: Optional[CreateAdjustmentNoteEquivalentDocumentRequestDelivery] = None
    __properties: ClassVar[List[str]] = ["prefix", "number", "note", "documentReference", "discrepancy", "company", "customer", "items", "totalAmounts", "payments", "discountsAndCharges", "delivery"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteEquivalentDocumentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document_reference
        if self.document_reference:
            _dict['documentReference'] = self.document_reference.to_dict()
        # override the default output from pydantic by calling `to_dict()` of discrepancy
        if self.discrepancy:
            _dict['discrepancy'] = self.discrepancy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of company
        if self.company:
            _dict['company'] = self.company.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customer
        if self.customer:
            _dict['customer'] = self.customer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of total_amounts
        if self.total_amounts:
            _dict['totalAmounts'] = self.total_amounts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item_payments in self.payments:
                if _item_payments:
                    _items.append(_item_payments.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in discounts_and_charges (list)
        _items = []
        if self.discounts_and_charges:
            for _item_discounts_and_charges in self.discounts_and_charges:
                if _item_discounts_and_charges:
                    _items.append(_item_discounts_and_charges.to_dict())
            _dict['discountsAndCharges'] = _items
        # override the default output from pydantic by calling `to_dict()` of delivery
        if self.delivery:
            _dict['delivery'] = self.delivery.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteEquivalentDocumentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "prefix": obj.get("prefix"),
            "number": obj.get("number"),
            "note": obj.get("note"),
            "documentReference": CreateAdjustmentNoteEquivalentDocumentRequestDocumentReference.from_dict(obj["documentReference"]) if obj.get("documentReference") is not None else None,
            "discrepancy": CreateAdjustmentNoteEquivalentDocumentRequestDiscrepancy.from_dict(obj["discrepancy"]) if obj.get("discrepancy") is not None else None,
            "company": CreateEquivalentDocumentPosRequestCompany.from_dict(obj["company"]) if obj.get("company") is not None else None,
            "customer": CreateAdjustmentNoteEquivalentDocumentRequestCustomer.from_dict(obj["customer"]) if obj.get("customer") is not None else None,
            "items": [CreateAdjustmentNoteEquivalentDocumentRequestItemsInner.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "totalAmounts": CreateEquivalentDocumentPosRequestTotalAmounts.from_dict(obj["totalAmounts"]) if obj.get("totalAmounts") is not None else None,
            "payments": [CreateEquivalentDocumentPosRequestPaymentsInner.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "discountsAndCharges": [CreateEquivalentDocumentPosRequestDiscountsAndChargesInner.from_dict(_item) for _item in obj["discountsAndCharges"]] if obj.get("discountsAndCharges") is not None else None,
            "delivery": CreateAdjustmentNoteEquivalentDocumentRequestDelivery.from_dict(obj["delivery"]) if obj.get("delivery") is not None else None
        })
        return _obj


