# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreateInvoiceRequestCompanyShareholdersInner(BaseModel):
    """
    CreateInvoiceRequestCompanyShareholdersInner
    """ # noqa: E501
    identification_number: Annotated[str, Field(min_length=3, strict=True, max_length=30)] = Field(description="Identificación del Participante del consorcio, solo se aceptan  NIT de Colombia. <br><i>Campo oficial DIAN &lt;CompanyID-ShareholderParty&gt;</i>", alias="identificationNumber")
    dv: Annotated[str, Field(strict=True)] = Field(description="DV del NIT del consorciado. <br><i>Campo oficial DIAN &lt;@schemeID-ShareholderParty&gt;</i>")
    name: Annotated[str, Field(min_length=5, strict=True, max_length=450)] = Field(description="Nombre o Razón Social de participante de consorcio. <br><i>Campo oficial DIAN &lt;RegistrationName-ShareholderParty&gt;</i>")
    regime_code: Annotated[str, Field(strict=True)] = Field(description="Obligaciones del Participante del Consorcio.  El elemento acepta las siguientes opciones: `O-13` Gran contribuyente; `O-15` Autorretenedor; `O-23` Agente de retención IVA; `O-47` Régimen simple de tributación; `R-99-PN` No aplica – Otros. Para reportar varias obligaciones / responsabilidades se deben separar los valores con ';'. Ejemplo O‐13;O‐15; . <br><i>Campo oficial DIAN &lt;TaxLevelCode-ShareholderParty&gt;</i>", alias="regimeCode")
    percent: Union[Annotated[float, Field(le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]] = Field(description="Porcentaje del participante en el consorcio. <br><i>Campo oficial DIAN &lt;PartecipationPercent-ShareholderParty&gt;</i>")
    tax_code: StrictStr = Field(description="Identificador del tributo. Este elemento acepta una de las siguientes opciones: `01` IVA; `04` INC; `ZA` IVA e INC; `ZZ` No aplica. <br><i>Campo oficial DIAN &lt;TaxScheme-ShareholderParty&gt;</i>", alias="taxCode")
    __properties: ClassVar[List[str]] = ["identificationNumber", "dv", "name", "regimeCode", "percent", "taxCode"]

    @field_validator('dv')
    def dv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([0-9]{1})$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]{1})$/")
        return value

    @field_validator('regime_code')
    def regime_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(O-(13|15|23|47)|R-99-PN)(;(O-(13|15|23|47)|R-99-PN))*$", value):
            raise ValueError(r"must validate the regular expression /^(O-(13|15|23|47)|R-99-PN)(;(O-(13|15|23|47)|R-99-PN))*$/")
        return value

    @field_validator('tax_code')
    def tax_code_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['01', '04', 'ZA', 'ZZ']):
            raise ValueError("must be one of enum values ('01', '04', 'ZA', 'ZZ')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestCompanyShareholdersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestCompanyShareholdersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "identificationNumber": obj.get("identificationNumber"),
            "dv": obj.get("dv"),
            "name": obj.get("name"),
            "regimeCode": obj.get("regimeCode"),
            "percent": obj.get("percent"),
            "taxCode": obj.get("taxCode")
        })
        return _obj


