# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.create_invoice_request_health_sector_general_prepaid_payments_inner import CreateInvoiceRequestHealthSectorGeneralPrepaidPaymentsInner
from typing import Optional, Set
from typing_extensions import Self

class CreateInvoiceRequestHealthSectorGeneral(BaseModel):
    """
    Objeto que contiene los campos de datos adicionales correspondientes al Sector Salud
    """ # noqa: E501
    service_provider_code: StrictStr = Field(description="Código del prestador de servicios de salud", alias="serviceProviderCode")
    payment_method: Annotated[str, Field(strict=True, max_length=2)] = Field(description="Modalidad de pago. Debe registrarse la modalidad de pago pactada objeto de facturación. Se debe colocar el Código que corresponda de la tabla de los tipos de modalidades de pago (Sector Salud) disponibles de la DIAN", alias="paymentMethod")
    benefits_plan_type: Annotated[str, Field(strict=True, max_length=2)] = Field(description="Cobertura o plan de beneficios. Se debe colocar el Código que corresponda de la tabla de los tipos de cobertura o plan de beneficios (Sector Salud) disponibles de la DIAN", alias="benefitsPlanType")
    contract_number: Optional[StrictStr] = Field(default=None, description="Número de contrato. Cuando sea informado un número de contrato no se podrá informar un número de póliza (`policyNumber`).", alias="contractNumber")
    policy_number: Optional[StrictStr] = Field(default=None, description="Número de póliza SOAT o del número de póliza de planes voluntarios de salud.  Cuando sea informado un número de Póliza, no se podrá informar un número de contrato (`contractNumber`)", alias="policyNumber")
    prepaid_payments: List[CreateInvoiceRequestHealthSectorGeneralPrepaidPaymentsInner] = Field(alias="prepaidPayments")
    service_start_date: date = Field(description="Fecha de inicio del periodo de facturación. Formato AAAA-MM-DD", alias="serviceStartDate")
    service_end_date: date = Field(description="Fecha final del periodo de facturación. Formato AAAA-MM-DD", alias="serviceEndDate")
    operation_type: StrictStr = Field(description="Código del tipo de operación salud", alias="operationType")
    __properties: ClassVar[List[str]] = ["serviceProviderCode", "paymentMethod", "benefitsPlanType", "contractNumber", "policyNumber", "prepaidPayments", "serviceStartDate", "serviceEndDate", "operationType"]

    @field_validator('operation_type')
    def operation_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SS-CUFE', 'SS-CUDE', 'SS-POS', 'SS-SNum', 'SS-Recaudo', 'SS-Reporte', 'SS-SinAporte']):
            raise ValueError("must be one of enum values ('SS-CUFE', 'SS-CUDE', 'SS-POS', 'SS-SNum', 'SS-Recaudo', 'SS-Reporte', 'SS-SinAporte')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestHealthSectorGeneral from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in prepaid_payments (list)
        _items = []
        if self.prepaid_payments:
            for _item_prepaid_payments in self.prepaid_payments:
                if _item_prepaid_payments:
                    _items.append(_item_prepaid_payments.to_dict())
            _dict['prepaidPayments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestHealthSectorGeneral from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "serviceProviderCode": obj.get("serviceProviderCode"),
            "paymentMethod": obj.get("paymentMethod"),
            "benefitsPlanType": obj.get("benefitsPlanType"),
            "contractNumber": obj.get("contractNumber"),
            "policyNumber": obj.get("policyNumber"),
            "prepaidPayments": [CreateInvoiceRequestHealthSectorGeneralPrepaidPaymentsInner.from_dict(_item) for _item in obj["prepaidPayments"]] if obj.get("prepaidPayments") is not None else None,
            "serviceStartDate": obj.get("serviceStartDate"),
            "serviceEndDate": obj.get("serviceEndDate"),
            "operationType": obj.get("operationType")
        })
        return _obj


