# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from openapi_client.models.create_payroll_request_government_data_deducciones import CreatePayrollRequestGovernmentDataDeducciones
from openapi_client.models.create_payroll_request_government_data_devengados import CreatePayrollRequestGovernmentDataDevengados
from openapi_client.models.create_payroll_request_government_data_empleador import CreatePayrollRequestGovernmentDataEmpleador
from openapi_client.models.create_payroll_request_government_data_fechas_pagos import CreatePayrollRequestGovernmentDataFechasPagos
from openapi_client.models.create_payroll_request_government_data_informacion_general import CreatePayrollRequestGovernmentDataInformacionGeneral
from openapi_client.models.create_payroll_request_government_data_lugar_generacion_xml import CreatePayrollRequestGovernmentDataLugarGeneracionXML
from openapi_client.models.create_payroll_request_government_data_novedad import CreatePayrollRequestGovernmentDataNovedad
from openapi_client.models.create_payroll_request_government_data_pago import CreatePayrollRequestGovernmentDataPago
from openapi_client.models.create_payroll_request_government_data_periodo import CreatePayrollRequestGovernmentDataPeriodo
from openapi_client.models.create_payroll_request_government_data_trabajador import CreatePayrollRequestGovernmentDataTrabajador
from typing import Optional, Set
from typing_extensions import Self

class CreatePayrollRequestGovernmentData(BaseModel):
    """
    Objeto que contiene la información de la nómina electrónica en formato JSON según el estándar de la DIAN
    """ # noqa: E501
    novedad: Optional[CreatePayrollRequestGovernmentDataNovedad] = Field(default=None, alias="Novedad")
    periodo: CreatePayrollRequestGovernmentDataPeriodo = Field(alias="Periodo")
    lugar_generacion_xml: CreatePayrollRequestGovernmentDataLugarGeneracionXML = Field(alias="LugarGeneracionXML")
    informacion_general: CreatePayrollRequestGovernmentDataInformacionGeneral = Field(alias="InformacionGeneral")
    empleador: CreatePayrollRequestGovernmentDataEmpleador = Field(alias="Empleador")
    trabajador: CreatePayrollRequestGovernmentDataTrabajador = Field(alias="Trabajador")
    pago: CreatePayrollRequestGovernmentDataPago = Field(alias="Pago")
    fechas_pagos: CreatePayrollRequestGovernmentDataFechasPagos = Field(alias="FechasPagos")
    devengados: CreatePayrollRequestGovernmentDataDevengados = Field(alias="Devengados")
    deducciones: CreatePayrollRequestGovernmentDataDeducciones = Field(alias="Deducciones")
    redondeo: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Se utiliza para cuando se utilice el Redondeo en el Documento, Definido en el numeral 1.1.1", alias="Redondeo")
    devengados_total: Union[StrictFloat, StrictInt] = Field(description="Valor total de la Suma de todos los Devengados del Documento", alias="DevengadosTotal")
    deducciones_total: Union[StrictFloat, StrictInt] = Field(description="Valor total de la Suma de todas las Deducciones del Documento", alias="DeduccionesTotal")
    comprobante_total: Union[StrictFloat, StrictInt] = Field(description="Debe ir el total de: Devengados - Deducciones", alias="ComprobanteTotal")
    __properties: ClassVar[List[str]] = ["Novedad", "Periodo", "LugarGeneracionXML", "InformacionGeneral", "Empleador", "Trabajador", "Pago", "FechasPagos", "Devengados", "Deducciones", "Redondeo", "DevengadosTotal", "DeduccionesTotal", "ComprobanteTotal"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePayrollRequestGovernmentData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of novedad
        if self.novedad:
            _dict['Novedad'] = self.novedad.to_dict()
        # override the default output from pydantic by calling `to_dict()` of periodo
        if self.periodo:
            _dict['Periodo'] = self.periodo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lugar_generacion_xml
        if self.lugar_generacion_xml:
            _dict['LugarGeneracionXML'] = self.lugar_generacion_xml.to_dict()
        # override the default output from pydantic by calling `to_dict()` of informacion_general
        if self.informacion_general:
            _dict['InformacionGeneral'] = self.informacion_general.to_dict()
        # override the default output from pydantic by calling `to_dict()` of empleador
        if self.empleador:
            _dict['Empleador'] = self.empleador.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trabajador
        if self.trabajador:
            _dict['Trabajador'] = self.trabajador.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pago
        if self.pago:
            _dict['Pago'] = self.pago.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fechas_pagos
        if self.fechas_pagos:
            _dict['FechasPagos'] = self.fechas_pagos.to_dict()
        # override the default output from pydantic by calling `to_dict()` of devengados
        if self.devengados:
            _dict['Devengados'] = self.devengados.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deducciones
        if self.deducciones:
            _dict['Deducciones'] = self.deducciones.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePayrollRequestGovernmentData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Novedad": CreatePayrollRequestGovernmentDataNovedad.from_dict(obj["Novedad"]) if obj.get("Novedad") is not None else None,
            "Periodo": CreatePayrollRequestGovernmentDataPeriodo.from_dict(obj["Periodo"]) if obj.get("Periodo") is not None else None,
            "LugarGeneracionXML": CreatePayrollRequestGovernmentDataLugarGeneracionXML.from_dict(obj["LugarGeneracionXML"]) if obj.get("LugarGeneracionXML") is not None else None,
            "InformacionGeneral": CreatePayrollRequestGovernmentDataInformacionGeneral.from_dict(obj["InformacionGeneral"]) if obj.get("InformacionGeneral") is not None else None,
            "Empleador": CreatePayrollRequestGovernmentDataEmpleador.from_dict(obj["Empleador"]) if obj.get("Empleador") is not None else None,
            "Trabajador": CreatePayrollRequestGovernmentDataTrabajador.from_dict(obj["Trabajador"]) if obj.get("Trabajador") is not None else None,
            "Pago": CreatePayrollRequestGovernmentDataPago.from_dict(obj["Pago"]) if obj.get("Pago") is not None else None,
            "FechasPagos": CreatePayrollRequestGovernmentDataFechasPagos.from_dict(obj["FechasPagos"]) if obj.get("FechasPagos") is not None else None,
            "Devengados": CreatePayrollRequestGovernmentDataDevengados.from_dict(obj["Devengados"]) if obj.get("Devengados") is not None else None,
            "Deducciones": CreatePayrollRequestGovernmentDataDeducciones.from_dict(obj["Deducciones"]) if obj.get("Deducciones") is not None else None,
            "Redondeo": obj.get("Redondeo"),
            "DevengadosTotal": obj.get("DevengadosTotal"),
            "DeduccionesTotal": obj.get("DeduccionesTotal"),
            "ComprobanteTotal": obj.get("ComprobanteTotal")
        })
        return _obj


