# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreatePayrollRequestGovernmentDataEmpleador(BaseModel):
    """
    Objeto con la información del empleador
    """ # noqa: E501
    razon_social: Optional[StrictStr] = Field(default=None, description="Debe corresponder al Nombre de la Razón Social del Empleador", alias="RazonSocial")
    primer_apellido: Optional[Annotated[str, Field(strict=True, max_length=60)]] = Field(default=None, description="Primer Apellido del empleador", alias="PrimerApellido")
    segundo_apellido: Optional[Annotated[str, Field(strict=True, max_length=60)]] = Field(default=None, description="Segundo Apellido del empleador", alias="SegundoApellido")
    primer_nombre: Optional[Annotated[str, Field(strict=True, max_length=60)]] = Field(default=None, description="Primer Nombre del empleador", alias="PrimerNombre")
    otros_nombres: Optional[Annotated[str, Field(strict=True, max_length=60)]] = Field(default=None, description="Otros Nombres del empleador", alias="OtrosNombres")
    nit: Union[StrictFloat, StrictInt] = Field(description="Debe corresponder al NIT del Empleador que realiza el documento, sin guiones ni DV", alias="NIT")
    dv: Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]] = Field(description="Debe corresponder al DV del NIT del Empleador que realiza el documento", alias="DV")
    pais: Annotated[str, Field(strict=True, max_length=2)] = Field(description="Código del país donde se encuentra ubicada la empresa del empleador en el mes que se esta reportando. Se debe colocar el Codigo que corresponda de la tabla de paises de la DIAN", alias="Pais")
    municipio_ciudad: Annotated[str, Field(strict=True, max_length=5)] = Field(description="Código del municipio o ciudad donde se encuentra ubicada la empresa del empleador en el mes que se esta reportando. Se debe colocar el Codigo que corresponda de la tabla de municipios de la DIAN", alias="MunicipioCiudad")
    direccion: StrictStr = Field(description="Debe corresponder a la dirección del lugar físico de expedición del documento.", alias="Direccion")
    __properties: ClassVar[List[str]] = ["RazonSocial", "PrimerApellido", "SegundoApellido", "PrimerNombre", "OtrosNombres", "NIT", "DV", "Pais", "MunicipioCiudad", "Direccion"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePayrollRequestGovernmentDataEmpleador from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePayrollRequestGovernmentDataEmpleador from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "RazonSocial": obj.get("RazonSocial"),
            "PrimerApellido": obj.get("PrimerApellido"),
            "SegundoApellido": obj.get("SegundoApellido"),
            "PrimerNombre": obj.get("PrimerNombre"),
            "OtrosNombres": obj.get("OtrosNombres"),
            "NIT": obj.get("NIT"),
            "DV": obj.get("DV"),
            "Pais": obj.get("Pais"),
            "MunicipioCiudad": obj.get("MunicipioCiudad"),
            "Direccion": obj.get("Direccion")
        })
        return _obj


