# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class CreateSupportDocumentRequestItemsInnerTaxesInner(BaseModel):
    """
    Objeto que contiene la información tributaria del articulo y/o servicio
    """ # noqa: E501
    tax_code: StrictStr = Field(description="Código o identificador del impuesto. Se debe colocar el Código que corresponda de la tabla de tipos de tributos/impuestos disponibles de la DIAN. <br><i>Campo oficial DIAN &lt;ID&gt;</i>", alias="taxCode")
    tax_amount: Union[StrictFloat, StrictInt] = Field(description="Valor y/o importe del impuesto. <br><i>Campo oficial DIAN &lt;TaxAmount&gt;</i>", alias="taxAmount")
    tax_percentage: StrictStr = Field(description="Porcentaje o tarifa de impuesto. Ejemplo: Para indicar la tarifa general asociada al impuesto de IVA, se debe enviar un porcentaje de 19. <br><i>Campo oficial DIAN &lt;Percent&gt;</i>", alias="taxPercentage")
    taxable_amount: Union[StrictFloat, StrictInt] = Field(description="Base Imponible sobre la que se calcula el valor del impuesto. <br><i>Campo oficial DIAN &lt;TaxableAmount&gt;</i>", alias="taxableAmount")
    __properties: ClassVar[List[str]] = ["taxCode", "taxAmount", "taxPercentage", "taxableAmount"]

    @field_validator('tax_code')
    def tax_code_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['01']):
            raise ValueError("must be one of enum values ('01')")
        return value

    @field_validator('tax_percentage')
    def tax_percentage_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['0', '5', '19', '0.0', '5.0', '19.0', '0.00', '5.00', '19.00']):
            raise ValueError("must be one of enum values ('0', '5', '19', '0.0', '5.0', '19.0', '0.00', '5.00', '19.00')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSupportDocumentRequestItemsInnerTaxesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSupportDocumentRequestItemsInnerTaxesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "taxCode": obj.get("taxCode"),
            "taxAmount": obj.get("taxAmount"),
            "taxPercentage": obj.get("taxPercentage"),
            "taxableAmount": obj.get("taxableAmount")
        })
        return _obj


