# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.get_test_set_by_government_id200_response_emission_government_response import GetTestSetByGovernmentId200ResponseEmissionGovernmentResponse
from typing import Optional, Set
from typing_extensions import Self

class GetTestSetByGovernmentId200ResponseEmission(BaseModel):
    """
    GetTestSetByGovernmentId200ResponseEmission
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Id de nómina electrónica")
    var_date: Optional[datetime] = Field(default=None, description="Fecha de emisión de nómina electrónica", alias="date")
    status: Optional[StrictStr] = Field(default=None, description="Estado de la nómina electrónica")
    legal_status: Optional[StrictStr] = Field(default=None, description="Estado legal de la nómina electrónica ante la DIAN", alias="legalStatus")
    company_identification: Optional[StrictStr] = Field(default=None, description="Identificación de la empresa empleadora", alias="companyIdentification")
    employee_identification: Optional[StrictStr] = Field(default=None, description="Identificación del empleado", alias="employeeIdentification")
    cune: Optional[StrictStr] = Field(default=None, description="Código único de nómina electrónica asignado para el documento")
    prefix: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Prefijo de nómina electrónica")
    number: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Número de nómina electrónica")
    full_number: Optional[StrictStr] = Field(default=None, description="Número de nómina electrónica (Incluye prefijo y número)", alias="fullNumber")
    government_response: Optional[GetTestSetByGovernmentId200ResponseEmissionGovernmentResponse] = Field(default=None, alias="governmentResponse")
    xml_file_name: Optional[StrictStr] = Field(default=None, description="Nombre del archivo XML que se envió a la DIAN", alias="xmlFileName")
    zip_file_name: Optional[StrictStr] = Field(default=None, description="Nombre del archivo Zip que se envió a la DIAN", alias="zipFileName")
    __properties: ClassVar[List[str]] = ["id", "date", "status", "legalStatus", "companyIdentification", "employeeIdentification", "cune", "prefix", "number", "fullNumber", "governmentResponse", "xmlFileName", "zipFileName"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['REGISTERED', 'RETRYING_SEND', 'FAILED', 'SENT', 'CANCELED', 'REPLACED']):
            raise ValueError("must be one of enum values ('REGISTERED', 'RETRYING_SEND', 'FAILED', 'SENT', 'CANCELED', 'REPLACED')")
        return value

    @field_validator('legal_status')
    def legal_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ACCEPTED', 'ACCEPTED_WITH_OBSERVATIONS', 'REJECTED']):
            raise ValueError("must be one of enum values ('ACCEPTED', 'ACCEPTED_WITH_OBSERVATIONS', 'REJECTED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetTestSetByGovernmentId200ResponseEmission from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of government_response
        if self.government_response:
            _dict['governmentResponse'] = self.government_response.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetTestSetByGovernmentId200ResponseEmission from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "date": obj.get("date"),
            "status": obj.get("status"),
            "legalStatus": obj.get("legalStatus"),
            "companyIdentification": obj.get("companyIdentification"),
            "employeeIdentification": obj.get("employeeIdentification"),
            "cune": obj.get("cune"),
            "prefix": obj.get("prefix"),
            "number": obj.get("number"),
            "fullNumber": obj.get("fullNumber"),
            "governmentResponse": GetTestSetByGovernmentId200ResponseEmissionGovernmentResponse.from_dict(obj["governmentResponse"]) if obj.get("governmentResponse") is not None else None,
            "xmlFileName": obj.get("xmlFileName"),
            "zipFileName": obj.get("zipFileName")
        })
        return _obj


