# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.send_email_post_request_email import SendEmailPostRequestEmail
from typing import Optional, Set
from typing_extensions import Self

class SendEmailPostRequest(BaseModel):
    """
    Objeto para poder emitir manualmente un correo electrónico de notificación de un documento electrónico
    """ # noqa: E501
    document_type: StrictStr = Field(description="Código del documento se quiere notificar. Factura (01), Nota Crédito (91), Nota Débito (92),  Documento equivalente POS (20), Evento asociado a factura (96)", alias="documentType")
    document_id: StrictStr = Field(description="id del documento en la API", alias="documentId")
    email: Optional[SendEmailPostRequestEmail] = None
    __properties: ClassVar[List[str]] = ["documentType", "documentId", "email"]

    @field_validator('document_type')
    def document_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['01', '91', '92', '20', '96']):
            raise ValueError("must be one of enum values ('01', '91', '92', '20', '96')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SendEmailPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of email
        if self.email:
            _dict['email'] = self.email.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SendEmailPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "documentType": obj.get("documentType"),
            "documentId": obj.get("documentId"),
            "email": SendEmailPostRequestEmail.from_dict(obj["email"]) if obj.get("email") is not None else None
        })
        return _obj


