"""
    The api of the tek ekg boxes and field controller.

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gewv_sides_client.api_client import ApiClient, Endpoint as _Endpoint
from gewv_sides_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gewv_sides_client.model.array_of_boxes import ArrayOfBoxes
from gewv_sides_client.model.array_of_fieldtests import ArrayOfFieldtests
from gewv_sides_client.model.array_of_logs import ArrayOfLogs
from gewv_sides_client.model.array_of_measur_services import ArrayOfMeasurServices
from gewv_sides_client.model.box import Box
from gewv_sides_client.model.box_prototype import BoxPrototype
from gewv_sides_client.model.energy_type import EnergyType
from gewv_sides_client.model.id import ID
from gewv_sides_client.model.inline_object2 import InlineObject2
from gewv_sides_client.model.inline_object3 import InlineObject3
from gewv_sides_client.model.inline_object5 import InlineObject5
from gewv_sides_client.model.log import Log
from gewv_sides_client.model.log_prototype import LogPrototype
from gewv_sides_client.model.measur_service import MeasurService
from gewv_sides_client.model.measur_service_prototype import MeasurServicePrototype
from gewv_sides_client.model.measur_service_update import MeasurServiceUpdate
from gewv_sides_client.model.service_type import ServiceType


class BoxesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_box(
            self,
            box_prototype,
            **kwargs
        ):
            """create_box  # noqa: E501

            Create a new box.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_box(box_prototype, async_req=True)
            >>> result = thread.get()

            Args:
                box_prototype (BoxPrototype): The new box, that will be created!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Box
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_prototype'] = \
                box_prototype
            return self.call_with_http_info(**kwargs)

        self.create_box = _Endpoint(
            settings={
                'response_type': (Box,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes',
                'operation_id': 'create_box',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_prototype',
                ],
                'required': [
                    'box_prototype',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_prototype':
                        (BoxPrototype,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'box_prototype': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_box
        )

        def __create_log(
            self,
            box_id,
            measur_service_id,
            log_prototype,
            **kwargs
        ):
            """create_log  # noqa: E501

            Create a new log for a service.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_log(box_id, measur_service_id, log_prototype, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):
                measur_service_id (ID):
                log_prototype (LogPrototype): The new log that will be created!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Log
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            kwargs['measur_service_id'] = \
                measur_service_id
            kwargs['log_prototype'] = \
                log_prototype
            return self.call_with_http_info(**kwargs)

        self.create_log = _Endpoint(
            settings={
                'response_type': (Log,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/measur_services/{measurServiceId}/log',
                'operation_id': 'create_log',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'measur_service_id',
                    'log_prototype',
                ],
                'required': [
                    'box_id',
                    'measur_service_id',
                    'log_prototype',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'measur_service_id':
                        (ID,),
                    'log_prototype':
                        (LogPrototype,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                    'measur_service_id': 'measurServiceId',
                },
                'location_map': {
                    'box_id': 'path',
                    'measur_service_id': 'path',
                    'log_prototype': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_log
        )

        def __create_measur_service(
            self,
            box_id,
            measur_service_prototype,
            **kwargs
        ):
            """create_measur_service  # noqa: E501

            Create new service for a box  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_measur_service(box_id, measur_service_prototype, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):
                measur_service_prototype (MeasurServicePrototype): The new service, that will be created!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MeasurService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            kwargs['measur_service_prototype'] = \
                measur_service_prototype
            return self.call_with_http_info(**kwargs)

        self.create_measur_service = _Endpoint(
            settings={
                'response_type': (MeasurService,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/measur_services',
                'operation_id': 'create_measur_service',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'measur_service_prototype',
                ],
                'required': [
                    'box_id',
                    'measur_service_prototype',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'measur_service_prototype':
                        (MeasurServicePrototype,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                    'measur_service_prototype': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_measur_service
        )

        def __delete_application_variable(
            self,
            application_name,
            inline_object5,
            **kwargs
        ):
            """delete_application_variable  # noqa: E501

            Delete a variable of application.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_application_variable(application_name, inline_object5, async_req=True)
            >>> result = thread.get()

            Args:
                application_name (str):
                inline_object5 (InlineObject5):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['application_name'] = \
                application_name
            kwargs['inline_object5'] = \
                inline_object5
            return self.call_with_http_info(**kwargs)

        self.delete_application_variable = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/applications/{applicationName}/variables',
                'operation_id': 'delete_application_variable',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'application_name',
                    'inline_object5',
                ],
                'required': [
                    'application_name',
                    'inline_object5',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'application_name':
                        (str,),
                    'inline_object5':
                        (InlineObject5,),
                },
                'attribute_map': {
                    'application_name': 'applicationName',
                },
                'location_map': {
                    'application_name': 'path',
                    'inline_object5': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_application_variable
        )

        def __delete_box(
            self,
            box_id,
            **kwargs
        ):
            """delete_box  # noqa: E501

            Delete a box  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_box(box_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            return self.call_with_http_info(**kwargs)

        self.delete_box = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}',
                'operation_id': 'delete_box',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                ],
                'required': [
                    'box_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_box
        )

        def __delete_box_variable(
            self,
            box_id,
            inline_object3,
            **kwargs
        ):
            """delete_box_variable  # noqa: E501

            Delete a variable of box.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_box_variable(box_id, inline_object3, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):
                inline_object3 (InlineObject3):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            kwargs['inline_object3'] = \
                inline_object3
            return self.call_with_http_info(**kwargs)

        self.delete_box_variable = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/variables',
                'operation_id': 'delete_box_variable',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'inline_object3',
                ],
                'required': [
                    'box_id',
                    'inline_object3',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'inline_object3':
                        (InlineObject3,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                    'inline_object3': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_box_variable
        )

        def __delete_measur_service(
            self,
            box_id,
            measur_service_id,
            **kwargs
        ):
            """delete_measur_service  # noqa: E501

            Delete a measure service.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_measur_service(box_id, measur_service_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):
                measur_service_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            kwargs['measur_service_id'] = \
                measur_service_id
            return self.call_with_http_info(**kwargs)

        self.delete_measur_service = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/measur_services/{measurServiceId}',
                'operation_id': 'delete_measur_service',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'measur_service_id',
                ],
                'required': [
                    'box_id',
                    'measur_service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'measur_service_id':
                        (ID,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                    'measur_service_id': 'measurServiceId',
                },
                'location_map': {
                    'box_id': 'path',
                    'measur_service_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_measur_service
        )

        def __get_box(
            self,
            box_id,
            **kwargs
        ):
            """get_box  # noqa: E501

            Get a box per id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_box(box_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Box
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            return self.call_with_http_info(**kwargs)

        self.get_box = _Endpoint(
            settings={
                'response_type': (Box,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}',
                'operation_id': 'get_box',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                ],
                'required': [
                    'box_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_box
        )

        def __get_box_config(
            self,
            box_id,
            **kwargs
        ):
            """get_box_config  # noqa: E501

            Get config of a box.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_box_config(box_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            return self.call_with_http_info(**kwargs)

        self.get_box_config = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/config',
                'operation_id': 'get_box_config',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                ],
                'required': [
                    'box_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_box_config
        )

        def __get_box_device(
            self,
            box_id,
            **kwargs
        ):
            """get_box_device  # noqa: E501

            Get the belonging device of the box.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_box_device(box_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            return self.call_with_http_info(**kwargs)

        self.get_box_device = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/device',
                'operation_id': 'get_box_device',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                ],
                'required': [
                    'box_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_box_device
        )

        def __get_box_legacy(
            self,
            box_id,
            **kwargs
        ):
            """get_box_legacy  # noqa: E501

            Get a box per id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_box_legacy(box_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            return self.call_with_http_info(**kwargs)

        self.get_box_legacy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes_legacy/{boxId}',
                'operation_id': 'get_box_legacy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                ],
                'required': [
                    'box_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (str,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_box_legacy
        )

        def __get_box_variables(
            self,
            box_id,
            **kwargs
        ):
            """get_box_variables  # noqa: E501

            Get variables of a box.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_box_variables(box_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            return self.call_with_http_info(**kwargs)

        self.get_box_variables = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/variables',
                'operation_id': 'get_box_variables',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                ],
                'required': [
                    'box_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_box_variables
        )

        def __get_boxes(
            self,
            **kwargs
        ):
            """get_boxes  # noqa: E501

            Get boxes.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_boxes(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                enery_type (EnergyType): the energy type of the device. [optional]
                hardware_id (str): The hardware id of a box. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ArrayOfBoxes
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_boxes = _Endpoint(
            settings={
                'response_type': (ArrayOfBoxes,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes',
                'operation_id': 'get_boxes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'enery_type',
                    'hardware_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'enery_type':
                        (EnergyType,),
                    'hardware_id':
                        (str,),
                },
                'attribute_map': {
                    'enery_type': 'enery_type',
                    'hardware_id': 'hardware_id',
                },
                'location_map': {
                    'enery_type': 'query',
                    'hardware_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_boxes
        )

        def __get_boxes_legacy(
            self,
            **kwargs
        ):
            """get_boxes_legacy  # noqa: E501

            Get boxes.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_boxes_legacy(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                enery_type (EnergyType): the energy type of the device. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ArrayOfFieldtests
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_boxes_legacy = _Endpoint(
            settings={
                'response_type': (ArrayOfFieldtests,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes_legacy',
                'operation_id': 'get_boxes_legacy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'enery_type',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'enery_type':
                        (EnergyType,),
                },
                'attribute_map': {
                    'enery_type': 'enery_type',
                },
                'location_map': {
                    'enery_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_boxes_legacy
        )

        def __get_boxes_of_datapoint(
            self,
            building_id,
            device_id,
            **kwargs
        ):
            """get_boxes_of_datapoint  # noqa: E501

            Get the connected boxes of the device.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_boxes_of_datapoint(building_id, device_id, async_req=True)
            >>> result = thread.get()

            Args:
                building_id (ID):
                device_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [Box]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['building_id'] = \
                building_id
            kwargs['device_id'] = \
                device_id
            return self.call_with_http_info(**kwargs)

        self.get_boxes_of_datapoint = _Endpoint(
            settings={
                'response_type': ([Box],),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/buildings/{buildingId}/devices/{deviceId}/boxes',
                'operation_id': 'get_boxes_of_datapoint',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'building_id',
                    'device_id',
                ],
                'required': [
                    'building_id',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'building_id':
                        (ID,),
                    'device_id':
                        (ID,),
                },
                'attribute_map': {
                    'building_id': 'buildingId',
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'building_id': 'path',
                    'device_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_boxes_of_datapoint
        )

        def __get_logs(
            self,
            box_id,
            measur_service_id,
            **kwargs
        ):
            """get_logs  # noqa: E501

            Get all logs of a service.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_logs(box_id, measur_service_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):
                measur_service_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ArrayOfLogs
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            kwargs['measur_service_id'] = \
                measur_service_id
            return self.call_with_http_info(**kwargs)

        self.get_logs = _Endpoint(
            settings={
                'response_type': (ArrayOfLogs,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/measur_services/{measurServiceId}/log',
                'operation_id': 'get_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'measur_service_id',
                ],
                'required': [
                    'box_id',
                    'measur_service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'measur_service_id':
                        (ID,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                    'measur_service_id': 'measurServiceId',
                },
                'location_map': {
                    'box_id': 'path',
                    'measur_service_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_logs
        )

        def __get_measur_service(
            self,
            box_id,
            measur_service_id,
            **kwargs
        ):
            """get_measur_service  # noqa: E501

            Get the service with the service id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_measur_service(box_id, measur_service_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):
                measur_service_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MeasurService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            kwargs['measur_service_id'] = \
                measur_service_id
            return self.call_with_http_info(**kwargs)

        self.get_measur_service = _Endpoint(
            settings={
                'response_type': (MeasurService,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/measur_services/{measurServiceId}',
                'operation_id': 'get_measur_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'measur_service_id',
                ],
                'required': [
                    'box_id',
                    'measur_service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'measur_service_id':
                        (ID,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                    'measur_service_id': 'measurServiceId',
                },
                'location_map': {
                    'box_id': 'path',
                    'measur_service_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_measur_service
        )

        def __get_measur_services(
            self,
            box_id,
            **kwargs
        ):
            """get_measur_services  # noqa: E501

            Get services of a box.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_measur_services(box_id, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):

            Keyword Args:
                service_type (ServiceType): the type of measur service. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ArrayOfMeasurServices
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            return self.call_with_http_info(**kwargs)

        self.get_measur_services = _Endpoint(
            settings={
                'response_type': (ArrayOfMeasurServices,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/measur_services',
                'operation_id': 'get_measur_services',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'service_type',
                ],
                'required': [
                    'box_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'service_type':
                        (ServiceType,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                    'service_type': 'service_type',
                },
                'location_map': {
                    'box_id': 'path',
                    'service_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_measur_services
        )

        def __update_box(
            self,
            box_id,
            box_prototype,
            **kwargs
        ):
            """update_box  # noqa: E501

            Update a box  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_box(box_id, box_prototype, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):
                box_prototype (BoxPrototype): The update of the box!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Box
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            kwargs['box_prototype'] = \
                box_prototype
            return self.call_with_http_info(**kwargs)

        self.update_box = _Endpoint(
            settings={
                'response_type': (Box,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}',
                'operation_id': 'update_box',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'box_prototype',
                ],
                'required': [
                    'box_id',
                    'box_prototype',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'box_prototype':
                        (BoxPrototype,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                    'box_prototype': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_box
        )

        def __update_box_variable(
            self,
            box_id,
            inline_object2,
            **kwargs
        ):
            """update_box_variable  # noqa: E501

            Update a variable of box.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_box_variable(box_id, inline_object2, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):
                inline_object2 (InlineObject2):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            kwargs['inline_object2'] = \
                inline_object2
            return self.call_with_http_info(**kwargs)

        self.update_box_variable = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/variables',
                'operation_id': 'update_box_variable',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'inline_object2',
                ],
                'required': [
                    'box_id',
                    'inline_object2',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'inline_object2':
                        (InlineObject2,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                },
                'location_map': {
                    'box_id': 'path',
                    'inline_object2': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_box_variable
        )

        def __update_measur_service(
            self,
            box_id,
            measur_service_id,
            measur_service_update,
            **kwargs
        ):
            """update_measur_service  # noqa: E501

            Update a existing measure service.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_measur_service(box_id, measur_service_id, measur_service_update, async_req=True)
            >>> result = thread.get()

            Args:
                box_id (ID):
                measur_service_id (ID):
                measur_service_update (MeasurServiceUpdate): The measur service update!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MeasurService
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['box_id'] = \
                box_id
            kwargs['measur_service_id'] = \
                measur_service_id
            kwargs['measur_service_update'] = \
                measur_service_update
            return self.call_with_http_info(**kwargs)

        self.update_measur_service = _Endpoint(
            settings={
                'response_type': (MeasurService,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/boxes/{boxId}/measur_services/{measurServiceId}',
                'operation_id': 'update_measur_service',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'box_id',
                    'measur_service_id',
                    'measur_service_update',
                ],
                'required': [
                    'box_id',
                    'measur_service_id',
                    'measur_service_update',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'box_id':
                        (ID,),
                    'measur_service_id':
                        (ID,),
                    'measur_service_update':
                        (MeasurServiceUpdate,),
                },
                'attribute_map': {
                    'box_id': 'boxId',
                    'measur_service_id': 'measurServiceId',
                },
                'location_map': {
                    'box_id': 'path',
                    'measur_service_id': 'path',
                    'measur_service_update': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_measur_service
        )
