"""
    The api of the tek ekg boxes and field controller.

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gewv_sides_client.api_client import ApiClient, Endpoint as _Endpoint
from gewv_sides_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gewv_sides_client.model.array_of_buildings import ArrayOfBuildings
from gewv_sides_client.model.building import Building
from gewv_sides_client.model.id import ID


class BuildingsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_building(
            self,
            fieldtest_id,
            building,
            **kwargs
        ):
            """create_building  # noqa: E501

            Create a new building for a fieldtest.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_building(fieldtest_id, building, async_req=True)
            >>> result = thread.get()

            Args:
                fieldtest_id (ID):
                building (Building): The new building, that will be created!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Building
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['fieldtest_id'] = \
                fieldtest_id
            kwargs['building'] = \
                building
            return self.call_with_http_info(**kwargs)

        self.create_building = _Endpoint(
            settings={
                'response_type': (Building,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/fieldtests/{fieldtestId}/buildings',
                'operation_id': 'create_building',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'fieldtest_id',
                    'building',
                ],
                'required': [
                    'fieldtest_id',
                    'building',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'fieldtest_id':
                        (ID,),
                    'building':
                        (Building,),
                },
                'attribute_map': {
                    'fieldtest_id': 'fieldtestId',
                },
                'location_map': {
                    'fieldtest_id': 'path',
                    'building': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_building
        )

        def __get_buildings(
            self,
            fieldtest_id,
            **kwargs
        ):
            """get_buildings  # noqa: E501

            Get all buildings of a fieldtest.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_buildings(fieldtest_id, async_req=True)
            >>> result = thread.get()

            Args:
                fieldtest_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ArrayOfBuildings
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['fieldtest_id'] = \
                fieldtest_id
            return self.call_with_http_info(**kwargs)

        self.get_buildings = _Endpoint(
            settings={
                'response_type': (ArrayOfBuildings,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/fieldtests/{fieldtestId}/buildings',
                'operation_id': 'get_buildings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'fieldtest_id',
                ],
                'required': [
                    'fieldtest_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'fieldtest_id':
                        (ID,),
                },
                'attribute_map': {
                    'fieldtest_id': 'fieldtestId',
                },
                'location_map': {
                    'fieldtest_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_buildings
        )
