"""
    The api of the tek ekg boxes and field controller.

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gewv_sides_client.api_client import ApiClient, Endpoint as _Endpoint
from gewv_sides_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gewv_sides_client.model.array_of_devices import ArrayOfDevices
from gewv_sides_client.model.box import Box
from gewv_sides_client.model.device import Device
from gewv_sides_client.model.id import ID


class DevicesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_device(
            self,
            building_id,
            device,
            **kwargs
        ):
            """create_device  # noqa: E501

            Create a new device for a building.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_device(building_id, device, async_req=True)
            >>> result = thread.get()

            Args:
                building_id (ID):
                device (Device): The new device, that will be created!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Device
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['building_id'] = \
                building_id
            kwargs['device'] = \
                device
            return self.call_with_http_info(**kwargs)

        self.create_device = _Endpoint(
            settings={
                'response_type': (Device,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/buildings/{buildingId}/devices',
                'operation_id': 'create_device',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'building_id',
                    'device',
                ],
                'required': [
                    'building_id',
                    'device',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'building_id':
                        (ID,),
                    'device':
                        (Device,),
                },
                'attribute_map': {
                    'building_id': 'buildingId',
                },
                'location_map': {
                    'building_id': 'path',
                    'device': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_device
        )

        def __delete_device(
            self,
            building_id,
            device_id,
            **kwargs
        ):
            """delete_device  # noqa: E501

            Delete a contact.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_device(building_id, device_id, async_req=True)
            >>> result = thread.get()

            Args:
                building_id (ID):
                device_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['building_id'] = \
                building_id
            kwargs['device_id'] = \
                device_id
            return self.call_with_http_info(**kwargs)

        self.delete_device = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/buildings/{buildingId}/devices/{deviceId}',
                'operation_id': 'delete_device',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'building_id',
                    'device_id',
                ],
                'required': [
                    'building_id',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'building_id':
                        (ID,),
                    'device_id':
                        (ID,),
                },
                'attribute_map': {
                    'building_id': 'buildingId',
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'building_id': 'path',
                    'device_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_device
        )

        def __get_boxes_of_datapoint(
            self,
            building_id,
            device_id,
            **kwargs
        ):
            """get_boxes_of_datapoint  # noqa: E501

            Get the connected boxes of the device.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_boxes_of_datapoint(building_id, device_id, async_req=True)
            >>> result = thread.get()

            Args:
                building_id (ID):
                device_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [Box]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['building_id'] = \
                building_id
            kwargs['device_id'] = \
                device_id
            return self.call_with_http_info(**kwargs)

        self.get_boxes_of_datapoint = _Endpoint(
            settings={
                'response_type': ([Box],),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/buildings/{buildingId}/devices/{deviceId}/boxes',
                'operation_id': 'get_boxes_of_datapoint',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'building_id',
                    'device_id',
                ],
                'required': [
                    'building_id',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'building_id':
                        (ID,),
                    'device_id':
                        (ID,),
                },
                'attribute_map': {
                    'building_id': 'buildingId',
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'building_id': 'path',
                    'device_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_boxes_of_datapoint
        )

        def __get_datapoint_names(
            self,
            building_id,
            device_id,
            **kwargs
        ):
            """get_datapoint_names  # noqa: E501

            Get datapoint names of the connected boxes.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_datapoint_names(building_id, device_id, async_req=True)
            >>> result = thread.get()

            Args:
                building_id (ID):
                device_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [str]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['building_id'] = \
                building_id
            kwargs['device_id'] = \
                device_id
            return self.call_with_http_info(**kwargs)

        self.get_datapoint_names = _Endpoint(
            settings={
                'response_type': ([str],),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/buildings/{buildingId}/devices/{deviceId}/getDatapointNames',
                'operation_id': 'get_datapoint_names',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'building_id',
                    'device_id',
                ],
                'required': [
                    'building_id',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'building_id':
                        (ID,),
                    'device_id':
                        (ID,),
                },
                'attribute_map': {
                    'building_id': 'buildingId',
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'building_id': 'path',
                    'device_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_datapoint_names
        )

        def __get_device(
            self,
            building_id,
            device_id,
            device,
            **kwargs
        ):
            """get_device  # noqa: E501

            Get a device.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_device(building_id, device_id, device, async_req=True)
            >>> result = thread.get()

            Args:
                building_id (ID):
                device_id (ID):
                device (Device): The device to update!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Device
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['building_id'] = \
                building_id
            kwargs['device_id'] = \
                device_id
            kwargs['device'] = \
                device
            return self.call_with_http_info(**kwargs)

        self.get_device = _Endpoint(
            settings={
                'response_type': (Device,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/buildings/{buildingId}/devices/{deviceId}',
                'operation_id': 'get_device',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'building_id',
                    'device_id',
                    'device',
                ],
                'required': [
                    'building_id',
                    'device_id',
                    'device',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'building_id':
                        (ID,),
                    'device_id':
                        (ID,),
                    'device':
                        (Device,),
                },
                'attribute_map': {
                    'building_id': 'buildingId',
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'building_id': 'path',
                    'device_id': 'path',
                    'device': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_device
        )

        def __get_devices(
            self,
            building_id,
            **kwargs
        ):
            """get_devices  # noqa: E501

            Get all devices of a building.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_devices(building_id, async_req=True)
            >>> result = thread.get()

            Args:
                building_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ArrayOfDevices
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['building_id'] = \
                building_id
            return self.call_with_http_info(**kwargs)

        self.get_devices = _Endpoint(
            settings={
                'response_type': (ArrayOfDevices,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/buildings/{buildingId}/devices',
                'operation_id': 'get_devices',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'building_id',
                ],
                'required': [
                    'building_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'building_id':
                        (ID,),
                },
                'attribute_map': {
                    'building_id': 'buildingId',
                },
                'location_map': {
                    'building_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_devices
        )

        def __update_device(
            self,
            building_id,
            device_id,
            device,
            **kwargs
        ):
            """update_device  # noqa: E501

            Update a existing device.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_device(building_id, device_id, device, async_req=True)
            >>> result = thread.get()

            Args:
                building_id (ID):
                device_id (ID):
                device (Device): The device to update!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Device
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['building_id'] = \
                building_id
            kwargs['device_id'] = \
                device_id
            kwargs['device'] = \
                device
            return self.call_with_http_info(**kwargs)

        self.update_device = _Endpoint(
            settings={
                'response_type': (Device,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/buildings/{buildingId}/devices/{deviceId}',
                'operation_id': 'update_device',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'building_id',
                    'device_id',
                    'device',
                ],
                'required': [
                    'building_id',
                    'device_id',
                    'device',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'building_id':
                        (ID,),
                    'device_id':
                        (ID,),
                    'device':
                        (Device,),
                },
                'attribute_map': {
                    'building_id': 'buildingId',
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'building_id': 'path',
                    'device_id': 'path',
                    'device': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_device
        )
