"""
    The api of the tek ekg boxes and field controller.

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gewv_sides_client.api_client import ApiClient, Endpoint as _Endpoint
from gewv_sides_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gewv_sides_client.model.array_of_readings import ArrayOfReadings
from gewv_sides_client.model.building import Building
from gewv_sides_client.model.id import ID
from gewv_sides_client.model.reading import Reading


class MetersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_reading(
            self,
            meter_id,
            reading,
            **kwargs
        ):
            """create_reading  # noqa: E501

            Create a new reading for a meter.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_reading(meter_id, reading, async_req=True)
            >>> result = thread.get()

            Args:
                meter_id (ID):
                reading (Reading): The new reading, that will be created!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Reading
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['meter_id'] = \
                meter_id
            kwargs['reading'] = \
                reading
            return self.call_with_http_info(**kwargs)

        self.create_reading = _Endpoint(
            settings={
                'response_type': (Reading,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/meters/{meterId}/readings',
                'operation_id': 'create_reading',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'meter_id',
                    'reading',
                ],
                'required': [
                    'meter_id',
                    'reading',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'meter_id':
                        (ID,),
                    'reading':
                        (Reading,),
                },
                'attribute_map': {
                    'meter_id': 'meterId',
                },
                'location_map': {
                    'meter_id': 'path',
                    'reading': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_reading
        )

        def __delete_reading(
            self,
            meter_id,
            reading_id,
            **kwargs
        ):
            """delete_reading  # noqa: E501

            Delete a reading of a meter.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_reading(meter_id, reading_id, async_req=True)
            >>> result = thread.get()

            Args:
                meter_id (ID):
                reading_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Building
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['meter_id'] = \
                meter_id
            kwargs['reading_id'] = \
                reading_id
            return self.call_with_http_info(**kwargs)

        self.delete_reading = _Endpoint(
            settings={
                'response_type': (Building,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/meters/{meterId}/readings/{readingId}',
                'operation_id': 'delete_reading',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'meter_id',
                    'reading_id',
                ],
                'required': [
                    'meter_id',
                    'reading_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'meter_id':
                        (ID,),
                    'reading_id':
                        (ID,),
                },
                'attribute_map': {
                    'meter_id': 'meterId',
                    'reading_id': 'readingId',
                },
                'location_map': {
                    'meter_id': 'path',
                    'reading_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_reading
        )

        def __get_readings(
            self,
            meter_id,
            **kwargs
        ):
            """get_readings  # noqa: E501

            Get all readings of meter.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_readings(meter_id, async_req=True)
            >>> result = thread.get()

            Args:
                meter_id (ID):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ArrayOfReadings
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['meter_id'] = \
                meter_id
            return self.call_with_http_info(**kwargs)

        self.get_readings = _Endpoint(
            settings={
                'response_type': (ArrayOfReadings,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/meters/{meterId}/readings',
                'operation_id': 'get_readings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'meter_id',
                ],
                'required': [
                    'meter_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'meter_id':
                        (ID,),
                },
                'attribute_map': {
                    'meter_id': 'meterId',
                },
                'location_map': {
                    'meter_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_readings
        )

        def __upsert_reading(
            self,
            meter_id,
            reading_id,
            reading,
            **kwargs
        ):
            """upsert_reading  # noqa: E501

            Create or update a new reading for a meter.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.upsert_reading(meter_id, reading_id, reading, async_req=True)
            >>> result = thread.get()

            Args:
                meter_id (ID):
                reading_id (ID):
                reading (Reading): The new reading, that will be created or updated!

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Reading
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['meter_id'] = \
                meter_id
            kwargs['reading_id'] = \
                reading_id
            kwargs['reading'] = \
                reading
            return self.call_with_http_info(**kwargs)

        self.upsert_reading = _Endpoint(
            settings={
                'response_type': (Reading,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/meters/{meterId}/readings/{readingId}',
                'operation_id': 'upsert_reading',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'meter_id',
                    'reading_id',
                    'reading',
                ],
                'required': [
                    'meter_id',
                    'reading_id',
                    'reading',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'meter_id':
                        (ID,),
                    'reading_id':
                        (ID,),
                    'reading':
                        (Reading,),
                },
                'attribute_map': {
                    'meter_id': 'meterId',
                    'reading_id': 'readingId',
                },
                'location_map': {
                    'meter_id': 'path',
                    'reading_id': 'path',
                    'reading': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__upsert_reading
        )
