/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#comment Database#comment}
    */
    readonly comment?: string;
    /**
    * Number of days for which Snowflake retains historical data for performing Time Travel actions (SELECT, CLONE, UNDROP) on the object. A value of 0 effectively disables Time Travel for the specified database, schema, or table. For more information, see Understanding & Using Time Travel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#data_retention_time_in_days Database#data_retention_time_in_days}
    */
    readonly dataRetentionTimeInDays?: number;
    /**
    * Specify a database to create a clone from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#from_database Database#from_database}
    */
    readonly fromDatabase?: string;
    /**
    * Specify a fully-qualified path to a database to create a replica from. A fully qualified path follows the format of "<organization_name>"."<account_name>"."<db_name>". An example would be: "myorg1"."account1"."db1"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#from_replica Database#from_replica}
    */
    readonly fromReplica?: string;
    /**
    * Specify a provider and a share in this map to create a database from a share.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#from_share Database#from_share}
    */
    readonly fromShare?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#id Database#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies a database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#is_transient Database#is_transient}
    */
    readonly isTransient?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#name Database#name}
    */
    readonly name: string;
    /**
    * replication_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#replication_configuration Database#replication_configuration}
    */
    readonly replicationConfiguration?: DatabaseReplicationConfiguration;
}
export interface DatabaseReplicationConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#accounts Database#accounts}
    */
    readonly accounts: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#ignore_edition_check Database#ignore_edition_check}
    */
    readonly ignoreEditionCheck?: boolean | cdktf.IResolvable;
}
export declare function databaseReplicationConfigurationToTerraform(struct?: DatabaseReplicationConfigurationOutputReference | DatabaseReplicationConfiguration): any;
export declare function databaseReplicationConfigurationToHclTerraform(struct?: DatabaseReplicationConfigurationOutputReference | DatabaseReplicationConfiguration): any;
export declare class DatabaseReplicationConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseReplicationConfiguration | undefined;
    set internalValue(value: DatabaseReplicationConfiguration | undefined);
    private _accounts?;
    get accounts(): string[];
    set accounts(value: string[]);
    get accountsInput(): string[] | undefined;
    private _ignoreEditionCheck?;
    get ignoreEditionCheck(): boolean | cdktf.IResolvable;
    set ignoreEditionCheck(value: boolean | cdktf.IResolvable);
    resetIgnoreEditionCheck(): void;
    get ignoreEditionCheckInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database snowflake_database}
*/
export declare class Database extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_database";
    /**
    * Generates CDKTF code for importing a Database resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Database to import
    * @param importFromId The id of the existing Database that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Database to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.85.0/docs/resources/database snowflake_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataRetentionTimeInDays?;
    get dataRetentionTimeInDays(): number;
    set dataRetentionTimeInDays(value: number);
    resetDataRetentionTimeInDays(): void;
    get dataRetentionTimeInDaysInput(): number | undefined;
    private _fromDatabase?;
    get fromDatabase(): string;
    set fromDatabase(value: string);
    resetFromDatabase(): void;
    get fromDatabaseInput(): string | undefined;
    private _fromReplica?;
    get fromReplica(): string;
    set fromReplica(value: string);
    resetFromReplica(): void;
    get fromReplicaInput(): string | undefined;
    private _fromShare?;
    get fromShare(): {
        [key: string]: string;
    };
    set fromShare(value: {
        [key: string]: string;
    });
    resetFromShare(): void;
    get fromShareInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isTransient?;
    get isTransient(): boolean | cdktf.IResolvable;
    set isTransient(value: boolean | cdktf.IResolvable);
    resetIsTransient(): void;
    get isTransientInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _replicationConfiguration;
    get replicationConfiguration(): DatabaseReplicationConfigurationOutputReference;
    putReplicationConfiguration(value: DatabaseReplicationConfiguration): void;
    resetReplicationConfiguration(): void;
    get replicationConfigurationInput(): DatabaseReplicationConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
